/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.CloudFormationStepSummary;
import software.amazon.awssdk.services.apptest.model.M2ManagedApplicationStepSummary;
import software.amazon.awssdk.services.apptest.model.M2NonManagedApplicationStepSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceActionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceActionSummary> {
    private static final SdkField<CloudFormationStepSummary> CLOUD_FORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudFormation").getter(ResourceActionSummary.getter(ResourceActionSummary::cloudFormation)).setter(ResourceActionSummary.setter(Builder::cloudFormation)).constructor(CloudFormationStepSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudFormation").build()}).build();
    private static final SdkField<M2ManagedApplicationStepSummary> M2_MANAGED_APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("m2ManagedApplication").getter(ResourceActionSummary.getter(ResourceActionSummary::m2ManagedApplication)).setter(ResourceActionSummary.setter(Builder::m2ManagedApplication)).constructor(M2ManagedApplicationStepSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2ManagedApplication").build()}).build();
    private static final SdkField<M2NonManagedApplicationStepSummary> M2_NON_MANAGED_APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("m2NonManagedApplication").getter(ResourceActionSummary.getter(ResourceActionSummary::m2NonManagedApplication)).setter(ResourceActionSummary.setter(Builder::m2NonManagedApplication)).constructor(M2NonManagedApplicationStepSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2NonManagedApplication").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_FIELD, M2_MANAGED_APPLICATION_FIELD, M2_NON_MANAGED_APPLICATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final CloudFormationStepSummary cloudFormation;
    private final M2ManagedApplicationStepSummary m2ManagedApplication;
    private final M2NonManagedApplicationStepSummary m2NonManagedApplication;
    private final Type type;

    private ResourceActionSummary(BuilderImpl builder) {
        this.cloudFormation = builder.cloudFormation;
        this.m2ManagedApplication = builder.m2ManagedApplication;
        this.m2NonManagedApplication = builder.m2NonManagedApplication;
        this.type = builder.type;
    }

    public final CloudFormationStepSummary cloudFormation() {
        return this.cloudFormation;
    }

    public final M2ManagedApplicationStepSummary m2ManagedApplication() {
        return this.m2ManagedApplication;
    }

    public final M2NonManagedApplicationStepSummary m2NonManagedApplication() {
        return this.m2NonManagedApplication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFormation());
        hashCode = 31 * hashCode + Objects.hashCode(this.m2ManagedApplication());
        hashCode = 31 * hashCode + Objects.hashCode(this.m2NonManagedApplication());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceActionSummary)) {
            return false;
        }
        ResourceActionSummary other = (ResourceActionSummary)obj;
        return Objects.equals(this.cloudFormation(), other.cloudFormation()) && Objects.equals(this.m2ManagedApplication(), other.m2ManagedApplication()) && Objects.equals(this.m2NonManagedApplication(), other.m2NonManagedApplication());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceActionSummary").add("CloudFormation", (Object)this.cloudFormation()).add("M2ManagedApplication", (Object)this.m2ManagedApplication()).add("M2NonManagedApplication", (Object)this.m2NonManagedApplication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudFormation": {
                return Optional.ofNullable(clazz.cast(this.cloudFormation()));
            }
            case "m2ManagedApplication": {
                return Optional.ofNullable(clazz.cast(this.m2ManagedApplication()));
            }
            case "m2NonManagedApplication": {
                return Optional.ofNullable(clazz.cast(this.m2NonManagedApplication()));
            }
        }
        return Optional.empty();
    }

    public static ResourceActionSummary fromCloudFormation(CloudFormationStepSummary cloudFormation) {
        return (ResourceActionSummary)ResourceActionSummary.builder().cloudFormation(cloudFormation).build();
    }

    public static ResourceActionSummary fromCloudFormation(Consumer<CloudFormationStepSummary.Builder> cloudFormation) {
        CloudFormationStepSummary.Builder builder = CloudFormationStepSummary.builder();
        cloudFormation.accept(builder);
        return ResourceActionSummary.fromCloudFormation((CloudFormationStepSummary)builder.build());
    }

    public static ResourceActionSummary fromM2ManagedApplication(M2ManagedApplicationStepSummary m2ManagedApplication) {
        return (ResourceActionSummary)ResourceActionSummary.builder().m2ManagedApplication(m2ManagedApplication).build();
    }

    public static ResourceActionSummary fromM2ManagedApplication(Consumer<M2ManagedApplicationStepSummary.Builder> m2ManagedApplication) {
        M2ManagedApplicationStepSummary.Builder builder = M2ManagedApplicationStepSummary.builder();
        m2ManagedApplication.accept(builder);
        return ResourceActionSummary.fromM2ManagedApplication((M2ManagedApplicationStepSummary)builder.build());
    }

    public static ResourceActionSummary fromM2NonManagedApplication(M2NonManagedApplicationStepSummary m2NonManagedApplication) {
        return (ResourceActionSummary)ResourceActionSummary.builder().m2NonManagedApplication(m2NonManagedApplication).build();
    }

    public static ResourceActionSummary fromM2NonManagedApplication(Consumer<M2NonManagedApplicationStepSummary.Builder> m2NonManagedApplication) {
        M2NonManagedApplicationStepSummary.Builder builder = M2NonManagedApplicationStepSummary.builder();
        m2NonManagedApplication.accept(builder);
        return ResourceActionSummary.fromM2NonManagedApplication((M2NonManagedApplicationStepSummary)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceActionSummary, T> g) {
        return obj -> g.apply((ResourceActionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CLOUD_FORMATION,
        M2_MANAGED_APPLICATION,
        M2_NON_MANAGED_APPLICATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CloudFormationStepSummary cloudFormation;
        private M2ManagedApplicationStepSummary m2ManagedApplication;
        private M2NonManagedApplicationStepSummary m2NonManagedApplication;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceActionSummary model) {
            this.cloudFormation(model.cloudFormation);
            this.m2ManagedApplication(model.m2ManagedApplication);
            this.m2NonManagedApplication(model.m2NonManagedApplication);
        }

        public final CloudFormationStepSummary.Builder getCloudFormation() {
            return this.cloudFormation != null ? this.cloudFormation.toBuilder() : null;
        }

        public final void setCloudFormation(CloudFormationStepSummary.BuilderImpl cloudFormation) {
            CloudFormationStepSummary oldValue = this.cloudFormation;
            this.cloudFormation = cloudFormation != null ? cloudFormation.build() : null;
            this.handleUnionValueChange(Type.CLOUD_FORMATION, oldValue, this.cloudFormation);
        }

        @Override
        public final Builder cloudFormation(CloudFormationStepSummary cloudFormation) {
            CloudFormationStepSummary oldValue = this.cloudFormation;
            this.cloudFormation = cloudFormation;
            this.handleUnionValueChange(Type.CLOUD_FORMATION, oldValue, this.cloudFormation);
            return this;
        }

        public final M2ManagedApplicationStepSummary.Builder getM2ManagedApplication() {
            return this.m2ManagedApplication != null ? this.m2ManagedApplication.toBuilder() : null;
        }

        public final void setM2ManagedApplication(M2ManagedApplicationStepSummary.BuilderImpl m2ManagedApplication) {
            M2ManagedApplicationStepSummary oldValue = this.m2ManagedApplication;
            this.m2ManagedApplication = m2ManagedApplication != null ? m2ManagedApplication.build() : null;
            this.handleUnionValueChange(Type.M2_MANAGED_APPLICATION, oldValue, this.m2ManagedApplication);
        }

        @Override
        public final Builder m2ManagedApplication(M2ManagedApplicationStepSummary m2ManagedApplication) {
            M2ManagedApplicationStepSummary oldValue = this.m2ManagedApplication;
            this.m2ManagedApplication = m2ManagedApplication;
            this.handleUnionValueChange(Type.M2_MANAGED_APPLICATION, oldValue, this.m2ManagedApplication);
            return this;
        }

        public final M2NonManagedApplicationStepSummary.Builder getM2NonManagedApplication() {
            return this.m2NonManagedApplication != null ? this.m2NonManagedApplication.toBuilder() : null;
        }

        public final void setM2NonManagedApplication(M2NonManagedApplicationStepSummary.BuilderImpl m2NonManagedApplication) {
            M2NonManagedApplicationStepSummary oldValue = this.m2NonManagedApplication;
            this.m2NonManagedApplication = m2NonManagedApplication != null ? m2NonManagedApplication.build() : null;
            this.handleUnionValueChange(Type.M2_NON_MANAGED_APPLICATION, oldValue, this.m2NonManagedApplication);
        }

        @Override
        public final Builder m2NonManagedApplication(M2NonManagedApplicationStepSummary m2NonManagedApplication) {
            M2NonManagedApplicationStepSummary oldValue = this.m2NonManagedApplication;
            this.m2NonManagedApplication = m2NonManagedApplication;
            this.handleUnionValueChange(Type.M2_NON_MANAGED_APPLICATION, oldValue, this.m2NonManagedApplication);
            return this;
        }

        public ResourceActionSummary build() {
            return new ResourceActionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceActionSummary> {
        public Builder cloudFormation(CloudFormationStepSummary var1);

        default public Builder cloudFormation(Consumer<CloudFormationStepSummary.Builder> cloudFormation) {
            return this.cloudFormation((CloudFormationStepSummary)((CloudFormationStepSummary.Builder)CloudFormationStepSummary.builder().applyMutation(cloudFormation)).build());
        }

        public Builder m2ManagedApplication(M2ManagedApplicationStepSummary var1);

        default public Builder m2ManagedApplication(Consumer<M2ManagedApplicationStepSummary.Builder> m2ManagedApplication) {
            return this.m2ManagedApplication((M2ManagedApplicationStepSummary)((M2ManagedApplicationStepSummary.Builder)M2ManagedApplicationStepSummary.builder().applyMutation(m2ManagedApplication)).build());
        }

        public Builder m2NonManagedApplication(M2NonManagedApplicationStepSummary var1);

        default public Builder m2NonManagedApplication(Consumer<M2NonManagedApplicationStepSummary.Builder> m2NonManagedApplication) {
            return this.m2NonManagedApplication((M2NonManagedApplicationStepSummary)((M2NonManagedApplicationStepSummary.Builder)M2NonManagedApplicationStepSummary.builder().applyMutation(m2NonManagedApplication)).build());
        }
    }
}

