/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apptest.AppTestClient;
import software.amazon.awssdk.services.apptest.internal.UserAgentUtils;
import software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesRequest;
import software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesResponse;
import software.amazon.awssdk.services.apptest.model.TestCaseRunSummary;

public class ListTestRunTestCasesIterable
implements SdkIterable<ListTestRunTestCasesResponse> {
    private final AppTestClient client;
    private final ListTestRunTestCasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestRunTestCasesIterable(AppTestClient client, ListTestRunTestCasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTestRunTestCasesResponseFetcher();
    }

    public Iterator<ListTestRunTestCasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TestCaseRunSummary> testRunTestCases() {
        Function<ListTestRunTestCasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.testRunTestCases() != null) {
                return response.testRunTestCases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTestRunTestCasesResponseFetcher
    implements SyncPageFetcher<ListTestRunTestCasesResponse> {
        private ListTestRunTestCasesResponseFetcher() {
        }

        public boolean hasNextPage(ListTestRunTestCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestRunTestCasesResponse nextPage(ListTestRunTestCasesResponse previousPage) {
            if (previousPage == null) {
                return ListTestRunTestCasesIterable.this.client.listTestRunTestCases(ListTestRunTestCasesIterable.this.firstRequest);
            }
            return ListTestRunTestCasesIterable.this.client.listTestRunTestCases((ListTestRunTestCasesRequest)((Object)ListTestRunTestCasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

