/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apptest.model.M2NonManagedRuntime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class M2NonManagedApplication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, M2NonManagedApplication> {
    private static final SdkField<String> VPC_ENDPOINT_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcEndpointServiceName").getter(M2NonManagedApplication.getter(M2NonManagedApplication::vpcEndpointServiceName)).setter(M2NonManagedApplication.setter(Builder::vpcEndpointServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointServiceName").build()}).build();
    private static final SdkField<String> LISTENER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listenerPort").getter(M2NonManagedApplication.getter(M2NonManagedApplication::listenerPort)).setter(M2NonManagedApplication.setter(Builder::listenerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listenerPort").build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtime").getter(M2NonManagedApplication.getter(M2NonManagedApplication::runtimeAsString)).setter(M2NonManagedApplication.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()}).build();
    private static final SdkField<String> WEB_APP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("webAppName").getter(M2NonManagedApplication.getter(M2NonManagedApplication::webAppName)).setter(M2NonManagedApplication.setter(Builder::webAppName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webAppName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_SERVICE_NAME_FIELD, LISTENER_PORT_FIELD, RUNTIME_FIELD, WEB_APP_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String vpcEndpointServiceName;
    private final String listenerPort;
    private final String runtime;
    private final String webAppName;

    private M2NonManagedApplication(BuilderImpl builder) {
        this.vpcEndpointServiceName = builder.vpcEndpointServiceName;
        this.listenerPort = builder.listenerPort;
        this.runtime = builder.runtime;
        this.webAppName = builder.webAppName;
    }

    public final String vpcEndpointServiceName() {
        return this.vpcEndpointServiceName;
    }

    public final String listenerPort() {
        return this.listenerPort;
    }

    public final M2NonManagedRuntime runtime() {
        return M2NonManagedRuntime.fromValue(this.runtime);
    }

    public final String runtimeAsString() {
        return this.runtime;
    }

    public final String webAppName() {
        return this.webAppName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.webAppName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2NonManagedApplication)) {
            return false;
        }
        M2NonManagedApplication other = (M2NonManagedApplication)obj;
        return Objects.equals(this.vpcEndpointServiceName(), other.vpcEndpointServiceName()) && Objects.equals(this.listenerPort(), other.listenerPort()) && Objects.equals(this.runtimeAsString(), other.runtimeAsString()) && Objects.equals(this.webAppName(), other.webAppName());
    }

    public final String toString() {
        return ToString.builder((String)"M2NonManagedApplication").add("VpcEndpointServiceName", (Object)this.vpcEndpointServiceName()).add("ListenerPort", (Object)this.listenerPort()).add("Runtime", (Object)this.runtimeAsString()).add("WebAppName", (Object)this.webAppName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vpcEndpointServiceName": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointServiceName()));
            }
            case "listenerPort": {
                return Optional.ofNullable(clazz.cast(this.listenerPort()));
            }
            case "runtime": {
                return Optional.ofNullable(clazz.cast(this.runtimeAsString()));
            }
            case "webAppName": {
                return Optional.ofNullable(clazz.cast(this.webAppName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<M2NonManagedApplication, T> g) {
        return obj -> g.apply((M2NonManagedApplication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcEndpointServiceName;
        private String listenerPort;
        private String runtime;
        private String webAppName;

        private BuilderImpl() {
        }

        private BuilderImpl(M2NonManagedApplication model) {
            this.vpcEndpointServiceName(model.vpcEndpointServiceName);
            this.listenerPort(model.listenerPort);
            this.runtime(model.runtime);
            this.webAppName(model.webAppName);
        }

        public final String getVpcEndpointServiceName() {
            return this.vpcEndpointServiceName;
        }

        public final void setVpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
        }

        @Override
        public final Builder vpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
            return this;
        }

        public final String getListenerPort() {
            return this.listenerPort;
        }

        public final void setListenerPort(String listenerPort) {
            this.listenerPort = listenerPort;
        }

        @Override
        public final Builder listenerPort(String listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(M2NonManagedRuntime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final String getWebAppName() {
            return this.webAppName;
        }

        public final void setWebAppName(String webAppName) {
            this.webAppName = webAppName;
        }

        @Override
        public final Builder webAppName(String webAppName) {
            this.webAppName = webAppName;
            return this;
        }

        public M2NonManagedApplication build() {
            return new M2NonManagedApplication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, M2NonManagedApplication> {
        public Builder vpcEndpointServiceName(String var1);

        public Builder listenerPort(String var1);

        public Builder runtime(String var1);

        public Builder runtime(M2NonManagedRuntime var1);

        public Builder webAppName(String var1);
    }
}

