/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apptest.model.AppTestResponse;
import software.amazon.awssdk.services.apptest.model.TestRunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTestRunResponse
extends AppTestResponse
implements ToCopyableBuilder<Builder, StartTestRunResponse> {
    private static final SdkField<String> TEST_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testRunId").getter(StartTestRunResponse.getter(StartTestRunResponse::testRunId)).setter(StartTestRunResponse.setter(Builder::testRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunId").build()}).build();
    private static final SdkField<String> TEST_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testRunStatus").getter(StartTestRunResponse.getter(StartTestRunResponse::testRunStatusAsString)).setter(StartTestRunResponse.setter(Builder::testRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_RUN_ID_FIELD, TEST_RUN_STATUS_FIELD));
    private final String testRunId;
    private final String testRunStatus;

    private StartTestRunResponse(BuilderImpl builder) {
        super(builder);
        this.testRunId = builder.testRunId;
        this.testRunStatus = builder.testRunStatus;
    }

    public final String testRunId() {
        return this.testRunId;
    }

    public final TestRunStatus testRunStatus() {
        return TestRunStatus.fromValue(this.testRunStatus);
    }

    public final String testRunStatusAsString() {
        return this.testRunStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.testRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testRunStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTestRunResponse)) {
            return false;
        }
        StartTestRunResponse other = (StartTestRunResponse)((Object)obj);
        return Objects.equals(this.testRunId(), other.testRunId()) && Objects.equals(this.testRunStatusAsString(), other.testRunStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartTestRunResponse").add("TestRunId", (Object)this.testRunId()).add("TestRunStatus", (Object)this.testRunStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testRunId": {
                return Optional.ofNullable(clazz.cast(this.testRunId()));
            }
            case "testRunStatus": {
                return Optional.ofNullable(clazz.cast(this.testRunStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTestRunResponse, T> g) {
        return obj -> g.apply((StartTestRunResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestResponse.BuilderImpl
    implements Builder {
        private String testRunId;
        private String testRunStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTestRunResponse model) {
            super(model);
            this.testRunId(model.testRunId);
            this.testRunStatus(model.testRunStatus);
        }

        public final String getTestRunId() {
            return this.testRunId;
        }

        public final void setTestRunId(String testRunId) {
            this.testRunId = testRunId;
        }

        @Override
        public final Builder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public final String getTestRunStatus() {
            return this.testRunStatus;
        }

        public final void setTestRunStatus(String testRunStatus) {
            this.testRunStatus = testRunStatus;
        }

        @Override
        public final Builder testRunStatus(String testRunStatus) {
            this.testRunStatus = testRunStatus;
            return this;
        }

        @Override
        public final Builder testRunStatus(TestRunStatus testRunStatus) {
            this.testRunStatus(testRunStatus == null ? null : testRunStatus.toString());
            return this;
        }

        @Override
        public StartTestRunResponse build() {
            return new StartTestRunResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppTestResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTestRunResponse> {
        public Builder testRunId(String var1);

        public Builder testRunStatus(String var1);

        public Builder testRunStatus(TestRunStatus var1);
    }
}

