/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncAsyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.DomainNameConfig;
import software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.appsync.model.ListDomainNamesResponse;

public class ListDomainNamesPublisher
implements SdkPublisher<ListDomainNamesResponse> {
    private final AppSyncAsyncClient client;
    private final ListDomainNamesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDomainNamesPublisher(AppSyncAsyncClient client, ListDomainNamesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDomainNamesPublisher(AppSyncAsyncClient client, ListDomainNamesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDomainNamesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDomainNamesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DomainNameConfig> domainNameConfigs() {
        Function<ListDomainNamesResponse, Iterator> getIterator = response -> {
            if (response != null && response.domainNameConfigs() != null) {
                return response.domainNameConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDomainNamesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDomainNamesResponseFetcher
    implements AsyncPageFetcher<ListDomainNamesResponse> {
        private ListDomainNamesResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainNamesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDomainNamesResponse> nextPage(ListDomainNamesResponse previousPage) {
            if (previousPage == null) {
                return ListDomainNamesPublisher.this.client.listDomainNames(ListDomainNamesPublisher.this.firstRequest);
            }
            return ListDomainNamesPublisher.this.client.listDomainNames((ListDomainNamesRequest)((Object)ListDomainNamesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

