/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.appsync.AppSyncClient;
import software.amazon.awssdk.services.appsync.AppSyncServiceClientConfiguration;
import software.amazon.awssdk.services.appsync.internal.AppSyncServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.appsync.model.AccessDeniedException;
import software.amazon.awssdk.services.appsync.model.ApiKeyLimitExceededException;
import software.amazon.awssdk.services.appsync.model.ApiKeyValidityOutOfBoundsException;
import software.amazon.awssdk.services.appsync.model.ApiLimitExceededException;
import software.amazon.awssdk.services.appsync.model.AppSyncException;
import software.amazon.awssdk.services.appsync.model.AssociateApiRequest;
import software.amazon.awssdk.services.appsync.model.AssociateApiResponse;
import software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.AssociateSourceGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.AssociateSourceGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.BadRequestException;
import software.amazon.awssdk.services.appsync.model.ConcurrentModificationException;
import software.amazon.awssdk.services.appsync.model.ConflictException;
import software.amazon.awssdk.services.appsync.model.CreateApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.CreateApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.CreateApiRequest;
import software.amazon.awssdk.services.appsync.model.CreateApiResponse;
import software.amazon.awssdk.services.appsync.model.CreateChannelNamespaceRequest;
import software.amazon.awssdk.services.appsync.model.CreateChannelNamespaceResponse;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.CreateDomainNameRequest;
import software.amazon.awssdk.services.appsync.model.CreateDomainNameResponse;
import software.amazon.awssdk.services.appsync.model.CreateFunctionRequest;
import software.amazon.awssdk.services.appsync.model.CreateFunctionResponse;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.CreateResolverRequest;
import software.amazon.awssdk.services.appsync.model.CreateResolverResponse;
import software.amazon.awssdk.services.appsync.model.CreateTypeRequest;
import software.amazon.awssdk.services.appsync.model.CreateTypeResponse;
import software.amazon.awssdk.services.appsync.model.DeleteApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.DeleteApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.DeleteApiRequest;
import software.amazon.awssdk.services.appsync.model.DeleteApiResponse;
import software.amazon.awssdk.services.appsync.model.DeleteChannelNamespaceRequest;
import software.amazon.awssdk.services.appsync.model.DeleteChannelNamespaceResponse;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.DeleteDomainNameRequest;
import software.amazon.awssdk.services.appsync.model.DeleteDomainNameResponse;
import software.amazon.awssdk.services.appsync.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.appsync.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.DeleteResolverRequest;
import software.amazon.awssdk.services.appsync.model.DeleteResolverResponse;
import software.amazon.awssdk.services.appsync.model.DeleteTypeRequest;
import software.amazon.awssdk.services.appsync.model.DeleteTypeResponse;
import software.amazon.awssdk.services.appsync.model.DisassociateApiRequest;
import software.amazon.awssdk.services.appsync.model.DisassociateApiResponse;
import software.amazon.awssdk.services.appsync.model.DisassociateMergedGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.DisassociateMergedGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.EvaluateCodeRequest;
import software.amazon.awssdk.services.appsync.model.EvaluateCodeResponse;
import software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateRequest;
import software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateResponse;
import software.amazon.awssdk.services.appsync.model.FlushApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.FlushApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.GetApiAssociationRequest;
import software.amazon.awssdk.services.appsync.model.GetApiAssociationResponse;
import software.amazon.awssdk.services.appsync.model.GetApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.GetApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.GetApiRequest;
import software.amazon.awssdk.services.appsync.model.GetApiResponse;
import software.amazon.awssdk.services.appsync.model.GetChannelNamespaceRequest;
import software.amazon.awssdk.services.appsync.model.GetChannelNamespaceResponse;
import software.amazon.awssdk.services.appsync.model.GetDataSourceIntrospectionRequest;
import software.amazon.awssdk.services.appsync.model.GetDataSourceIntrospectionResponse;
import software.amazon.awssdk.services.appsync.model.GetDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.GetDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.GetDomainNameRequest;
import software.amazon.awssdk.services.appsync.model.GetDomainNameResponse;
import software.amazon.awssdk.services.appsync.model.GetFunctionRequest;
import software.amazon.awssdk.services.appsync.model.GetFunctionResponse;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiEnvironmentVariablesRequest;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiEnvironmentVariablesResponse;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaRequest;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaResponse;
import software.amazon.awssdk.services.appsync.model.GetResolverRequest;
import software.amazon.awssdk.services.appsync.model.GetResolverResponse;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusRequest;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusResponse;
import software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationRequest;
import software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationResponse;
import software.amazon.awssdk.services.appsync.model.GetTypeRequest;
import software.amazon.awssdk.services.appsync.model.GetTypeResponse;
import software.amazon.awssdk.services.appsync.model.GraphQlSchemaException;
import software.amazon.awssdk.services.appsync.model.InternalFailureException;
import software.amazon.awssdk.services.appsync.model.LimitExceededException;
import software.amazon.awssdk.services.appsync.model.ListApiKeysRequest;
import software.amazon.awssdk.services.appsync.model.ListApiKeysResponse;
import software.amazon.awssdk.services.appsync.model.ListApisRequest;
import software.amazon.awssdk.services.appsync.model.ListApisResponse;
import software.amazon.awssdk.services.appsync.model.ListChannelNamespacesRequest;
import software.amazon.awssdk.services.appsync.model.ListChannelNamespacesResponse;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.appsync.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.appsync.model.ListFunctionsRequest;
import software.amazon.awssdk.services.appsync.model.ListFunctionsResponse;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse;
import software.amazon.awssdk.services.appsync.model.ListResolversRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversResponse;
import software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsRequest;
import software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsResponse;
import software.amazon.awssdk.services.appsync.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appsync.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appsync.model.ListTypesByAssociationRequest;
import software.amazon.awssdk.services.appsync.model.ListTypesByAssociationResponse;
import software.amazon.awssdk.services.appsync.model.ListTypesRequest;
import software.amazon.awssdk.services.appsync.model.ListTypesResponse;
import software.amazon.awssdk.services.appsync.model.NotFoundException;
import software.amazon.awssdk.services.appsync.model.PutGraphqlApiEnvironmentVariablesRequest;
import software.amazon.awssdk.services.appsync.model.PutGraphqlApiEnvironmentVariablesResponse;
import software.amazon.awssdk.services.appsync.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.appsync.model.StartDataSourceIntrospectionRequest;
import software.amazon.awssdk.services.appsync.model.StartDataSourceIntrospectionResponse;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationRequest;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationResponse;
import software.amazon.awssdk.services.appsync.model.StartSchemaMergeRequest;
import software.amazon.awssdk.services.appsync.model.StartSchemaMergeResponse;
import software.amazon.awssdk.services.appsync.model.TagResourceRequest;
import software.amazon.awssdk.services.appsync.model.TagResourceResponse;
import software.amazon.awssdk.services.appsync.model.UnauthorizedException;
import software.amazon.awssdk.services.appsync.model.UntagResourceRequest;
import software.amazon.awssdk.services.appsync.model.UntagResourceResponse;
import software.amazon.awssdk.services.appsync.model.UpdateApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.UpdateApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.UpdateApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.UpdateApiRequest;
import software.amazon.awssdk.services.appsync.model.UpdateApiResponse;
import software.amazon.awssdk.services.appsync.model.UpdateChannelNamespaceRequest;
import software.amazon.awssdk.services.appsync.model.UpdateChannelNamespaceResponse;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.UpdateDomainNameRequest;
import software.amazon.awssdk.services.appsync.model.UpdateDomainNameResponse;
import software.amazon.awssdk.services.appsync.model.UpdateFunctionRequest;
import software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.UpdateResolverRequest;
import software.amazon.awssdk.services.appsync.model.UpdateResolverResponse;
import software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationRequest;
import software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationResponse;
import software.amazon.awssdk.services.appsync.model.UpdateTypeRequest;
import software.amazon.awssdk.services.appsync.model.UpdateTypeResponse;
import software.amazon.awssdk.services.appsync.transform.AssociateApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.AssociateMergedGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.AssociateSourceGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateChannelNamespaceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateDomainNameRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteChannelNamespaceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteDomainNameRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DisassociateApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DisassociateMergedGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DisassociateSourceGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.EvaluateCodeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.EvaluateMappingTemplateRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.FlushApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetApiAssociationRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetChannelNamespaceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetDataSourceIntrospectionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetDomainNameRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetGraphqlApiEnvironmentVariablesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetIntrospectionSchemaRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetSchemaCreationStatusRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetSourceApiAssociationRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListApiKeysRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListApisRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListChannelNamespacesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListFunctionsRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListGraphqlApisRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListResolversByFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListResolversRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListSourceApiAssociationsRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListTypesByAssociationRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListTypesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.PutGraphqlApiEnvironmentVariablesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.StartDataSourceIntrospectionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.StartSchemaCreationRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.StartSchemaMergeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateChannelNamespaceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateDomainNameRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateSourceApiAssociationRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateTypeRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultAppSyncClient
implements AppSyncClient {
    private static final Logger log = Logger.loggerFor(DefaultAppSyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAppSyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"AppSync#2.40.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateApiResponse associateApi(AssociateApiRequest associateApiRequest) throws AccessDeniedException, BadRequestException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, associateApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateApi");
            AssociateApiResponse associateApiResponse = (AssociateApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateApi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$associateApi$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateMergedGraphqlApiResponse associateMergedGraphqlApi(AssociateMergedGraphqlApiRequest associateMergedGraphqlApiRequest) throws UnauthorizedException, BadRequestException, InternalFailureException, NotFoundException, LimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateMergedGraphqlApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateMergedGraphqlApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, associateMergedGraphqlApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateMergedGraphqlApi");
            AssociateMergedGraphqlApiResponse associateMergedGraphqlApiResponse = (AssociateMergedGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateMergedGraphqlApi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateMergedGraphqlApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateMergedGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateMergedGraphqlApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$associateMergedGraphqlApi$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateSourceGraphqlApiResponse associateSourceGraphqlApi(AssociateSourceGraphqlApiRequest associateSourceGraphqlApiRequest) throws UnauthorizedException, BadRequestException, InternalFailureException, NotFoundException, LimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateSourceGraphqlApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateSourceGraphqlApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, associateSourceGraphqlApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateSourceGraphqlApi");
            AssociateSourceGraphqlApiResponse associateSourceGraphqlApiResponse = (AssociateSourceGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateSourceGraphqlApi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateSourceGraphqlApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateSourceGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateSourceGraphqlApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$associateSourceGraphqlApi$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApiResponse createApi(CreateApiRequest createApiRequest) throws BadRequestException, ConcurrentModificationException, UnauthorizedException, InternalFailureException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, createApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApi");
            CreateApiResponse createApiResponse = (CreateApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$createApi$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApiCacheResponse createApiCache(CreateApiCacheRequest createApiCacheRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApiCacheResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createApiCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, createApiCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApiCache");
            CreateApiCacheResponse createApiCacheResponse = (CreateApiCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApiCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createApiCacheRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateApiCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createApiCacheResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$createApiCache$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApiKeyResponse createApiKey(CreateApiKeyRequest createApiKeyRequest) throws BadRequestException, NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException, ApiKeyLimitExceededException, ApiKeyValidityOutOfBoundsException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApiKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createApiKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, createApiKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApiKey");
            CreateApiKeyResponse createApiKeyResponse = (CreateApiKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApiKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createApiKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateApiKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createApiKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$createApiKey$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateChannelNamespaceResponse createChannelNamespace(CreateChannelNamespaceRequest createChannelNamespaceRequest) throws BadRequestException, ConcurrentModificationException, ConflictException, NotFoundException, UnauthorizedException, InternalFailureException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateChannelNamespaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createChannelNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, createChannelNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateChannelNamespace");
            CreateChannelNamespaceResponse createChannelNamespaceResponse = (CreateChannelNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateChannelNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createChannelNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateChannelNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createChannelNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$createChannelNamespace$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataSourceResponse createDataSource(CreateDataSourceRequest createDataSourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, createDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataSource");
            CreateDataSourceResponse createDataSourceResponse = (CreateDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDataSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$createDataSource$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDomainNameResponse createDomainName(CreateDomainNameRequest createDomainNameRequest) throws AccessDeniedException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDomainNameResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDomainNameRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, createDomainNameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDomainName");
            CreateDomainNameResponse createDomainNameResponse = (CreateDomainNameResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDomainName").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDomainNameRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDomainNameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDomainNameResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$createDomainName$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFunctionResponse createFunction(CreateFunctionRequest createFunctionRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFunctionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFunctionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, createFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFunction");
            CreateFunctionResponse createFunctionResponse = (CreateFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFunction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createFunctionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFunctionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$createFunction$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGraphqlApiResponse createGraphqlApi(CreateGraphqlApiRequest createGraphqlApiRequest) throws BadRequestException, LimitExceededException, ConcurrentModificationException, UnauthorizedException, InternalFailureException, ApiLimitExceededException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGraphqlApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGraphqlApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, createGraphqlApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGraphqlApi");
            CreateGraphqlApiResponse createGraphqlApiResponse = (CreateGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGraphqlApi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createGraphqlApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGraphqlApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$createGraphqlApi$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateResolverResponse createResolver(CreateResolverRequest createResolverRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateResolverResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createResolverRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, createResolverRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateResolver");
            CreateResolverResponse createResolverResponse = (CreateResolverResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateResolver").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createResolverRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateResolverRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createResolverResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$createResolver$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTypeResponse createType(CreateTypeRequest createTypeRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, createTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateType");
            CreateTypeResponse createTypeResponse = (CreateTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$createType$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApiResponse deleteApi(DeleteApiRequest deleteApiRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, deleteApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApi");
            DeleteApiResponse deleteApiResponse = (DeleteApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$deleteApi$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApiCacheResponse deleteApiCache(DeleteApiCacheRequest deleteApiCacheRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApiCacheResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApiCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, deleteApiCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApiCache");
            DeleteApiCacheResponse deleteApiCacheResponse = (DeleteApiCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApiCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteApiCacheRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApiCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApiCacheResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$deleteApiCache$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApiKeyResponse deleteApiKey(DeleteApiKeyRequest deleteApiKeyRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApiKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApiKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, deleteApiKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApiKey");
            DeleteApiKeyResponse deleteApiKeyResponse = (DeleteApiKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApiKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteApiKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApiKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApiKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$deleteApiKey$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteChannelNamespaceResponse deleteChannelNamespace(DeleteChannelNamespaceRequest deleteChannelNamespaceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteChannelNamespaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteChannelNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, deleteChannelNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteChannelNamespace");
            DeleteChannelNamespaceResponse deleteChannelNamespaceResponse = (DeleteChannelNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteChannelNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteChannelNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteChannelNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteChannelNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$deleteChannelNamespace$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, deleteDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataSource");
            DeleteDataSourceResponse deleteDataSourceResponse = (DeleteDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDataSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$deleteDataSource$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDomainNameResponse deleteDomainName(DeleteDomainNameRequest deleteDomainNameRequest) throws AccessDeniedException, BadRequestException, ConcurrentModificationException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDomainNameResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDomainNameRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, deleteDomainNameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDomainName");
            DeleteDomainNameResponse deleteDomainNameResponse = (DeleteDomainNameResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomainName").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDomainNameRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDomainNameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDomainNameResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$deleteDomainName$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFunctionResponse deleteFunction(DeleteFunctionRequest deleteFunctionRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFunctionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFunctionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, deleteFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFunction");
            DeleteFunctionResponse deleteFunctionResponse = (DeleteFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFunction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFunctionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFunctionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$deleteFunction$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGraphqlApiResponse deleteGraphqlApi(DeleteGraphqlApiRequest deleteGraphqlApiRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGraphqlApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteGraphqlApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, deleteGraphqlApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGraphqlApi");
            DeleteGraphqlApiResponse deleteGraphqlApiResponse = (DeleteGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGraphqlApi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteGraphqlApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGraphqlApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$deleteGraphqlApi$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResolverResponse deleteResolver(DeleteResolverRequest deleteResolverRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResolverResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResolverRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, deleteResolverRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResolver");
            DeleteResolverResponse deleteResolverResponse = (DeleteResolverResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResolver").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteResolverRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResolverRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResolverResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$deleteResolver$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTypeResponse deleteType(DeleteTypeRequest deleteTypeRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, deleteTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteType");
            DeleteTypeResponse deleteTypeResponse = (DeleteTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$deleteType$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateApiResponse disassociateApi(DisassociateApiRequest disassociateApiRequest) throws AccessDeniedException, BadRequestException, ConcurrentModificationException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, disassociateApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateApi");
            DisassociateApiResponse disassociateApiResponse = (DisassociateApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateApi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$disassociateApi$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateMergedGraphqlApiResponse disassociateMergedGraphqlApi(DisassociateMergedGraphqlApiRequest disassociateMergedGraphqlApiRequest) throws UnauthorizedException, BadRequestException, InternalFailureException, NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateMergedGraphqlApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateMergedGraphqlApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, disassociateMergedGraphqlApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateMergedGraphqlApi");
            DisassociateMergedGraphqlApiResponse disassociateMergedGraphqlApiResponse = (DisassociateMergedGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateMergedGraphqlApi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateMergedGraphqlApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateMergedGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateMergedGraphqlApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$disassociateMergedGraphqlApi$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateSourceGraphqlApiResponse disassociateSourceGraphqlApi(DisassociateSourceGraphqlApiRequest disassociateSourceGraphqlApiRequest) throws UnauthorizedException, BadRequestException, InternalFailureException, NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateSourceGraphqlApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateSourceGraphqlApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, disassociateSourceGraphqlApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateSourceGraphqlApi");
            DisassociateSourceGraphqlApiResponse disassociateSourceGraphqlApiResponse = (DisassociateSourceGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateSourceGraphqlApi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateSourceGraphqlApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateSourceGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateSourceGraphqlApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$disassociateSourceGraphqlApi$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvaluateCodeResponse evaluateCode(EvaluateCodeRequest evaluateCodeRequest) throws AccessDeniedException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EvaluateCodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)evaluateCodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, evaluateCodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EvaluateCode");
            EvaluateCodeResponse evaluateCodeResponse = (EvaluateCodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EvaluateCode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)evaluateCodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EvaluateCodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return evaluateCodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$evaluateCode$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvaluateMappingTemplateResponse evaluateMappingTemplate(EvaluateMappingTemplateRequest evaluateMappingTemplateRequest) throws AccessDeniedException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EvaluateMappingTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)evaluateMappingTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, evaluateMappingTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EvaluateMappingTemplate");
            EvaluateMappingTemplateResponse evaluateMappingTemplateResponse = (EvaluateMappingTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EvaluateMappingTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)evaluateMappingTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EvaluateMappingTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return evaluateMappingTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$evaluateMappingTemplate$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlushApiCacheResponse flushApiCache(FlushApiCacheRequest flushApiCacheRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, FlushApiCacheResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)flushApiCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, flushApiCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"FlushApiCache");
            FlushApiCacheResponse flushApiCacheResponse = (FlushApiCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("FlushApiCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)flushApiCacheRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new FlushApiCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return flushApiCacheResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$flushApiCache$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApiResponse getApi(GetApiRequest getApiRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, getApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApi");
            GetApiResponse getApiResponse = (GetApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$getApi$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApiAssociationResponse getApiAssociation(GetApiAssociationRequest getApiAssociationRequest) throws AccessDeniedException, BadRequestException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApiAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getApiAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, getApiAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApiAssociation");
            GetApiAssociationResponse getApiAssociationResponse = (GetApiAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApiAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getApiAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetApiAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getApiAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$getApiAssociation$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApiCacheResponse getApiCache(GetApiCacheRequest getApiCacheRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApiCacheResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getApiCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, getApiCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApiCache");
            GetApiCacheResponse getApiCacheResponse = (GetApiCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApiCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getApiCacheRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetApiCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getApiCacheResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$getApiCache$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetChannelNamespaceResponse getChannelNamespace(GetChannelNamespaceRequest getChannelNamespaceRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetChannelNamespaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getChannelNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, getChannelNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetChannelNamespace");
            GetChannelNamespaceResponse getChannelNamespaceResponse = (GetChannelNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetChannelNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getChannelNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetChannelNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getChannelNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$getChannelNamespace$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataSourceResponse getDataSource(GetDataSourceRequest getDataSourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, getDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataSource");
            GetDataSourceResponse getDataSourceResponse = (GetDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDataSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDataSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$getDataSource$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataSourceIntrospectionResponse getDataSourceIntrospection(GetDataSourceIntrospectionRequest getDataSourceIntrospectionRequest) throws BadRequestException, NotFoundException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataSourceIntrospectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDataSourceIntrospectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, getDataSourceIntrospectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataSourceIntrospection");
            GetDataSourceIntrospectionResponse getDataSourceIntrospectionResponse = (GetDataSourceIntrospectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataSourceIntrospection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDataSourceIntrospectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDataSourceIntrospectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDataSourceIntrospectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$getDataSourceIntrospection$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDomainNameResponse getDomainName(GetDomainNameRequest getDomainNameRequest) throws AccessDeniedException, BadRequestException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainNameResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDomainNameRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, getDomainNameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomainName");
            GetDomainNameResponse getDomainNameResponse = (GetDomainNameResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainName").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDomainNameRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDomainNameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDomainNameResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$getDomainName$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFunctionResponse getFunction(GetFunctionRequest getFunctionRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFunctionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getFunctionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, getFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFunction");
            GetFunctionResponse getFunctionResponse = (GetFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFunction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getFunctionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFunctionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$getFunction$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGraphqlApiResponse getGraphqlApi(GetGraphqlApiRequest getGraphqlApiRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGraphqlApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getGraphqlApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, getGraphqlApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGraphqlApi");
            GetGraphqlApiResponse getGraphqlApiResponse = (GetGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGraphqlApi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getGraphqlApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGraphqlApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$getGraphqlApi$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGraphqlApiEnvironmentVariablesResponse getGraphqlApiEnvironmentVariables(GetGraphqlApiEnvironmentVariablesRequest getGraphqlApiEnvironmentVariablesRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGraphqlApiEnvironmentVariablesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getGraphqlApiEnvironmentVariablesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, getGraphqlApiEnvironmentVariablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGraphqlApiEnvironmentVariables");
            GetGraphqlApiEnvironmentVariablesResponse getGraphqlApiEnvironmentVariablesResponse = (GetGraphqlApiEnvironmentVariablesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGraphqlApiEnvironmentVariables").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getGraphqlApiEnvironmentVariablesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGraphqlApiEnvironmentVariablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGraphqlApiEnvironmentVariablesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$getGraphqlApiEnvironmentVariables$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIntrospectionSchemaResponse getIntrospectionSchema(GetIntrospectionSchemaRequest getIntrospectionSchemaRequest) throws GraphQlSchemaException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIntrospectionSchemaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getIntrospectionSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, getIntrospectionSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIntrospectionSchema");
            GetIntrospectionSchemaResponse getIntrospectionSchemaResponse = (GetIntrospectionSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIntrospectionSchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getIntrospectionSchemaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIntrospectionSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getIntrospectionSchemaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$getIntrospectionSchema$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResolverResponse getResolver(GetResolverRequest getResolverRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResolverResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResolverRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, getResolverRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResolver");
            GetResolverResponse getResolverResponse = (GetResolverResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResolver").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResolverRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResolverRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResolverResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$getResolver$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSchemaCreationStatusResponse getSchemaCreationStatus(GetSchemaCreationStatusRequest getSchemaCreationStatusRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSchemaCreationStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSchemaCreationStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, getSchemaCreationStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSchemaCreationStatus");
            GetSchemaCreationStatusResponse getSchemaCreationStatusResponse = (GetSchemaCreationStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSchemaCreationStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSchemaCreationStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSchemaCreationStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSchemaCreationStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$getSchemaCreationStatus$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSourceApiAssociationResponse getSourceApiAssociation(GetSourceApiAssociationRequest getSourceApiAssociationRequest) throws UnauthorizedException, BadRequestException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSourceApiAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSourceApiAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, getSourceApiAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSourceApiAssociation");
            GetSourceApiAssociationResponse getSourceApiAssociationResponse = (GetSourceApiAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSourceApiAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSourceApiAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSourceApiAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSourceApiAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$getSourceApiAssociation$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTypeResponse getType(GetTypeRequest getTypeRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, getTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetType");
            GetTypeResponse getTypeResponse = (GetTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$getType$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApiKeysResponse listApiKeys(ListApiKeysRequest listApiKeysRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApiKeysResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listApiKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, listApiKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApiKeys");
            ListApiKeysResponse listApiKeysResponse = (ListApiKeysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApiKeys").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listApiKeysRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApiKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApiKeysResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$listApiKeys$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApisResponse listApis(ListApisRequest listApisRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listApisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, listApisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApis");
            ListApisResponse listApisResponse = (ListApisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listApisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$listApis$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListChannelNamespacesResponse listChannelNamespaces(ListChannelNamespacesRequest listChannelNamespacesRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListChannelNamespacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listChannelNamespacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, listChannelNamespacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListChannelNamespaces");
            ListChannelNamespacesResponse listChannelNamespacesResponse = (ListChannelNamespacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListChannelNamespaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listChannelNamespacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListChannelNamespacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listChannelNamespacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$listChannelNamespaces$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDataSourcesResponse listDataSources(ListDataSourcesRequest listDataSourcesRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataSourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDataSourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, listDataSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDataSources");
            ListDataSourcesResponse listDataSourcesResponse = (ListDataSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataSources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDataSourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDataSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDataSourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$listDataSources$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainNamesResponse listDomainNames(ListDomainNamesRequest listDomainNamesRequest) throws AccessDeniedException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainNamesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDomainNamesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, listDomainNamesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDomainNames");
            ListDomainNamesResponse listDomainNamesResponse = (ListDomainNamesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomainNames").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDomainNamesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDomainNamesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDomainNamesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$listDomainNames$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFunctionsResponse listFunctions(ListFunctionsRequest listFunctionsRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFunctionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFunctionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, listFunctionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFunctions");
            ListFunctionsResponse listFunctionsResponse = (ListFunctionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFunctions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listFunctionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFunctionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFunctionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$listFunctions$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGraphqlApisResponse listGraphqlApis(ListGraphqlApisRequest listGraphqlApisRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGraphqlApisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGraphqlApisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, listGraphqlApisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGraphqlApis");
            ListGraphqlApisResponse listGraphqlApisResponse = (ListGraphqlApisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGraphqlApis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listGraphqlApisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGraphqlApisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGraphqlApisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$listGraphqlApis$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResolversResponse listResolvers(ListResolversRequest listResolversRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResolversResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResolversRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, listResolversRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResolvers");
            ListResolversResponse listResolversResponse = (ListResolversResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResolvers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listResolversRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResolversRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResolversResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$listResolvers$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResolversByFunctionResponse listResolversByFunction(ListResolversByFunctionRequest listResolversByFunctionRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResolversByFunctionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResolversByFunctionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, listResolversByFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResolversByFunction");
            ListResolversByFunctionResponse listResolversByFunctionResponse = (ListResolversByFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResolversByFunction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listResolversByFunctionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResolversByFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResolversByFunctionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$listResolversByFunction$105((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSourceApiAssociationsResponse listSourceApiAssociations(ListSourceApiAssociationsRequest listSourceApiAssociationsRequest) throws UnauthorizedException, BadRequestException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSourceApiAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSourceApiAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, listSourceApiAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSourceApiAssociations");
            ListSourceApiAssociationsResponse listSourceApiAssociationsResponse = (ListSourceApiAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSourceApiAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSourceApiAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSourceApiAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSourceApiAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$listSourceApiAssociations$107((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$listTagsForResource$109((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTypesResponse listTypes(ListTypesRequest listTypesRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTypesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, listTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTypes");
            ListTypesResponse listTypesResponse = (ListTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$listTypes$111((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTypesByAssociationResponse listTypesByAssociation(ListTypesByAssociationRequest listTypesByAssociationRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTypesByAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTypesByAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, listTypesByAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTypesByAssociation");
            ListTypesByAssociationResponse listTypesByAssociationResponse = (ListTypesByAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTypesByAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTypesByAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTypesByAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTypesByAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$listTypesByAssociation$113((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutGraphqlApiEnvironmentVariablesResponse putGraphqlApiEnvironmentVariables(PutGraphqlApiEnvironmentVariablesRequest putGraphqlApiEnvironmentVariablesRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutGraphqlApiEnvironmentVariablesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putGraphqlApiEnvironmentVariablesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, putGraphqlApiEnvironmentVariablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutGraphqlApiEnvironmentVariables");
            PutGraphqlApiEnvironmentVariablesResponse putGraphqlApiEnvironmentVariablesResponse = (PutGraphqlApiEnvironmentVariablesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutGraphqlApiEnvironmentVariables").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putGraphqlApiEnvironmentVariablesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutGraphqlApiEnvironmentVariablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putGraphqlApiEnvironmentVariablesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$putGraphqlApiEnvironmentVariables$115((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDataSourceIntrospectionResponse startDataSourceIntrospection(StartDataSourceIntrospectionRequest startDataSourceIntrospectionRequest) throws NotFoundException, UnauthorizedException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDataSourceIntrospectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDataSourceIntrospectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, startDataSourceIntrospectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDataSourceIntrospection");
            StartDataSourceIntrospectionResponse startDataSourceIntrospectionResponse = (StartDataSourceIntrospectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDataSourceIntrospection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startDataSourceIntrospectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDataSourceIntrospectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDataSourceIntrospectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$startDataSourceIntrospection$117((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSchemaCreationResponse startSchemaCreation(StartSchemaCreationRequest startSchemaCreationRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSchemaCreationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startSchemaCreationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, startSchemaCreationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSchemaCreation");
            StartSchemaCreationResponse startSchemaCreationResponse = (StartSchemaCreationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSchemaCreation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startSchemaCreationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartSchemaCreationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSchemaCreationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$startSchemaCreation$119((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSchemaMergeResponse startSchemaMerge(StartSchemaMergeRequest startSchemaMergeRequest) throws UnauthorizedException, BadRequestException, InternalFailureException, NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSchemaMergeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startSchemaMergeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, startSchemaMergeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSchemaMerge");
            StartSchemaMergeResponse startSchemaMergeResponse = (StartSchemaMergeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSchemaMerge").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startSchemaMergeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartSchemaMergeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSchemaMergeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$startSchemaMerge$121((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$tagResource$123((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException, NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$untagResource$125((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApiResponse updateApi(UpdateApiRequest updateApiRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, updateApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApi");
            UpdateApiResponse updateApiResponse = (UpdateApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$updateApi$127((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApiCacheResponse updateApiCache(UpdateApiCacheRequest updateApiCacheRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApiCacheResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateApiCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, updateApiCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApiCache");
            UpdateApiCacheResponse updateApiCacheResponse = (UpdateApiCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApiCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateApiCacheRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateApiCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateApiCacheResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$updateApiCache$129((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApiKeyResponse updateApiKey(UpdateApiKeyRequest updateApiKeyRequest) throws BadRequestException, NotFoundException, UnauthorizedException, LimitExceededException, InternalFailureException, ApiKeyValidityOutOfBoundsException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApiKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateApiKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, updateApiKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApiKey");
            UpdateApiKeyResponse updateApiKeyResponse = (UpdateApiKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApiKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateApiKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateApiKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateApiKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$updateApiKey$131((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateChannelNamespaceResponse updateChannelNamespace(UpdateChannelNamespaceRequest updateChannelNamespaceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateChannelNamespaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateChannelNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, updateChannelNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateChannelNamespace");
            UpdateChannelNamespaceResponse updateChannelNamespaceResponse = (UpdateChannelNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateChannelNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateChannelNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateChannelNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateChannelNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$updateChannelNamespace$133((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, updateDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataSource");
            UpdateDataSourceResponse updateDataSourceResponse = (UpdateDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDataSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDataSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$updateDataSource$135((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainNameResponse updateDomainName(UpdateDomainNameRequest updateDomainNameRequest) throws AccessDeniedException, BadRequestException, ConcurrentModificationException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDomainNameResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDomainNameRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, updateDomainNameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDomainName");
            UpdateDomainNameResponse updateDomainNameResponse = (UpdateDomainNameResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainName").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDomainNameRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDomainNameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDomainNameResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$updateDomainName$137((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFunctionResponse updateFunction(UpdateFunctionRequest updateFunctionRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFunctionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFunctionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, updateFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFunction");
            UpdateFunctionResponse updateFunctionResponse = (UpdateFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFunction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateFunctionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFunctionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$updateFunction$139((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGraphqlApiResponse updateGraphqlApi(UpdateGraphqlApiRequest updateGraphqlApiRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGraphqlApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGraphqlApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, updateGraphqlApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGraphqlApi");
            UpdateGraphqlApiResponse updateGraphqlApiResponse = (UpdateGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGraphqlApi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateGraphqlApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGraphqlApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$updateGraphqlApi$141((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateResolverResponse updateResolver(UpdateResolverRequest updateResolverRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResolverResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateResolverRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, updateResolverRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateResolver");
            UpdateResolverResponse updateResolverResponse = (UpdateResolverResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResolver").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateResolverRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateResolverRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateResolverResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$updateResolver$143((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSourceApiAssociationResponse updateSourceApiAssociation(UpdateSourceApiAssociationRequest updateSourceApiAssociationRequest) throws UnauthorizedException, BadRequestException, InternalFailureException, NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSourceApiAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSourceApiAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, updateSourceApiAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSourceApiAssociation");
            UpdateSourceApiAssociationResponse updateSourceApiAssociationResponse = (UpdateSourceApiAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSourceApiAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateSourceApiAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSourceApiAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSourceApiAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$updateSourceApiAssociation$145((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTypeResponse updateType(UpdateTypeRequest updateTypeRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "GraphQLSchemaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GraphQlSchemaException::builder).build());
                }
                case "ApiKeyLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ApiLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiLimitExceededException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnauthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ApiKeyValidityOutOfBoundsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(clientConfiguration, updateTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateType");
            UpdateTypeResponse updateTypeResponse = (UpdateTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppSyncClient.lambda$updateType$147((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "appsync";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        AppSyncServiceClientConfigurationBuilder serviceConfigBuilder = new AppSyncServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AppSyncException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final AppSyncServiceClientConfiguration serviceClientConfiguration() {
        return new AppSyncServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateType$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSourceApiAssociation$145(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateResolver$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGraphqlApi$141(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFunction$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDomainName$137(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDataSource$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateChannelNamespace$133(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApiKey$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApiCache$129(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApi$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSchemaMerge$121(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSchemaCreation$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDataSourceIntrospection$117(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putGraphqlApiEnvironmentVariables$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTypesByAssociation$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTypes$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$109(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSourceApiAssociations$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResolversByFunction$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResolvers$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGraphqlApis$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFunctions$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDomainNames$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDataSources$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listChannelNamespaces$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApis$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApiKeys$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getType$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSourceApiAssociation$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSchemaCreationStatus$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResolver$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIntrospectionSchema$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGraphqlApiEnvironmentVariables$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGraphqlApi$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFunction$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDomainName$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataSourceIntrospection$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataSource$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getChannelNamespace$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApiCache$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApiAssociation$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApi$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$flushApiCache$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$evaluateMappingTemplate$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$evaluateCode$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateSourceGraphqlApi$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateMergedGraphqlApi$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateApi$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteType$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResolver$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGraphqlApi$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFunction$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDomainName$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataSource$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteChannelNamespace$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApiKey$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApiCache$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApi$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createType$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createResolver$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGraphqlApi$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFunction$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDomainName$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataSource$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createChannelNamespace$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApiKey$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApiCache$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApi$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateSourceGraphqlApi$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateMergedGraphqlApi$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateApi$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

