/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModelField;
import software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModelFieldsCopier;
import software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModelIndex;
import software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModelIndexesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceIntrospectionModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceIntrospectionModel> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DataSourceIntrospectionModel.getter(DataSourceIntrospectionModel::name)).setter(DataSourceIntrospectionModel.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<DataSourceIntrospectionModelField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fields").getter(DataSourceIntrospectionModel.getter(DataSourceIntrospectionModel::fields)).setter(DataSourceIntrospectionModel.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceIntrospectionModelField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataSourceIntrospectionModelIndex> PRIMARY_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("primaryKey").getter(DataSourceIntrospectionModel.getter(DataSourceIntrospectionModel::primaryKey)).setter(DataSourceIntrospectionModel.setter(Builder::primaryKey)).constructor(DataSourceIntrospectionModelIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryKey").build()}).build();
    private static final SdkField<List<DataSourceIntrospectionModelIndex>> INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("indexes").getter(DataSourceIntrospectionModel.getter(DataSourceIntrospectionModel::indexes)).setter(DataSourceIntrospectionModel.setter(Builder::indexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceIntrospectionModelIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SDL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sdl").getter(DataSourceIntrospectionModel.getter(DataSourceIntrospectionModel::sdl)).setter(DataSourceIntrospectionModel.setter(Builder::sdl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sdl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FIELDS_FIELD, PRIMARY_KEY_FIELD, INDEXES_FIELD, SDL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSourceIntrospectionModel.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<DataSourceIntrospectionModelField> fields;
    private final DataSourceIntrospectionModelIndex primaryKey;
    private final List<DataSourceIntrospectionModelIndex> indexes;
    private final String sdl;

    private DataSourceIntrospectionModel(BuilderImpl builder) {
        this.name = builder.name;
        this.fields = builder.fields;
        this.primaryKey = builder.primaryKey;
        this.indexes = builder.indexes;
        this.sdl = builder.sdl;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<DataSourceIntrospectionModelField> fields() {
        return this.fields;
    }

    public final DataSourceIntrospectionModelIndex primaryKey() {
        return this.primaryKey;
    }

    public final boolean hasIndexes() {
        return this.indexes != null && !(this.indexes instanceof SdkAutoConstructList);
    }

    public final List<DataSourceIntrospectionModelIndex> indexes() {
        return this.indexes;
    }

    public final String sdl() {
        return this.sdl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIndexes() ? this.indexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sdl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceIntrospectionModel)) {
            return false;
        }
        DataSourceIntrospectionModel other = (DataSourceIntrospectionModel)obj;
        return Objects.equals(this.name(), other.name()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.primaryKey(), other.primaryKey()) && this.hasIndexes() == other.hasIndexes() && Objects.equals(this.indexes(), other.indexes()) && Objects.equals(this.sdl(), other.sdl());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceIntrospectionModel").add("Name", (Object)this.name()).add("Fields", this.hasFields() ? this.fields() : null).add("PrimaryKey", (Object)this.primaryKey()).add("Indexes", this.hasIndexes() ? this.indexes() : null).add("Sdl", (Object)this.sdl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "primaryKey": {
                return Optional.ofNullable(clazz.cast(this.primaryKey()));
            }
            case "indexes": {
                return Optional.ofNullable(clazz.cast(this.indexes()));
            }
            case "sdl": {
                return Optional.ofNullable(clazz.cast(this.sdl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("fields", FIELDS_FIELD);
        map.put("primaryKey", PRIMARY_KEY_FIELD);
        map.put("indexes", INDEXES_FIELD);
        map.put("sdl", SDL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceIntrospectionModel, T> g) {
        return obj -> g.apply((DataSourceIntrospectionModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<DataSourceIntrospectionModelField> fields = DefaultSdkAutoConstructList.getInstance();
        private DataSourceIntrospectionModelIndex primaryKey;
        private List<DataSourceIntrospectionModelIndex> indexes = DefaultSdkAutoConstructList.getInstance();
        private String sdl;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceIntrospectionModel model) {
            this.name(model.name);
            this.fields(model.fields);
            this.primaryKey(model.primaryKey);
            this.indexes(model.indexes);
            this.sdl(model.sdl);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<DataSourceIntrospectionModelField.Builder> getFields() {
            List<DataSourceIntrospectionModelField.Builder> result = DataSourceIntrospectionModelFieldsCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<DataSourceIntrospectionModelField.BuilderImpl> fields) {
            this.fields = DataSourceIntrospectionModelFieldsCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<DataSourceIntrospectionModelField> fields) {
            this.fields = DataSourceIntrospectionModelFieldsCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(DataSourceIntrospectionModelField ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<DataSourceIntrospectionModelField.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (DataSourceIntrospectionModelField)((DataSourceIntrospectionModelField.Builder)DataSourceIntrospectionModelField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataSourceIntrospectionModelIndex.Builder getPrimaryKey() {
            return this.primaryKey != null ? this.primaryKey.toBuilder() : null;
        }

        public final void setPrimaryKey(DataSourceIntrospectionModelIndex.BuilderImpl primaryKey) {
            this.primaryKey = primaryKey != null ? primaryKey.build() : null;
        }

        @Override
        public final Builder primaryKey(DataSourceIntrospectionModelIndex primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public final List<DataSourceIntrospectionModelIndex.Builder> getIndexes() {
            List<DataSourceIntrospectionModelIndex.Builder> result = DataSourceIntrospectionModelIndexesCopier.copyToBuilder(this.indexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndexes(Collection<DataSourceIntrospectionModelIndex.BuilderImpl> indexes) {
            this.indexes = DataSourceIntrospectionModelIndexesCopier.copyFromBuilder(indexes);
        }

        @Override
        public final Builder indexes(Collection<DataSourceIntrospectionModelIndex> indexes) {
            this.indexes = DataSourceIntrospectionModelIndexesCopier.copy(indexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexes(DataSourceIntrospectionModelIndex ... indexes) {
            this.indexes(Arrays.asList(indexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexes(Consumer<DataSourceIntrospectionModelIndex.Builder> ... indexes) {
            this.indexes(Stream.of(indexes).map(c -> (DataSourceIntrospectionModelIndex)((DataSourceIntrospectionModelIndex.Builder)DataSourceIntrospectionModelIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSdl() {
            return this.sdl;
        }

        public final void setSdl(String sdl) {
            this.sdl = sdl;
        }

        @Override
        public final Builder sdl(String sdl) {
            this.sdl = sdl;
            return this;
        }

        public DataSourceIntrospectionModel build() {
            return new DataSourceIntrospectionModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceIntrospectionModel> {
        public Builder name(String var1);

        public Builder fields(Collection<DataSourceIntrospectionModelField> var1);

        public Builder fields(DataSourceIntrospectionModelField ... var1);

        public Builder fields(Consumer<DataSourceIntrospectionModelField.Builder> ... var1);

        public Builder primaryKey(DataSourceIntrospectionModelIndex var1);

        default public Builder primaryKey(Consumer<DataSourceIntrospectionModelIndex.Builder> primaryKey) {
            return this.primaryKey((DataSourceIntrospectionModelIndex)((DataSourceIntrospectionModelIndex.Builder)DataSourceIntrospectionModelIndex.builder().applyMutation(primaryKey)).build());
        }

        public Builder indexes(Collection<DataSourceIntrospectionModelIndex> var1);

        public Builder indexes(DataSourceIntrospectionModelIndex ... var1);

        public Builder indexes(Consumer<DataSourceIntrospectionModelIndex.Builder> ... var1);

        public Builder sdl(String var1);
    }
}

