/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.DomainNameConfig;
import software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.appsync.model.ListDomainNamesResponse;

public class ListDomainNamesIterable
implements SdkIterable<ListDomainNamesResponse> {
    private final AppSyncClient client;
    private final ListDomainNamesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDomainNamesIterable(AppSyncClient client, ListDomainNamesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDomainNamesResponseFetcher();
    }

    public Iterator<ListDomainNamesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DomainNameConfig> domainNameConfigs() {
        Function<ListDomainNamesResponse, Iterator> getIterator = response -> {
            if (response != null && response.domainNameConfigs() != null) {
                return response.domainNameConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDomainNamesResponseFetcher
    implements SyncPageFetcher<ListDomainNamesResponse> {
        private ListDomainNamesResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainNamesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDomainNamesResponse nextPage(ListDomainNamesResponse previousPage) {
            if (previousPage == null) {
                return ListDomainNamesIterable.this.client.listDomainNames(ListDomainNamesIterable.this.firstRequest);
            }
            return ListDomainNamesIterable.this.client.listDomainNames((ListDomainNamesRequest)((Object)ListDomainNamesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

