/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.Api;
import software.amazon.awssdk.services.appsync.model.ListApisRequest;
import software.amazon.awssdk.services.appsync.model.ListApisResponse;

public class ListApisIterable
implements SdkIterable<ListApisResponse> {
    private final AppSyncClient client;
    private final ListApisRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApisIterable(AppSyncClient client, ListApisRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApisResponseFetcher();
    }

    public Iterator<ListApisResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Api> apis() {
        Function<ListApisResponse, Iterator> getIterator = response -> {
            if (response != null && response.apis() != null) {
                return response.apis().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListApisResponseFetcher
    implements SyncPageFetcher<ListApisResponse> {
        private ListApisResponseFetcher() {
        }

        public boolean hasNextPage(ListApisResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApisResponse nextPage(ListApisResponse previousPage) {
            if (previousPage == null) {
                return ListApisIterable.this.client.listApis(ListApisIterable.this.firstRequest);
            }
            return ListApisIterable.this.client.listApis((ListApisRequest)((Object)ListApisIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

