/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModelFieldTypeValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceIntrospectionModelFieldType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceIntrospectionModelFieldType> {
    private static final SdkField<String> KIND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kind").getter(DataSourceIntrospectionModelFieldType.getter(DataSourceIntrospectionModelFieldType::kind)).setter(DataSourceIntrospectionModelFieldType.setter(Builder::kind)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kind").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DataSourceIntrospectionModelFieldType.getter(DataSourceIntrospectionModelFieldType::name)).setter(DataSourceIntrospectionModelFieldType.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<DataSourceIntrospectionModelFieldType> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("type").getter(DataSourceIntrospectionModelFieldType.getter(DataSourceIntrospectionModelFieldType::type)).setter(DataSourceIntrospectionModelFieldType.setter(Builder::type)).constructor(DataSourceIntrospectionModelFieldType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(DataSourceIntrospectionModelFieldType.getter(DataSourceIntrospectionModelFieldType::values)).setter(DataSourceIntrospectionModelFieldType.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KIND_FIELD, NAME_FIELD, TYPE_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSourceIntrospectionModelFieldType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String kind;
    private final String name;
    private final DataSourceIntrospectionModelFieldType type;
    private final List<String> values;

    private DataSourceIntrospectionModelFieldType(BuilderImpl builder) {
        this.kind = builder.kind;
        this.name = builder.name;
        this.type = builder.type;
        this.values = builder.values;
    }

    public final String kind() {
        return this.kind;
    }

    public final String name() {
        return this.name;
    }

    public final DataSourceIntrospectionModelFieldType type() {
        return this.type;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kind());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceIntrospectionModelFieldType)) {
            return false;
        }
        DataSourceIntrospectionModelFieldType other = (DataSourceIntrospectionModelFieldType)obj;
        return Objects.equals(this.kind(), other.kind()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.type(), other.type()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceIntrospectionModelFieldType").add("Kind", (Object)this.kind()).add("Name", (Object)this.name()).add("Type", (Object)this.type()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kind": {
                return Optional.ofNullable(clazz.cast(this.kind()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("kind", KIND_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceIntrospectionModelFieldType, T> g) {
        return obj -> g.apply((DataSourceIntrospectionModelFieldType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kind;
        private String name;
        private DataSourceIntrospectionModelFieldType type;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceIntrospectionModelFieldType model) {
            this.kind(model.kind);
            this.name(model.name);
            this.type(model.type);
            this.values(model.values);
        }

        public final String getKind() {
            return this.kind;
        }

        public final void setKind(String kind) {
            this.kind = kind;
        }

        @Override
        public final Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Builder getType() {
            return this.type != null ? this.type.toBuilder() : null;
        }

        public final void setType(BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(DataSourceIntrospectionModelFieldType type) {
            this.type = type;
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = DataSourceIntrospectionModelFieldTypeValuesCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = DataSourceIntrospectionModelFieldTypeValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public DataSourceIntrospectionModelFieldType build() {
            return new DataSourceIntrospectionModelFieldType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceIntrospectionModelFieldType> {
        public Builder kind(String var1);

        public Builder name(String var1);

        public Builder type(DataSourceIntrospectionModelFieldType var1);

        default public Builder type(Consumer<Builder> type) {
            return this.type((DataSourceIntrospectionModelFieldType)((Builder)DataSourceIntrospectionModelFieldType.builder().applyMutation(type)).build());
        }

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

