/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AuthenticationType;
import software.amazon.awssdk.services.appsync.model.CognitoUserPoolConfig;
import software.amazon.awssdk.services.appsync.model.LambdaAuthorizerConfig;
import software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdditionalAuthenticationProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdditionalAuthenticationProvider> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authenticationType").getter(AdditionalAuthenticationProvider.getter(AdditionalAuthenticationProvider::authenticationTypeAsString)).setter(AdditionalAuthenticationProvider.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build()}).build();
    private static final SdkField<OpenIDConnectConfig> OPEN_ID_CONNECT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("openIDConnectConfig").getter(AdditionalAuthenticationProvider.getter(AdditionalAuthenticationProvider::openIDConnectConfig)).setter(AdditionalAuthenticationProvider.setter(Builder::openIDConnectConfig)).constructor(OpenIDConnectConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDConnectConfig").build()}).build();
    private static final SdkField<CognitoUserPoolConfig> USER_POOL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userPoolConfig").getter(AdditionalAuthenticationProvider.getter(AdditionalAuthenticationProvider::userPoolConfig)).setter(AdditionalAuthenticationProvider.setter(Builder::userPoolConfig)).constructor(CognitoUserPoolConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolConfig").build()}).build();
    private static final SdkField<LambdaAuthorizerConfig> LAMBDA_AUTHORIZER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambdaAuthorizerConfig").getter(AdditionalAuthenticationProvider.getter(AdditionalAuthenticationProvider::lambdaAuthorizerConfig)).setter(AdditionalAuthenticationProvider.setter(Builder::lambdaAuthorizerConfig)).constructor(LambdaAuthorizerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaAuthorizerConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD, OPEN_ID_CONNECT_CONFIG_FIELD, USER_POOL_CONFIG_FIELD, LAMBDA_AUTHORIZER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AdditionalAuthenticationProvider.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String authenticationType;
    private final OpenIDConnectConfig openIDConnectConfig;
    private final CognitoUserPoolConfig userPoolConfig;
    private final LambdaAuthorizerConfig lambdaAuthorizerConfig;

    private AdditionalAuthenticationProvider(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.openIDConnectConfig = builder.openIDConnectConfig;
        this.userPoolConfig = builder.userPoolConfig;
        this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
    }

    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final OpenIDConnectConfig openIDConnectConfig() {
        return this.openIDConnectConfig;
    }

    public final CognitoUserPoolConfig userPoolConfig() {
        return this.userPoolConfig;
    }

    public final LambdaAuthorizerConfig lambdaAuthorizerConfig() {
        return this.lambdaAuthorizerConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.openIDConnectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaAuthorizerConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalAuthenticationProvider)) {
            return false;
        }
        AdditionalAuthenticationProvider other = (AdditionalAuthenticationProvider)obj;
        return Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.openIDConnectConfig(), other.openIDConnectConfig()) && Objects.equals(this.userPoolConfig(), other.userPoolConfig()) && Objects.equals(this.lambdaAuthorizerConfig(), other.lambdaAuthorizerConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AdditionalAuthenticationProvider").add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("OpenIDConnectConfig", (Object)this.openIDConnectConfig()).add("UserPoolConfig", (Object)this.userPoolConfig()).add("LambdaAuthorizerConfig", (Object)this.lambdaAuthorizerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "openIDConnectConfig": {
                return Optional.ofNullable(clazz.cast(this.openIDConnectConfig()));
            }
            case "userPoolConfig": {
                return Optional.ofNullable(clazz.cast(this.userPoolConfig()));
            }
            case "lambdaAuthorizerConfig": {
                return Optional.ofNullable(clazz.cast(this.lambdaAuthorizerConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("authenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("openIDConnectConfig", OPEN_ID_CONNECT_CONFIG_FIELD);
        map.put("userPoolConfig", USER_POOL_CONFIG_FIELD);
        map.put("lambdaAuthorizerConfig", LAMBDA_AUTHORIZER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdditionalAuthenticationProvider, T> g) {
        return obj -> g.apply((AdditionalAuthenticationProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationType;
        private OpenIDConnectConfig openIDConnectConfig;
        private CognitoUserPoolConfig userPoolConfig;
        private LambdaAuthorizerConfig lambdaAuthorizerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalAuthenticationProvider model) {
            this.authenticationType(model.authenticationType);
            this.openIDConnectConfig(model.openIDConnectConfig);
            this.userPoolConfig(model.userPoolConfig);
            this.lambdaAuthorizerConfig(model.lambdaAuthorizerConfig);
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final OpenIDConnectConfig.Builder getOpenIDConnectConfig() {
            return this.openIDConnectConfig != null ? this.openIDConnectConfig.toBuilder() : null;
        }

        public final void setOpenIDConnectConfig(OpenIDConnectConfig.BuilderImpl openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig != null ? openIDConnectConfig.build() : null;
        }

        @Override
        public final Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig;
            return this;
        }

        public final CognitoUserPoolConfig.Builder getUserPoolConfig() {
            return this.userPoolConfig != null ? this.userPoolConfig.toBuilder() : null;
        }

        public final void setUserPoolConfig(CognitoUserPoolConfig.BuilderImpl userPoolConfig) {
            this.userPoolConfig = userPoolConfig != null ? userPoolConfig.build() : null;
        }

        @Override
        public final Builder userPoolConfig(CognitoUserPoolConfig userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        public final LambdaAuthorizerConfig.Builder getLambdaAuthorizerConfig() {
            return this.lambdaAuthorizerConfig != null ? this.lambdaAuthorizerConfig.toBuilder() : null;
        }

        public final void setLambdaAuthorizerConfig(LambdaAuthorizerConfig.BuilderImpl lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig != null ? lambdaAuthorizerConfig.build() : null;
        }

        @Override
        public final Builder lambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
            return this;
        }

        public AdditionalAuthenticationProvider build() {
            return new AdditionalAuthenticationProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdditionalAuthenticationProvider> {
        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder openIDConnectConfig(OpenIDConnectConfig var1);

        default public Builder openIDConnectConfig(Consumer<OpenIDConnectConfig.Builder> openIDConnectConfig) {
            return this.openIDConnectConfig((OpenIDConnectConfig)((OpenIDConnectConfig.Builder)OpenIDConnectConfig.builder().applyMutation(openIDConnectConfig)).build());
        }

        public Builder userPoolConfig(CognitoUserPoolConfig var1);

        default public Builder userPoolConfig(Consumer<CognitoUserPoolConfig.Builder> userPoolConfig) {
            return this.userPoolConfig((CognitoUserPoolConfig)((CognitoUserPoolConfig.Builder)CognitoUserPoolConfig.builder().applyMutation(userPoolConfig)).build());
        }

        public Builder lambdaAuthorizerConfig(LambdaAuthorizerConfig var1);

        default public Builder lambdaAuthorizerConfig(Consumer<LambdaAuthorizerConfig.Builder> lambdaAuthorizerConfig) {
            return this.lambdaAuthorizerConfig((LambdaAuthorizerConfig)((LambdaAuthorizerConfig.Builder)LambdaAuthorizerConfig.builder().applyMutation(lambdaAuthorizerConfig)).build());
        }
    }
}

