/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApiKeyRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, UpdateApiKeyRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiId").getter(UpdateApiKeyRequest.getter(UpdateApiKeyRequest::apiId)).setter(UpdateApiKeyRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateApiKeyRequest.getter(UpdateApiKeyRequest::id)).setter(UpdateApiKeyRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateApiKeyRequest.getter(UpdateApiKeyRequest::description)).setter(UpdateApiKeyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Long> EXPIRES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("expires").getter(UpdateApiKeyRequest.getter(UpdateApiKeyRequest::expires)).setter(UpdateApiKeyRequest.setter(Builder::expires)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expires").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, ID_FIELD, DESCRIPTION_FIELD, EXPIRES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateApiKeyRequest.memberNameToFieldInitializer();
    private final String apiId;
    private final String id;
    private final String description;
    private final Long expires;

    private UpdateApiKeyRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.id = builder.id;
        this.description = builder.description;
        this.expires = builder.expires;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final String id() {
        return this.id;
    }

    public final String description() {
        return this.description;
    }

    public final Long expires() {
        return this.expires;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.expires());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApiKeyRequest)) {
            return false;
        }
        UpdateApiKeyRequest other = (UpdateApiKeyRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.expires(), other.expires());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApiKeyRequest").add("ApiId", (Object)this.apiId()).add("Id", (Object)this.id()).add("Description", (Object)this.description()).add("Expires", (Object)this.expires()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "expires": {
                return Optional.ofNullable(clazz.cast(this.expires()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("apiId", API_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("expires", EXPIRES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApiKeyRequest, T> g) {
        return obj -> g.apply((UpdateApiKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private String id;
        private String description;
        private Long expires;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApiKeyRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.id(model.id);
            this.description(model.description);
            this.expires(model.expires);
        }

        public final String getApiId() {
            return this.apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Long getExpires() {
            return this.expires;
        }

        public final void setExpires(Long expires) {
            this.expires = expires;
        }

        @Override
        public final Builder expires(Long expires) {
            this.expires = expires;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApiKeyRequest build() {
            return new UpdateApiKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApiKeyRequest> {
        public Builder apiId(String var1);

        public Builder id(String var1);

        public Builder description(String var1);

        public Builder expires(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

