/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.services.appsync.model.AuthMode;
import software.amazon.awssdk.services.appsync.model.AuthModesCopier;
import software.amazon.awssdk.services.appsync.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChannelNamespaceRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, CreateChannelNamespaceRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiId").getter(CreateChannelNamespaceRequest.getter(CreateChannelNamespaceRequest::apiId)).setter(CreateChannelNamespaceRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateChannelNamespaceRequest.getter(CreateChannelNamespaceRequest::name)).setter(CreateChannelNamespaceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<AuthMode>> SUBSCRIBE_AUTH_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subscribeAuthModes").getter(CreateChannelNamespaceRequest.getter(CreateChannelNamespaceRequest::subscribeAuthModes)).setter(CreateChannelNamespaceRequest.setter(Builder::subscribeAuthModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribeAuthModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthMode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AuthMode>> PUBLISH_AUTH_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("publishAuthModes").getter(CreateChannelNamespaceRequest.getter(CreateChannelNamespaceRequest::publishAuthModes)).setter(CreateChannelNamespaceRequest.setter(Builder::publishAuthModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publishAuthModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthMode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CODE_HANDLERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codeHandlers").getter(CreateChannelNamespaceRequest.getter(CreateChannelNamespaceRequest::codeHandlers)).setter(CreateChannelNamespaceRequest.setter(Builder::codeHandlers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeHandlers").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateChannelNamespaceRequest.getter(CreateChannelNamespaceRequest::tags)).setter(CreateChannelNamespaceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, NAME_FIELD, SUBSCRIBE_AUTH_MODES_FIELD, PUBLISH_AUTH_MODES_FIELD, CODE_HANDLERS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("apiId", API_ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("subscribeAuthModes", SUBSCRIBE_AUTH_MODES_FIELD);
            this.put("publishAuthModes", PUBLISH_AUTH_MODES_FIELD);
            this.put("codeHandlers", CODE_HANDLERS_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String apiId;
    private final String name;
    private final List<AuthMode> subscribeAuthModes;
    private final List<AuthMode> publishAuthModes;
    private final String codeHandlers;
    private final Map<String, String> tags;

    private CreateChannelNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.name = builder.name;
        this.subscribeAuthModes = builder.subscribeAuthModes;
        this.publishAuthModes = builder.publishAuthModes;
        this.codeHandlers = builder.codeHandlers;
        this.tags = builder.tags;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasSubscribeAuthModes() {
        return this.subscribeAuthModes != null && !(this.subscribeAuthModes instanceof SdkAutoConstructList);
    }

    public final List<AuthMode> subscribeAuthModes() {
        return this.subscribeAuthModes;
    }

    public final boolean hasPublishAuthModes() {
        return this.publishAuthModes != null && !(this.publishAuthModes instanceof SdkAutoConstructList);
    }

    public final List<AuthMode> publishAuthModes() {
        return this.publishAuthModes;
    }

    public final String codeHandlers() {
        return this.codeHandlers;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscribeAuthModes() ? this.subscribeAuthModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublishAuthModes() ? this.publishAuthModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.codeHandlers());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelNamespaceRequest)) {
            return false;
        }
        CreateChannelNamespaceRequest other = (CreateChannelNamespaceRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.name(), other.name()) && this.hasSubscribeAuthModes() == other.hasSubscribeAuthModes() && Objects.equals(this.subscribeAuthModes(), other.subscribeAuthModes()) && this.hasPublishAuthModes() == other.hasPublishAuthModes() && Objects.equals(this.publishAuthModes(), other.publishAuthModes()) && Objects.equals(this.codeHandlers(), other.codeHandlers()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChannelNamespaceRequest").add("ApiId", (Object)this.apiId()).add("Name", (Object)this.name()).add("SubscribeAuthModes", this.hasSubscribeAuthModes() ? this.subscribeAuthModes() : null).add("PublishAuthModes", this.hasPublishAuthModes() ? this.publishAuthModes() : null).add("CodeHandlers", (Object)this.codeHandlers()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "subscribeAuthModes": {
                return Optional.ofNullable(clazz.cast(this.subscribeAuthModes()));
            }
            case "publishAuthModes": {
                return Optional.ofNullable(clazz.cast(this.publishAuthModes()));
            }
            case "codeHandlers": {
                return Optional.ofNullable(clazz.cast(this.codeHandlers()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelNamespaceRequest, T> g) {
        return obj -> g.apply((CreateChannelNamespaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private String name;
        private List<AuthMode> subscribeAuthModes = DefaultSdkAutoConstructList.getInstance();
        private List<AuthMode> publishAuthModes = DefaultSdkAutoConstructList.getInstance();
        private String codeHandlers;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelNamespaceRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.name(model.name);
            this.subscribeAuthModes(model.subscribeAuthModes);
            this.publishAuthModes(model.publishAuthModes);
            this.codeHandlers(model.codeHandlers);
            this.tags(model.tags);
        }

        public final String getApiId() {
            return this.apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AuthMode.Builder> getSubscribeAuthModes() {
            List<AuthMode.Builder> result = AuthModesCopier.copyToBuilder(this.subscribeAuthModes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribeAuthModes(Collection<AuthMode.BuilderImpl> subscribeAuthModes) {
            this.subscribeAuthModes = AuthModesCopier.copyFromBuilder(subscribeAuthModes);
        }

        @Override
        public final Builder subscribeAuthModes(Collection<AuthMode> subscribeAuthModes) {
            this.subscribeAuthModes = AuthModesCopier.copy(subscribeAuthModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribeAuthModes(AuthMode ... subscribeAuthModes) {
            this.subscribeAuthModes(Arrays.asList(subscribeAuthModes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribeAuthModes(Consumer<AuthMode.Builder> ... subscribeAuthModes) {
            this.subscribeAuthModes(Stream.of(subscribeAuthModes).map(c -> (AuthMode)((AuthMode.Builder)AuthMode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AuthMode.Builder> getPublishAuthModes() {
            List<AuthMode.Builder> result = AuthModesCopier.copyToBuilder(this.publishAuthModes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPublishAuthModes(Collection<AuthMode.BuilderImpl> publishAuthModes) {
            this.publishAuthModes = AuthModesCopier.copyFromBuilder(publishAuthModes);
        }

        @Override
        public final Builder publishAuthModes(Collection<AuthMode> publishAuthModes) {
            this.publishAuthModes = AuthModesCopier.copy(publishAuthModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publishAuthModes(AuthMode ... publishAuthModes) {
            this.publishAuthModes(Arrays.asList(publishAuthModes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publishAuthModes(Consumer<AuthMode.Builder> ... publishAuthModes) {
            this.publishAuthModes(Stream.of(publishAuthModes).map(c -> (AuthMode)((AuthMode.Builder)AuthMode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCodeHandlers() {
            return this.codeHandlers;
        }

        public final void setCodeHandlers(String codeHandlers) {
            this.codeHandlers = codeHandlers;
        }

        @Override
        public final Builder codeHandlers(String codeHandlers) {
            this.codeHandlers = codeHandlers;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelNamespaceRequest build() {
            return new CreateChannelNamespaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChannelNamespaceRequest> {
        public Builder apiId(String var1);

        public Builder name(String var1);

        public Builder subscribeAuthModes(Collection<AuthMode> var1);

        public Builder subscribeAuthModes(AuthMode ... var1);

        public Builder subscribeAuthModes(Consumer<AuthMode.Builder> ... var1);

        public Builder publishAuthModes(Collection<AuthMode> var1);

        public Builder publishAuthModes(AuthMode ... var1);

        public Builder publishAuthModes(Consumer<AuthMode.Builder> ... var1);

        public Builder codeHandlers(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

