/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncAsyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.ApiKey;
import software.amazon.awssdk.services.appsync.model.ListApiKeysRequest;
import software.amazon.awssdk.services.appsync.model.ListApiKeysResponse;

public class ListApiKeysPublisher
implements SdkPublisher<ListApiKeysResponse> {
    private final AppSyncAsyncClient client;
    private final ListApiKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApiKeysPublisher(AppSyncAsyncClient client, ListApiKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApiKeysPublisher(AppSyncAsyncClient client, ListApiKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApiKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApiKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ApiKey> apiKeys() {
        Function<ListApiKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.apiKeys() != null) {
                return response.apiKeys().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApiKeysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApiKeysResponseFetcher
    implements AsyncPageFetcher<ListApiKeysResponse> {
        private ListApiKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListApiKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApiKeysResponse> nextPage(ListApiKeysResponse previousPage) {
            if (previousPage == null) {
                return ListApiKeysPublisher.this.client.listApiKeys(ListApiKeysPublisher.this.firstRequest);
            }
            return ListApiKeysPublisher.this.client.listApiKeys((ListApiKeysRequest)((Object)ListApiKeysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

