/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthenticationType {
    API_KEY("API_KEY"),
    AWS_IAM("AWS_IAM"),
    AMAZON_COGNITO_USER_POOLS("AMAZON_COGNITO_USER_POOLS"),
    OPENID_CONNECT("OPENID_CONNECT"),
    AWS_LAMBDA("AWS_LAMBDA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthenticationType> VALUE_MAP;
    private final String value;

    private AuthenticationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthenticationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthenticationType> knownValues() {
        EnumSet<AuthenticationType> knownValues = EnumSet.allOf(AuthenticationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthenticationType.class, AuthenticationType::toString);
    }
}

