/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.services.appsync.model.OutputType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIntrospectionSchemaRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, GetIntrospectionSchemaRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiId").getter(GetIntrospectionSchemaRequest.getter(GetIntrospectionSchemaRequest::apiId)).setter(GetIntrospectionSchemaRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(GetIntrospectionSchemaRequest.getter(GetIntrospectionSchemaRequest::formatAsString)).setter(GetIntrospectionSchemaRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("format").build()}).build();
    private static final SdkField<Boolean> INCLUDE_DIRECTIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeDirectives").getter(GetIntrospectionSchemaRequest.getter(GetIntrospectionSchemaRequest::includeDirectives)).setter(GetIntrospectionSchemaRequest.setter(Builder::includeDirectives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeDirectives").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, FORMAT_FIELD, INCLUDE_DIRECTIVES_FIELD));
    private final String apiId;
    private final String format;
    private final Boolean includeDirectives;

    private GetIntrospectionSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.format = builder.format;
        this.includeDirectives = builder.includeDirectives;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final OutputType format() {
        return OutputType.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final Boolean includeDirectives() {
        return this.includeDirectives;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeDirectives());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntrospectionSchemaRequest)) {
            return false;
        }
        GetIntrospectionSchemaRequest other = (GetIntrospectionSchemaRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.includeDirectives(), other.includeDirectives());
    }

    public final String toString() {
        return ToString.builder((String)"GetIntrospectionSchemaRequest").add("ApiId", (Object)this.apiId()).add("Format", (Object)this.formatAsString()).add("IncludeDirectives", (Object)this.includeDirectives()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "includeDirectives": {
                return Optional.ofNullable(clazz.cast(this.includeDirectives()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIntrospectionSchemaRequest, T> g) {
        return obj -> g.apply((GetIntrospectionSchemaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private String format;
        private Boolean includeDirectives;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntrospectionSchemaRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.format(model.format);
            this.includeDirectives(model.includeDirectives);
        }

        public final String getApiId() {
            return this.apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        @Transient
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        @Transient
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        @Transient
        public final Builder format(OutputType format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Boolean getIncludeDirectives() {
            return this.includeDirectives;
        }

        public final void setIncludeDirectives(Boolean includeDirectives) {
            this.includeDirectives = includeDirectives;
        }

        @Override
        @Transient
        public final Builder includeDirectives(Boolean includeDirectives) {
            this.includeDirectives = includeDirectives;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIntrospectionSchemaRequest build() {
            return new GetIntrospectionSchemaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIntrospectionSchemaRequest> {
        public Builder apiId(String var1);

        public Builder format(String var1);

        public Builder format(OutputType var1);

        public Builder includeDirectives(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

