/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.AppSyncResponse;
import software.amazon.awssdk.services.appsync.model.DomainNameConfig;
import software.amazon.awssdk.services.appsync.model.DomainNameConfigsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainNamesResponse
extends AppSyncResponse
implements ToCopyableBuilder<Builder, ListDomainNamesResponse> {
    private static final SdkField<List<DomainNameConfig>> DOMAIN_NAME_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("domainNameConfigs").getter(ListDomainNamesResponse.getter(ListDomainNamesResponse::domainNameConfigs)).setter(ListDomainNamesResponse.setter(Builder::domainNameConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainNameConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDomainNamesResponse.getter(ListDomainNamesResponse::nextToken)).setter(ListDomainNamesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_CONFIGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DomainNameConfig> domainNameConfigs;
    private final String nextToken;

    private ListDomainNamesResponse(BuilderImpl builder) {
        super(builder);
        this.domainNameConfigs = builder.domainNameConfigs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDomainNameConfigs() {
        return this.domainNameConfigs != null && !(this.domainNameConfigs instanceof SdkAutoConstructList);
    }

    public final List<DomainNameConfig> domainNameConfigs() {
        return this.domainNameConfigs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainNameConfigs() ? this.domainNameConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainNamesResponse)) {
            return false;
        }
        ListDomainNamesResponse other = (ListDomainNamesResponse)((Object)obj);
        return this.hasDomainNameConfigs() == other.hasDomainNameConfigs() && Objects.equals(this.domainNameConfigs(), other.domainNameConfigs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDomainNamesResponse").add("DomainNameConfigs", this.hasDomainNameConfigs() ? this.domainNameConfigs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainNameConfigs": {
                return Optional.ofNullable(clazz.cast(this.domainNameConfigs()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainNamesResponse, T> g) {
        return obj -> g.apply((ListDomainNamesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncResponse.BuilderImpl
    implements Builder {
        private List<DomainNameConfig> domainNameConfigs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainNamesResponse model) {
            super(model);
            this.domainNameConfigs(model.domainNameConfigs);
            this.nextToken(model.nextToken);
        }

        public final List<DomainNameConfig.Builder> getDomainNameConfigs() {
            List<DomainNameConfig.Builder> result = DomainNameConfigsCopier.copyToBuilder(this.domainNameConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainNameConfigs(Collection<DomainNameConfig.BuilderImpl> domainNameConfigs) {
            this.domainNameConfigs = DomainNameConfigsCopier.copyFromBuilder(domainNameConfigs);
        }

        @Override
        @Transient
        public final Builder domainNameConfigs(Collection<DomainNameConfig> domainNameConfigs) {
            this.domainNameConfigs = DomainNameConfigsCopier.copy(domainNameConfigs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder domainNameConfigs(DomainNameConfig ... domainNameConfigs) {
            this.domainNameConfigs(Arrays.asList(domainNameConfigs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder domainNameConfigs(Consumer<DomainNameConfig.Builder> ... domainNameConfigs) {
            this.domainNameConfigs(Stream.of(domainNameConfigs).map(c -> (DomainNameConfig)((DomainNameConfig.Builder)DomainNameConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDomainNamesResponse build() {
            return new ListDomainNamesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainNamesResponse> {
        public Builder domainNameConfigs(Collection<DomainNameConfig> var1);

        public Builder domainNameConfigs(DomainNameConfig ... var1);

        public Builder domainNameConfigs(Consumer<DomainNameConfig.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

