/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.AppSyncResponse;
import software.amazon.awssdk.services.appsync.model.FunctionConfiguration;
import software.amazon.awssdk.services.appsync.model.FunctionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFunctionsResponse
extends AppSyncResponse
implements ToCopyableBuilder<Builder, ListFunctionsResponse> {
    private static final SdkField<List<FunctionConfiguration>> FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("functions").getter(ListFunctionsResponse.getter(ListFunctionsResponse::functions)).setter(ListFunctionsResponse.setter(Builder::functions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FunctionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFunctionsResponse.getter(ListFunctionsResponse::nextToken)).setter(ListFunctionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<FunctionConfiguration> functions;
    private final String nextToken;

    private ListFunctionsResponse(BuilderImpl builder) {
        super(builder);
        this.functions = builder.functions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFunctions() {
        return this.functions != null && !(this.functions instanceof SdkAutoConstructList);
    }

    public final List<FunctionConfiguration> functions() {
        return this.functions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctions() ? this.functions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionsResponse)) {
            return false;
        }
        ListFunctionsResponse other = (ListFunctionsResponse)((Object)obj);
        return this.hasFunctions() == other.hasFunctions() && Objects.equals(this.functions(), other.functions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFunctionsResponse").add("Functions", this.hasFunctions() ? this.functions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "functions": {
                return Optional.ofNullable(clazz.cast(this.functions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFunctionsResponse, T> g) {
        return obj -> g.apply((ListFunctionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncResponse.BuilderImpl
    implements Builder {
        private List<FunctionConfiguration> functions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionsResponse model) {
            super(model);
            this.functions(model.functions);
            this.nextToken(model.nextToken);
        }

        public final List<FunctionConfiguration.Builder> getFunctions() {
            List<FunctionConfiguration.Builder> result = FunctionsCopier.copyToBuilder(this.functions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder functions(Collection<FunctionConfiguration> functions) {
            this.functions = FunctionsCopier.copy(functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(FunctionConfiguration ... functions) {
            this.functions(Arrays.asList(functions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Consumer<FunctionConfiguration.Builder> ... functions) {
            this.functions(Stream.of(functions).map(c -> (FunctionConfiguration)((FunctionConfiguration.Builder)FunctionConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFunctions(Collection<FunctionConfiguration.BuilderImpl> functions) {
            this.functions = FunctionsCopier.copyFromBuilder(functions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFunctionsResponse build() {
            return new ListFunctionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFunctionsResponse> {
        public Builder functions(Collection<FunctionConfiguration> var1);

        public Builder functions(FunctionConfiguration ... var1);

        public Builder functions(Consumer<FunctionConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

