/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ConflictDetectionType {
    VERSION("VERSION"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ConflictDetectionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConflictDetectionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ConflictDetectionType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConflictDetectionType> knownValues() {
        return Stream.of(ConflictDetectionType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

