/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon RDS HTTP endpoint configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RdsHttpEndpointConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RdsHttpEndpointConfig.Builder, RdsHttpEndpointConfig> {
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsRegion").getter(getter(RdsHttpEndpointConfig::awsRegion)).setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbClusterIdentifier").getter(getter(RdsHttpEndpointConfig::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbClusterIdentifier").build())
            .build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(RdsHttpEndpointConfig::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("schema")
            .getter(getter(RdsHttpEndpointConfig::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final SdkField<String> AWS_SECRET_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsSecretStoreArn").getter(getter(RdsHttpEndpointConfig::awsSecretStoreArn))
            .setter(setter(Builder::awsSecretStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsSecretStoreArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_REGION_FIELD,
            DB_CLUSTER_IDENTIFIER_FIELD, DATABASE_NAME_FIELD, SCHEMA_FIELD, AWS_SECRET_STORE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsRegion;

    private final String dbClusterIdentifier;

    private final String databaseName;

    private final String schema;

    private final String awsSecretStoreArn;

    private RdsHttpEndpointConfig(BuilderImpl builder) {
        this.awsRegion = builder.awsRegion;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.databaseName = builder.databaseName;
        this.schema = builder.schema;
        this.awsSecretStoreArn = builder.awsSecretStoreArn;
    }

    /**
     * <p>
     * AWS Region for RDS HTTP endpoint.
     * </p>
     * 
     * @return AWS Region for RDS HTTP endpoint.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * Amazon RDS cluster ARN.
     * </p>
     * 
     * @return Amazon RDS cluster ARN.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * Logical database name.
     * </p>
     * 
     * @return Logical database name.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * Logical schema name.
     * </p>
     * 
     * @return Logical schema name.
     */
    public final String schema() {
        return schema;
    }

    /**
     * <p>
     * AWS secret store ARN for database credentials.
     * </p>
     * 
     * @return AWS secret store ARN for database credentials.
     */
    public final String awsSecretStoreArn() {
        return awsSecretStoreArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(awsSecretStoreArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsHttpEndpointConfig)) {
            return false;
        }
        RdsHttpEndpointConfig other = (RdsHttpEndpointConfig) obj;
        return Objects.equals(awsRegion(), other.awsRegion())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(schema(), other.schema())
                && Objects.equals(awsSecretStoreArn(), other.awsSecretStoreArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RdsHttpEndpointConfig").add("AwsRegion", awsRegion())
                .add("DbClusterIdentifier", dbClusterIdentifier()).add("DatabaseName", databaseName()).add("Schema", schema())
                .add("AwsSecretStoreArn", awsSecretStoreArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "dbClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "awsSecretStoreArn":
            return Optional.ofNullable(clazz.cast(awsSecretStoreArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RdsHttpEndpointConfig, T> g) {
        return obj -> g.apply((RdsHttpEndpointConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RdsHttpEndpointConfig> {
        /**
         * <p>
         * AWS Region for RDS HTTP endpoint.
         * </p>
         * 
         * @param awsRegion
         *        AWS Region for RDS HTTP endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * Amazon RDS cluster ARN.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        Amazon RDS cluster ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * Logical database name.
         * </p>
         * 
         * @param databaseName
         *        Logical database name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * Logical schema name.
         * </p>
         * 
         * @param schema
         *        Logical schema name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * AWS secret store ARN for database credentials.
         * </p>
         * 
         * @param awsSecretStoreArn
         *        AWS secret store ARN for database credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSecretStoreArn(String awsSecretStoreArn);
    }

    static final class BuilderImpl implements Builder {
        private String awsRegion;

        private String dbClusterIdentifier;

        private String databaseName;

        private String schema;

        private String awsSecretStoreArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsHttpEndpointConfig model) {
            awsRegion(model.awsRegion);
            dbClusterIdentifier(model.dbClusterIdentifier);
            databaseName(model.databaseName);
            schema(model.schema);
            awsSecretStoreArn(model.awsSecretStoreArn);
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getSchema() {
            return schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        public final String getAwsSecretStoreArn() {
            return awsSecretStoreArn;
        }

        @Override
        public final Builder awsSecretStoreArn(String awsSecretStoreArn) {
            this.awsSecretStoreArn = awsSecretStoreArn;
            return this;
        }

        public final void setAwsSecretStoreArn(String awsSecretStoreArn) {
            this.awsSecretStoreArn = awsSecretStoreArn;
        }

        @Override
        public RdsHttpEndpointConfig build() {
            return new RdsHttpEndpointConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
