/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CloudWatch Logs configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogConfig implements SdkPojo, Serializable, ToCopyableBuilder<LogConfig.Builder, LogConfig> {
    private static final SdkField<String> FIELD_LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldLogLevel").getter(getter(LogConfig::fieldLogLevelAsString)).setter(setter(Builder::fieldLogLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldLogLevel").build()).build();

    private static final SdkField<String> CLOUD_WATCH_LOGS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloudWatchLogsRoleArn").getter(getter(LogConfig::cloudWatchLogsRoleArn))
            .setter(setter(Builder::cloudWatchLogsRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogsRoleArn").build())
            .build();

    private static final SdkField<Boolean> EXCLUDE_VERBOSE_CONTENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("excludeVerboseContent").getter(getter(LogConfig::excludeVerboseContent))
            .setter(setter(Builder::excludeVerboseContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludeVerboseContent").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_LOG_LEVEL_FIELD,
            CLOUD_WATCH_LOGS_ROLE_ARN_FIELD, EXCLUDE_VERBOSE_CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fieldLogLevel;

    private final String cloudWatchLogsRoleArn;

    private final Boolean excludeVerboseContent;

    private LogConfig(BuilderImpl builder) {
        this.fieldLogLevel = builder.fieldLogLevel;
        this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
        this.excludeVerboseContent = builder.excludeVerboseContent;
    }

    /**
     * <p>
     * The field logging level. Values can be NONE, ERROR, or ALL.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NONE</b>: No field-level logs are captured.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ERROR</b>: Logs the following information only for the fields that are in error:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The error section in the server response.
     * </p>
     * </li>
     * <li>
     * <p>
     * Field-level errors.
     * </p>
     * </li>
     * <li>
     * <p>
     * The generated request/response functions that got resolved for error fields.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>ALL</b>: The following information is logged for all fields in the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Field-level tracing information.
     * </p>
     * </li>
     * <li>
     * <p>
     * The generated request/response functions that got resolved for each field.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldLogLevel}
     * will return {@link FieldLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldLogLevelAsString}.
     * </p>
     * 
     * @return The field logging level. Values can be NONE, ERROR, or ALL. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NONE</b>: No field-level logs are captured.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ERROR</b>: Logs the following information only for the fields that are in error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The error section in the server response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Field-level errors.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The generated request/response functions that got resolved for error fields.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ALL</b>: The following information is logged for all fields in the query:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Field-level tracing information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The generated request/response functions that got resolved for each field.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see FieldLogLevel
     */
    public final FieldLogLevel fieldLogLevel() {
        return FieldLogLevel.fromValue(fieldLogLevel);
    }

    /**
     * <p>
     * The field logging level. Values can be NONE, ERROR, or ALL.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NONE</b>: No field-level logs are captured.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ERROR</b>: Logs the following information only for the fields that are in error:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The error section in the server response.
     * </p>
     * </li>
     * <li>
     * <p>
     * Field-level errors.
     * </p>
     * </li>
     * <li>
     * <p>
     * The generated request/response functions that got resolved for error fields.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>ALL</b>: The following information is logged for all fields in the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Field-level tracing information.
     * </p>
     * </li>
     * <li>
     * <p>
     * The generated request/response functions that got resolved for each field.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldLogLevel}
     * will return {@link FieldLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldLogLevelAsString}.
     * </p>
     * 
     * @return The field logging level. Values can be NONE, ERROR, or ALL. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NONE</b>: No field-level logs are captured.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ERROR</b>: Logs the following information only for the fields that are in error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The error section in the server response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Field-level errors.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The generated request/response functions that got resolved for error fields.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ALL</b>: The following information is logged for all fields in the query:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Field-level tracing information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The generated request/response functions that got resolved for each field.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see FieldLogLevel
     */
    public final String fieldLogLevelAsString() {
        return fieldLogLevel;
    }

    /**
     * <p>
     * The service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
     * </p>
     * 
     * @return The service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
     */
    public final String cloudWatchLogsRoleArn() {
        return cloudWatchLogsRoleArn;
    }

    /**
     * <p>
     * Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping
     * templates, regardless of logging level.
     * </p>
     * 
     * @return Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping
     *         templates, regardless of logging level.
     */
    public final Boolean excludeVerboseContent() {
        return excludeVerboseContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(excludeVerboseContent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfig)) {
            return false;
        }
        LogConfig other = (LogConfig) obj;
        return Objects.equals(fieldLogLevelAsString(), other.fieldLogLevelAsString())
                && Objects.equals(cloudWatchLogsRoleArn(), other.cloudWatchLogsRoleArn())
                && Objects.equals(excludeVerboseContent(), other.excludeVerboseContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogConfig").add("FieldLogLevel", fieldLogLevelAsString())
                .add("CloudWatchLogsRoleArn", cloudWatchLogsRoleArn()).add("ExcludeVerboseContent", excludeVerboseContent())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fieldLogLevel":
            return Optional.ofNullable(clazz.cast(fieldLogLevelAsString()));
        case "cloudWatchLogsRoleArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsRoleArn()));
        case "excludeVerboseContent":
            return Optional.ofNullable(clazz.cast(excludeVerboseContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogConfig, T> g) {
        return obj -> g.apply((LogConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogConfig> {
        /**
         * <p>
         * The field logging level. Values can be NONE, ERROR, or ALL.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NONE</b>: No field-level logs are captured.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ERROR</b>: Logs the following information only for the fields that are in error:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The error section in the server response.
         * </p>
         * </li>
         * <li>
         * <p>
         * Field-level errors.
         * </p>
         * </li>
         * <li>
         * <p>
         * The generated request/response functions that got resolved for error fields.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>ALL</b>: The following information is logged for all fields in the query:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Field-level tracing information.
         * </p>
         * </li>
         * <li>
         * <p>
         * The generated request/response functions that got resolved for each field.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param fieldLogLevel
         *        The field logging level. Values can be NONE, ERROR, or ALL. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NONE</b>: No field-level logs are captured.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ERROR</b>: Logs the following information only for the fields that are in error:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The error section in the server response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Field-level errors.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The generated request/response functions that got resolved for error fields.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ALL</b>: The following information is logged for all fields in the query:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Field-level tracing information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The generated request/response functions that got resolved for each field.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see FieldLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldLogLevel
         */
        Builder fieldLogLevel(String fieldLogLevel);

        /**
         * <p>
         * The field logging level. Values can be NONE, ERROR, or ALL.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NONE</b>: No field-level logs are captured.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ERROR</b>: Logs the following information only for the fields that are in error:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The error section in the server response.
         * </p>
         * </li>
         * <li>
         * <p>
         * Field-level errors.
         * </p>
         * </li>
         * <li>
         * <p>
         * The generated request/response functions that got resolved for error fields.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>ALL</b>: The following information is logged for all fields in the query:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Field-level tracing information.
         * </p>
         * </li>
         * <li>
         * <p>
         * The generated request/response functions that got resolved for each field.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param fieldLogLevel
         *        The field logging level. Values can be NONE, ERROR, or ALL. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NONE</b>: No field-level logs are captured.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ERROR</b>: Logs the following information only for the fields that are in error:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The error section in the server response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Field-level errors.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The generated request/response functions that got resolved for error fields.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ALL</b>: The following information is logged for all fields in the query:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Field-level tracing information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The generated request/response functions that got resolved for each field.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see FieldLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldLogLevel
         */
        Builder fieldLogLevel(FieldLogLevel fieldLogLevel);

        /**
         * <p>
         * The service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
         * </p>
         * 
         * @param cloudWatchLogsRoleArn
         *        The service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn);

        /**
         * <p>
         * Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping
         * templates, regardless of logging level.
         * </p>
         * 
         * @param excludeVerboseContent
         *        Set to TRUE to exclude sections that contain information such as headers, context, and evaluated
         *        mapping templates, regardless of logging level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeVerboseContent(Boolean excludeVerboseContent);
    }

    static final class BuilderImpl implements Builder {
        private String fieldLogLevel;

        private String cloudWatchLogsRoleArn;

        private Boolean excludeVerboseContent;

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfig model) {
            fieldLogLevel(model.fieldLogLevel);
            cloudWatchLogsRoleArn(model.cloudWatchLogsRoleArn);
            excludeVerboseContent(model.excludeVerboseContent);
        }

        public final String getFieldLogLevel() {
            return fieldLogLevel;
        }

        @Override
        public final Builder fieldLogLevel(String fieldLogLevel) {
            this.fieldLogLevel = fieldLogLevel;
            return this;
        }

        @Override
        public final Builder fieldLogLevel(FieldLogLevel fieldLogLevel) {
            this.fieldLogLevel(fieldLogLevel == null ? null : fieldLogLevel.toString());
            return this;
        }

        public final void setFieldLogLevel(String fieldLogLevel) {
            this.fieldLogLevel = fieldLogLevel;
        }

        public final String getCloudWatchLogsRoleArn() {
            return cloudWatchLogsRoleArn;
        }

        @Override
        public final Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
            return this;
        }

        public final void setCloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
        }

        public final Boolean getExcludeVerboseContent() {
            return excludeVerboseContent;
        }

        @Override
        public final Builder excludeVerboseContent(Boolean excludeVerboseContent) {
            this.excludeVerboseContent = excludeVerboseContent;
            return this;
        }

        public final void setExcludeVerboseContent(Boolean excludeVerboseContent) {
            this.excludeVerboseContent = excludeVerboseContent;
        }

        @Override
        public LogConfig build() {
            return new LogConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
