/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTypeResponse extends AppSyncResponse implements ToCopyableBuilder<GetTypeResponse.Builder, GetTypeResponse> {
    private static final SdkField<Type> TYPE_FIELD = SdkField.<Type> builder(MarshallingType.SDK_POJO).memberName("type")
            .getter(getter(GetTypeResponse::type)).setter(setter(Builder::type)).constructor(Type::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD));

    private final Type type;

    private GetTypeResponse(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
    }

    /**
     * <p>
     * The <code>Type</code> object.
     * </p>
     * 
     * @return The <code>Type</code> object.
     */
    public final Type type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTypeResponse)) {
            return false;
        }
        GetTypeResponse other = (GetTypeResponse) obj;
        return Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTypeResponse").add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTypeResponse, T> g) {
        return obj -> g.apply((GetTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTypeResponse> {
        /**
         * <p>
         * The <code>Type</code> object.
         * </p>
         * 
         * @param type
         *        The <code>Type</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(Type type);

        /**
         * <p>
         * The <code>Type</code> object.
         * </p>
         * This is a convenience that creates an instance of the {@link Type.Builder} avoiding the need to create one
         * manually via {@link Type#builder()}.
         *
         * When the {@link Consumer} completes, {@link Type.Builder#build()} is called immediately and its result is
         * passed to {@link #type(Type)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link Type.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(Type)
         */
        default Builder type(Consumer<Type.Builder> type) {
            return type(Type.builder().applyMutation(type).build());
        }
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private Type type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTypeResponse model) {
            super(model);
            type(model.type);
        }

        public final Type.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        @Override
        public final Builder type(Type type) {
            this.type = type;
            return this;
        }

        public final void setType(Type.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public GetTypeResponse build() {
            return new GetTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
