/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIntrospectionSchemaResponse extends AppSyncResponse implements
        ToCopyableBuilder<GetIntrospectionSchemaResponse.Builder, GetIntrospectionSchemaResponse> {
    private static final SdkField<SdkBytes> SCHEMA_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("schema")
            .getter(getter(GetIntrospectionSchemaResponse::schema))
            .setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_FIELD));

    private final SdkBytes schema;

    private GetIntrospectionSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.schema = builder.schema;
    }

    /**
     * <p>
     * The schema, in GraphQL Schema Definition Language (SDL) format.
     * </p>
     * <p>
     * For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL documentation</a>.
     * </p>
     * 
     * @return The schema, in GraphQL Schema Definition Language (SDL) format.</p>
     *         <p>
     *         For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL documentation</a>.
     */
    public final SdkBytes schema() {
        return schema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntrospectionSchemaResponse)) {
            return false;
        }
        GetIntrospectionSchemaResponse other = (GetIntrospectionSchemaResponse) obj;
        return Objects.equals(schema(), other.schema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIntrospectionSchemaResponse").add("Schema", schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIntrospectionSchemaResponse, T> g) {
        return obj -> g.apply((GetIntrospectionSchemaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIntrospectionSchemaResponse> {
        /**
         * <p>
         * The schema, in GraphQL Schema Definition Language (SDL) format.
         * </p>
         * <p>
         * For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL documentation</a>.
         * </p>
         * 
         * @param schema
         *        The schema, in GraphQL Schema Definition Language (SDL) format.</p>
         *        <p>
         *        For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL
         *        documentation</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(SdkBytes schema);
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private SdkBytes schema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntrospectionSchemaResponse model) {
            super(model);
            schema(model.schema);
        }

        public final ByteBuffer getSchema() {
            return schema == null ? null : schema.asByteBuffer();
        }

        @Override
        public final Builder schema(SdkBytes schema) {
            this.schema = StandardMemberCopier.copy(schema);
            return this;
        }

        public final void setSchema(ByteBuffer schema) {
            schema(schema == null ? null : SdkBytes.fromByteBuffer(schema));
        }

        @Override
        public GetIntrospectionSchemaResponse build() {
            return new GetIntrospectionSchemaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
