/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.appsync.model.CreateApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.CreateApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.CreateFunctionRequest;
import software.amazon.awssdk.services.appsync.model.CreateFunctionResponse;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.CreateResolverRequest;
import software.amazon.awssdk.services.appsync.model.CreateResolverResponse;
import software.amazon.awssdk.services.appsync.model.CreateTypeRequest;
import software.amazon.awssdk.services.appsync.model.CreateTypeResponse;
import software.amazon.awssdk.services.appsync.model.DeleteApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.DeleteApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.appsync.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.DeleteResolverRequest;
import software.amazon.awssdk.services.appsync.model.DeleteResolverResponse;
import software.amazon.awssdk.services.appsync.model.DeleteTypeRequest;
import software.amazon.awssdk.services.appsync.model.DeleteTypeResponse;
import software.amazon.awssdk.services.appsync.model.FlushApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.FlushApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.GetApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.GetApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.GetDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.GetDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.GetFunctionRequest;
import software.amazon.awssdk.services.appsync.model.GetFunctionResponse;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaRequest;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaResponse;
import software.amazon.awssdk.services.appsync.model.GetResolverRequest;
import software.amazon.awssdk.services.appsync.model.GetResolverResponse;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusRequest;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusResponse;
import software.amazon.awssdk.services.appsync.model.GetTypeRequest;
import software.amazon.awssdk.services.appsync.model.GetTypeResponse;
import software.amazon.awssdk.services.appsync.model.ListApiKeysRequest;
import software.amazon.awssdk.services.appsync.model.ListApiKeysResponse;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.appsync.model.ListFunctionsRequest;
import software.amazon.awssdk.services.appsync.model.ListFunctionsResponse;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse;
import software.amazon.awssdk.services.appsync.model.ListResolversRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversResponse;
import software.amazon.awssdk.services.appsync.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appsync.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appsync.model.ListTypesRequest;
import software.amazon.awssdk.services.appsync.model.ListTypesResponse;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationRequest;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationResponse;
import software.amazon.awssdk.services.appsync.model.TagResourceRequest;
import software.amazon.awssdk.services.appsync.model.TagResourceResponse;
import software.amazon.awssdk.services.appsync.model.UntagResourceRequest;
import software.amazon.awssdk.services.appsync.model.UntagResourceResponse;
import software.amazon.awssdk.services.appsync.model.UpdateApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.UpdateApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.UpdateApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.UpdateFunctionRequest;
import software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.UpdateResolverRequest;
import software.amazon.awssdk.services.appsync.model.UpdateResolverResponse;
import software.amazon.awssdk.services.appsync.model.UpdateTypeRequest;
import software.amazon.awssdk.services.appsync.model.UpdateTypeResponse;

/**
 * Service client for accessing AWSAppSync asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * AWS AppSync provides API actions for creating and interacting with data sources using GraphQL from your application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface AppSyncAsyncClient extends SdkClient {
    String SERVICE_NAME = "appsync";

    /**
     * Create a {@link AppSyncAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppSyncAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppSyncAsyncClient}.
     */
    static AppSyncAsyncClientBuilder builder() {
        return new DefaultAppSyncAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a cache for the GraphQL API.
     * </p>
     *
     * @param createApiCacheRequest
     *        Represents the input of a <code>CreateApiCache</code> operation.
     * @return A Java Future containing the result of the CreateApiCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.CreateApiCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateApiCacheResponse> createApiCache(CreateApiCacheRequest createApiCacheRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a cache for the GraphQL API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApiCacheRequest.Builder} avoiding the need to
     * create one manually via {@link CreateApiCacheRequest#builder()}
     * </p>
     *
     * @param createApiCacheRequest
     *        A {@link Consumer} that will call methods on {@link CreateApiCacheRequest.Builder} to create a request.
     *        Represents the input of a <code>CreateApiCache</code> operation.
     * @return A Java Future containing the result of the CreateApiCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.CreateApiCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateApiCacheResponse> createApiCache(Consumer<CreateApiCacheRequest.Builder> createApiCacheRequest) {
        return createApiCache(CreateApiCacheRequest.builder().applyMutation(createApiCacheRequest).build());
    }

    /**
     * <p>
     * Creates a unique key that you can distribute to clients who are executing your API.
     * </p>
     *
     * @param createApiKeyRequest
     * @return A Java Future containing the result of the CreateApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>ApiKeyLimitExceededException The API key exceeded a limit. Try your request again.</li>
     *         <li>ApiKeyValidityOutOfBoundsException The API key expiration must be set to a value between 1 and 365
     *         days from creation (for <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.CreateApiKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateApiKeyResponse> createApiKey(CreateApiKeyRequest createApiKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a unique key that you can distribute to clients who are executing your API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApiKeyRequest.Builder} avoiding the need to
     * create one manually via {@link CreateApiKeyRequest#builder()}
     * </p>
     *
     * @param createApiKeyRequest
     *        A {@link Consumer} that will call methods on {@link CreateApiKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>ApiKeyLimitExceededException The API key exceeded a limit. Try your request again.</li>
     *         <li>ApiKeyValidityOutOfBoundsException The API key expiration must be set to a value between 1 and 365
     *         days from creation (for <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.CreateApiKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateApiKeyResponse> createApiKey(Consumer<CreateApiKeyRequest.Builder> createApiKeyRequest) {
        return createApiKey(CreateApiKeyRequest.builder().applyMutation(createApiKeyRequest).build());
    }

    /**
     * <p>
     * Creates a <code>DataSource</code> object.
     * </p>
     *
     * @param createDataSourceRequest
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.CreateDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataSourceResponse> createDataSource(CreateDataSourceRequest createDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>DataSource</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataSourceRequest#builder()}
     * </p>
     *
     * @param createDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link CreateDataSourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.CreateDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataSourceResponse> createDataSource(
            Consumer<CreateDataSourceRequest.Builder> createDataSourceRequest) {
        return createDataSource(CreateDataSourceRequest.builder().applyMutation(createDataSourceRequest).build());
    }

    /**
     * <p>
     * Creates a <code>Function</code> object.
     * </p>
     * <p>
     * A function is a reusable entity. Multiple functions can be used to compose the resolver logic.
     * </p>
     *
     * @param createFunctionRequest
     * @return A Java Future containing the result of the CreateFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.CreateFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFunctionResponse> createFunction(CreateFunctionRequest createFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>Function</code> object.
     * </p>
     * <p>
     * A function is a reusable entity. Multiple functions can be used to compose the resolver logic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFunctionRequest#builder()}
     * </p>
     *
     * @param createFunctionRequest
     *        A {@link Consumer} that will call methods on {@link CreateFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.CreateFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFunctionResponse> createFunction(Consumer<CreateFunctionRequest.Builder> createFunctionRequest) {
        return createFunction(CreateFunctionRequest.builder().applyMutation(createFunctionRequest).build());
    }

    /**
     * <p>
     * Creates a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param createGraphqlApiRequest
     * @return A Java Future containing the result of the CreateGraphqlApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>ApiLimitExceededException The GraphQL API exceeded a limit. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.CreateGraphqlApi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGraphqlApiResponse> createGraphqlApi(CreateGraphqlApiRequest createGraphqlApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>GraphqlApi</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGraphqlApiRequest.Builder} avoiding the need
     * to create one manually via {@link CreateGraphqlApiRequest#builder()}
     * </p>
     *
     * @param createGraphqlApiRequest
     *        A {@link Consumer} that will call methods on {@link CreateGraphqlApiRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateGraphqlApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>ApiLimitExceededException The GraphQL API exceeded a limit. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.CreateGraphqlApi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGraphqlApiResponse> createGraphqlApi(
            Consumer<CreateGraphqlApiRequest.Builder> createGraphqlApiRequest) {
        return createGraphqlApi(CreateGraphqlApiRequest.builder().applyMutation(createGraphqlApiRequest).build());
    }

    /**
     * <p>
     * Creates a <code>Resolver</code> object.
     * </p>
     * <p>
     * A resolver converts incoming requests into a format that a data source can understand and converts the data
     * source's responses into GraphQL.
     * </p>
     *
     * @param createResolverRequest
     * @return A Java Future containing the result of the CreateResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.CreateResolver
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateResolverResponse> createResolver(CreateResolverRequest createResolverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>Resolver</code> object.
     * </p>
     * <p>
     * A resolver converts incoming requests into a format that a data source can understand and converts the data
     * source's responses into GraphQL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResolverRequest.Builder} avoiding the need to
     * create one manually via {@link CreateResolverRequest#builder()}
     * </p>
     *
     * @param createResolverRequest
     *        A {@link Consumer} that will call methods on {@link CreateResolverRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.CreateResolver
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateResolverResponse> createResolver(Consumer<CreateResolverRequest.Builder> createResolverRequest) {
        return createResolver(CreateResolverRequest.builder().applyMutation(createResolverRequest).build());
    }

    /**
     * <p>
     * Creates a <code>Type</code> object.
     * </p>
     *
     * @param createTypeRequest
     * @return A Java Future containing the result of the CreateType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.CreateType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTypeResponse> createType(CreateTypeRequest createTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>Type</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTypeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTypeRequest#builder()}
     * </p>
     *
     * @param createTypeRequest
     *        A {@link Consumer} that will call methods on {@link CreateTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.CreateType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTypeResponse> createType(Consumer<CreateTypeRequest.Builder> createTypeRequest) {
        return createType(CreateTypeRequest.builder().applyMutation(createTypeRequest).build());
    }

    /**
     * <p>
     * Deletes an <code>ApiCache</code> object.
     * </p>
     *
     * @param deleteApiCacheRequest
     *        Represents the input of a <code>DeleteApiCache</code> operation.
     * @return A Java Future containing the result of the DeleteApiCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.DeleteApiCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteApiCacheResponse> deleteApiCache(DeleteApiCacheRequest deleteApiCacheRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an <code>ApiCache</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApiCacheRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteApiCacheRequest#builder()}
     * </p>
     *
     * @param deleteApiCacheRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApiCacheRequest.Builder} to create a request.
     *        Represents the input of a <code>DeleteApiCache</code> operation.
     * @return A Java Future containing the result of the DeleteApiCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.DeleteApiCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteApiCacheResponse> deleteApiCache(Consumer<DeleteApiCacheRequest.Builder> deleteApiCacheRequest) {
        return deleteApiCache(DeleteApiCacheRequest.builder().applyMutation(deleteApiCacheRequest).build());
    }

    /**
     * <p>
     * Deletes an API key.
     * </p>
     *
     * @param deleteApiKeyRequest
     * @return A Java Future containing the result of the DeleteApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.DeleteApiKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteApiKeyResponse> deleteApiKey(DeleteApiKeyRequest deleteApiKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an API key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApiKeyRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteApiKeyRequest#builder()}
     * </p>
     *
     * @param deleteApiKeyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApiKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.DeleteApiKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteApiKeyResponse> deleteApiKey(Consumer<DeleteApiKeyRequest.Builder> deleteApiKeyRequest) {
        return deleteApiKey(DeleteApiKeyRequest.builder().applyMutation(deleteApiKeyRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>DataSource</code> object.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.DeleteDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>DataSource</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDataSourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.DeleteDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(
            Consumer<DeleteDataSourceRequest.Builder> deleteDataSourceRequest) {
        return deleteDataSource(DeleteDataSourceRequest.builder().applyMutation(deleteDataSourceRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>Function</code>.
     * </p>
     *
     * @param deleteFunctionRequest
     * @return A Java Future containing the result of the DeleteFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.DeleteFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFunctionResponse> deleteFunction(DeleteFunctionRequest deleteFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>Function</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFunctionRequest#builder()}
     * </p>
     *
     * @param deleteFunctionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.DeleteFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFunctionResponse> deleteFunction(Consumer<DeleteFunctionRequest.Builder> deleteFunctionRequest) {
        return deleteFunction(DeleteFunctionRequest.builder().applyMutation(deleteFunctionRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param deleteGraphqlApiRequest
     * @return A Java Future containing the result of the DeleteGraphqlApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>AccessDeniedException You do not have access to perform this operation on this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.DeleteGraphqlApi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGraphqlApiResponse> deleteGraphqlApi(DeleteGraphqlApiRequest deleteGraphqlApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>GraphqlApi</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGraphqlApiRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteGraphqlApiRequest#builder()}
     * </p>
     *
     * @param deleteGraphqlApiRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGraphqlApiRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGraphqlApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>AccessDeniedException You do not have access to perform this operation on this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.DeleteGraphqlApi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGraphqlApiResponse> deleteGraphqlApi(
            Consumer<DeleteGraphqlApiRequest.Builder> deleteGraphqlApiRequest) {
        return deleteGraphqlApi(DeleteGraphqlApiRequest.builder().applyMutation(deleteGraphqlApiRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>Resolver</code> object.
     * </p>
     *
     * @param deleteResolverRequest
     * @return A Java Future containing the result of the DeleteResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.DeleteResolver
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteResolverResponse> deleteResolver(DeleteResolverRequest deleteResolverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>Resolver</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResolverRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteResolverRequest#builder()}
     * </p>
     *
     * @param deleteResolverRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResolverRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.DeleteResolver
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteResolverResponse> deleteResolver(Consumer<DeleteResolverRequest.Builder> deleteResolverRequest) {
        return deleteResolver(DeleteResolverRequest.builder().applyMutation(deleteResolverRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>Type</code> object.
     * </p>
     *
     * @param deleteTypeRequest
     * @return A Java Future containing the result of the DeleteType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.DeleteType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTypeResponse> deleteType(DeleteTypeRequest deleteTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>Type</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTypeRequest#builder()}
     * </p>
     *
     * @param deleteTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.DeleteType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTypeResponse> deleteType(Consumer<DeleteTypeRequest.Builder> deleteTypeRequest) {
        return deleteType(DeleteTypeRequest.builder().applyMutation(deleteTypeRequest).build());
    }

    /**
     * <p>
     * Flushes an <code>ApiCache</code> object.
     * </p>
     *
     * @param flushApiCacheRequest
     *        Represents the input of a <code>FlushApiCache</code> operation.
     * @return A Java Future containing the result of the FlushApiCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.FlushApiCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/FlushApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<FlushApiCacheResponse> flushApiCache(FlushApiCacheRequest flushApiCacheRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Flushes an <code>ApiCache</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FlushApiCacheRequest.Builder} avoiding the need to
     * create one manually via {@link FlushApiCacheRequest#builder()}
     * </p>
     *
     * @param flushApiCacheRequest
     *        A {@link Consumer} that will call methods on {@link FlushApiCacheRequest.Builder} to create a request.
     *        Represents the input of a <code>FlushApiCache</code> operation.
     * @return A Java Future containing the result of the FlushApiCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.FlushApiCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/FlushApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<FlushApiCacheResponse> flushApiCache(Consumer<FlushApiCacheRequest.Builder> flushApiCacheRequest) {
        return flushApiCache(FlushApiCacheRequest.builder().applyMutation(flushApiCacheRequest).build());
    }

    /**
     * <p>
     * Retrieves an <code>ApiCache</code> object.
     * </p>
     *
     * @param getApiCacheRequest
     *        Represents the input of a <code>GetApiCache</code> operation.
     * @return A Java Future containing the result of the GetApiCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetApiCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApiCacheResponse> getApiCache(GetApiCacheRequest getApiCacheRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an <code>ApiCache</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiCacheRequest.Builder} avoiding the need to
     * create one manually via {@link GetApiCacheRequest#builder()}
     * </p>
     *
     * @param getApiCacheRequest
     *        A {@link Consumer} that will call methods on {@link GetApiCacheRequest.Builder} to create a request.
     *        Represents the input of a <code>GetApiCache</code> operation.
     * @return A Java Future containing the result of the GetApiCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetApiCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApiCacheResponse> getApiCache(Consumer<GetApiCacheRequest.Builder> getApiCacheRequest) {
        return getApiCache(GetApiCacheRequest.builder().applyMutation(getApiCacheRequest).build());
    }

    /**
     * <p>
     * Retrieves a <code>DataSource</code> object.
     * </p>
     *
     * @param getDataSourceRequest
     * @return A Java Future containing the result of the GetDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSourceResponse> getDataSource(GetDataSourceRequest getDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a <code>DataSource</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSourceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDataSourceRequest#builder()}
     * </p>
     *
     * @param getDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link GetDataSourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSourceResponse> getDataSource(Consumer<GetDataSourceRequest.Builder> getDataSourceRequest) {
        return getDataSource(GetDataSourceRequest.builder().applyMutation(getDataSourceRequest).build());
    }

    /**
     * <p>
     * Get a <code>Function</code>.
     * </p>
     *
     * @param getFunctionRequest
     * @return A Java Future containing the result of the GetFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFunctionResponse> getFunction(GetFunctionRequest getFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a <code>Function</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link GetFunctionRequest#builder()}
     * </p>
     *
     * @param getFunctionRequest
     *        A {@link Consumer} that will call methods on {@link GetFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFunctionResponse> getFunction(Consumer<GetFunctionRequest.Builder> getFunctionRequest) {
        return getFunction(GetFunctionRequest.builder().applyMutation(getFunctionRequest).build());
    }

    /**
     * <p>
     * Retrieves a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param getGraphqlApiRequest
     * @return A Java Future containing the result of the GetGraphqlApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>AccessDeniedException You do not have access to perform this operation on this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetGraphqlApi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGraphqlApiResponse> getGraphqlApi(GetGraphqlApiRequest getGraphqlApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a <code>GraphqlApi</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGraphqlApiRequest.Builder} avoiding the need to
     * create one manually via {@link GetGraphqlApiRequest#builder()}
     * </p>
     *
     * @param getGraphqlApiRequest
     *        A {@link Consumer} that will call methods on {@link GetGraphqlApiRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGraphqlApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>AccessDeniedException You do not have access to perform this operation on this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetGraphqlApi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGraphqlApiResponse> getGraphqlApi(Consumer<GetGraphqlApiRequest.Builder> getGraphqlApiRequest) {
        return getGraphqlApi(GetGraphqlApiRequest.builder().applyMutation(getGraphqlApiRequest).build());
    }

    /**
     * <p>
     * Retrieves the introspection schema for a GraphQL API.
     * </p>
     *
     * @param getIntrospectionSchemaRequest
     * @return A Java Future containing the result of the GetIntrospectionSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GraphQlSchemaException The GraphQL schema is not valid.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetIntrospectionSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetIntrospectionSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetIntrospectionSchemaResponse> getIntrospectionSchema(
            GetIntrospectionSchemaRequest getIntrospectionSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the introspection schema for a GraphQL API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntrospectionSchemaRequest.Builder} avoiding the
     * need to create one manually via {@link GetIntrospectionSchemaRequest#builder()}
     * </p>
     *
     * @param getIntrospectionSchemaRequest
     *        A {@link Consumer} that will call methods on {@link GetIntrospectionSchemaRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetIntrospectionSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GraphQlSchemaException The GraphQL schema is not valid.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetIntrospectionSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetIntrospectionSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetIntrospectionSchemaResponse> getIntrospectionSchema(
            Consumer<GetIntrospectionSchemaRequest.Builder> getIntrospectionSchemaRequest) {
        return getIntrospectionSchema(GetIntrospectionSchemaRequest.builder().applyMutation(getIntrospectionSchemaRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a <code>Resolver</code> object.
     * </p>
     *
     * @param getResolverRequest
     * @return A Java Future containing the result of the GetResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetResolver
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResolverResponse> getResolver(GetResolverRequest getResolverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a <code>Resolver</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverRequest.Builder} avoiding the need to
     * create one manually via {@link GetResolverRequest#builder()}
     * </p>
     *
     * @param getResolverRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetResolver
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResolverResponse> getResolver(Consumer<GetResolverRequest.Builder> getResolverRequest) {
        return getResolver(GetResolverRequest.builder().applyMutation(getResolverRequest).build());
    }

    /**
     * <p>
     * Retrieves the current status of a schema creation operation.
     * </p>
     *
     * @param getSchemaCreationStatusRequest
     * @return A Java Future containing the result of the GetSchemaCreationStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetSchemaCreationStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetSchemaCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSchemaCreationStatusResponse> getSchemaCreationStatus(
            GetSchemaCreationStatusRequest getSchemaCreationStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current status of a schema creation operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaCreationStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetSchemaCreationStatusRequest#builder()}
     * </p>
     *
     * @param getSchemaCreationStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetSchemaCreationStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSchemaCreationStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetSchemaCreationStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetSchemaCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSchemaCreationStatusResponse> getSchemaCreationStatus(
            Consumer<GetSchemaCreationStatusRequest.Builder> getSchemaCreationStatusRequest) {
        return getSchemaCreationStatus(GetSchemaCreationStatusRequest.builder().applyMutation(getSchemaCreationStatusRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a <code>Type</code> object.
     * </p>
     *
     * @param getTypeRequest
     * @return A Java Future containing the result of the GetType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTypeResponse> getType(GetTypeRequest getTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a <code>Type</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTypeRequest.Builder} avoiding the need to create
     * one manually via {@link GetTypeRequest#builder()}
     * </p>
     *
     * @param getTypeRequest
     *        A {@link Consumer} that will call methods on {@link GetTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.GetType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTypeResponse> getType(Consumer<GetTypeRequest.Builder> getTypeRequest) {
        return getType(GetTypeRequest.builder().applyMutation(getTypeRequest).build());
    }

    /**
     * <p>
     * Lists the API keys for a given API.
     * </p>
     * <note>
     * <p>
     * API keys are deleted automatically 60 days after they expire. However, they may still be included in the response
     * until they have actually been deleted. You can safely call <code>DeleteApiKey</code> to manually delete a key
     * before it's automatically deleted.
     * </p>
     * </note>
     *
     * @param listApiKeysRequest
     * @return A Java Future containing the result of the ListApiKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListApiKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListApiKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListApiKeysResponse> listApiKeys(ListApiKeysRequest listApiKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the API keys for a given API.
     * </p>
     * <note>
     * <p>
     * API keys are deleted automatically 60 days after they expire. However, they may still be included in the response
     * until they have actually been deleted. You can safely call <code>DeleteApiKey</code> to manually delete a key
     * before it's automatically deleted.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApiKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListApiKeysRequest#builder()}
     * </p>
     *
     * @param listApiKeysRequest
     *        A {@link Consumer} that will call methods on {@link ListApiKeysRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListApiKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListApiKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListApiKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListApiKeysResponse> listApiKeys(Consumer<ListApiKeysRequest.Builder> listApiKeysRequest) {
        return listApiKeys(ListApiKeysRequest.builder().applyMutation(listApiKeysRequest).build());
    }

    /**
     * <p>
     * Lists the data sources for a given API.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListDataSources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(ListDataSourcesRequest listDataSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the data sources for a given API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListDataSources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(
            Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest) {
        return listDataSources(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * List multiple functions.
     * </p>
     *
     * @param listFunctionsRequest
     * @return A Java Future containing the result of the ListFunctions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFunctionsResponse> listFunctions(ListFunctionsRequest listFunctionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List multiple functions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFunctionsRequest#builder()}
     * </p>
     *
     * @param listFunctionsRequest
     *        A {@link Consumer} that will call methods on {@link ListFunctionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFunctions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFunctionsResponse> listFunctions(Consumer<ListFunctionsRequest.Builder> listFunctionsRequest) {
        return listFunctions(ListFunctionsRequest.builder().applyMutation(listFunctionsRequest).build());
    }

    /**
     * <p>
     * Lists your GraphQL APIs.
     * </p>
     *
     * @param listGraphqlApisRequest
     * @return A Java Future containing the result of the ListGraphqlApis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListGraphqlApis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListGraphqlApis" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGraphqlApisResponse> listGraphqlApis(ListGraphqlApisRequest listGraphqlApisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your GraphQL APIs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGraphqlApisRequest.Builder} avoiding the need
     * to create one manually via {@link ListGraphqlApisRequest#builder()}
     * </p>
     *
     * @param listGraphqlApisRequest
     *        A {@link Consumer} that will call methods on {@link ListGraphqlApisRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGraphqlApis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListGraphqlApis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListGraphqlApis" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGraphqlApisResponse> listGraphqlApis(
            Consumer<ListGraphqlApisRequest.Builder> listGraphqlApisRequest) {
        return listGraphqlApis(ListGraphqlApisRequest.builder().applyMutation(listGraphqlApisRequest).build());
    }

    /**
     * <p>
     * Lists your GraphQL APIs.
     * </p>
     *
     * @return A Java Future containing the result of the ListGraphqlApis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListGraphqlApis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListGraphqlApis" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGraphqlApisResponse> listGraphqlApis() {
        return listGraphqlApis(ListGraphqlApisRequest.builder().build());
    }

    /**
     * <p>
     * Lists the resolvers for a given API and type.
     * </p>
     *
     * @param listResolversRequest
     * @return A Java Future containing the result of the ListResolvers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListResolvers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolvers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResolversResponse> listResolvers(ListResolversRequest listResolversRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resolvers for a given API and type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolversRequest.Builder} avoiding the need to
     * create one manually via {@link ListResolversRequest#builder()}
     * </p>
     *
     * @param listResolversRequest
     *        A {@link Consumer} that will call methods on {@link ListResolversRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListResolvers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListResolvers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolvers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResolversResponse> listResolvers(Consumer<ListResolversRequest.Builder> listResolversRequest) {
        return listResolvers(ListResolversRequest.builder().applyMutation(listResolversRequest).build());
    }

    /**
     * <p>
     * List the resolvers that are associated with a specific function.
     * </p>
     *
     * @param listResolversByFunctionRequest
     * @return A Java Future containing the result of the ListResolversByFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListResolversByFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolversByFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolversByFunctionResponse> listResolversByFunction(
            ListResolversByFunctionRequest listResolversByFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the resolvers that are associated with a specific function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolversByFunctionRequest.Builder} avoiding
     * the need to create one manually via {@link ListResolversByFunctionRequest#builder()}
     * </p>
     *
     * @param listResolversByFunctionRequest
     *        A {@link Consumer} that will call methods on {@link ListResolversByFunctionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListResolversByFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListResolversByFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolversByFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResolversByFunctionResponse> listResolversByFunction(
            Consumer<ListResolversByFunctionRequest.Builder> listResolversByFunctionRequest) {
        return listResolversByFunction(ListResolversByFunctionRequest.builder().applyMutation(listResolversByFunctionRequest)
                .build());
    }

    /**
     * <p>
     * Lists the tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>AccessDeniedException You do not have access to perform this operation on this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>AccessDeniedException You do not have access to perform this operation on this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the types for a given API.
     * </p>
     *
     * @param listTypesRequest
     * @return A Java Future containing the result of the ListTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTypesResponse> listTypes(ListTypesRequest listTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the types for a given API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTypesRequest#builder()}
     * </p>
     *
     * @param listTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListTypesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.ListTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTypesResponse> listTypes(Consumer<ListTypesRequest.Builder> listTypesRequest) {
        return listTypes(ListTypesRequest.builder().applyMutation(listTypesRequest).build());
    }

    /**
     * <p>
     * Adds a new schema to your GraphQL API.
     * </p>
     * <p>
     * This operation is asynchronous. Use to determine when it has completed.
     * </p>
     *
     * @param startSchemaCreationRequest
     * @return A Java Future containing the result of the StartSchemaCreation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.StartSchemaCreation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/StartSchemaCreation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartSchemaCreationResponse> startSchemaCreation(
            StartSchemaCreationRequest startSchemaCreationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new schema to your GraphQL API.
     * </p>
     * <p>
     * This operation is asynchronous. Use to determine when it has completed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSchemaCreationRequest.Builder} avoiding the
     * need to create one manually via {@link StartSchemaCreationRequest#builder()}
     * </p>
     *
     * @param startSchemaCreationRequest
     *        A {@link Consumer} that will call methods on {@link StartSchemaCreationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartSchemaCreation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.StartSchemaCreation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/StartSchemaCreation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartSchemaCreationResponse> startSchemaCreation(
            Consumer<StartSchemaCreationRequest.Builder> startSchemaCreationRequest) {
        return startSchemaCreation(StartSchemaCreationRequest.builder().applyMutation(startSchemaCreationRequest).build());
    }

    /**
     * <p>
     * Tags a resource with user-supplied tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>AccessDeniedException You do not have access to perform this operation on this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a resource with user-supplied tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>AccessDeniedException You do not have access to perform this operation on this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untags a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>AccessDeniedException You do not have access to perform this operation on this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untags a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>AccessDeniedException You do not have access to perform this operation on this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the cache for the GraphQL API.
     * </p>
     *
     * @param updateApiCacheRequest
     *        Represents the input of a <code>UpdateApiCache</code> operation.
     * @return A Java Future containing the result of the UpdateApiCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UpdateApiCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateApiCacheResponse> updateApiCache(UpdateApiCacheRequest updateApiCacheRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the cache for the GraphQL API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApiCacheRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateApiCacheRequest#builder()}
     * </p>
     *
     * @param updateApiCacheRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApiCacheRequest.Builder} to create a request.
     *        Represents the input of a <code>UpdateApiCache</code> operation.
     * @return A Java Future containing the result of the UpdateApiCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UpdateApiCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateApiCacheResponse> updateApiCache(Consumer<UpdateApiCacheRequest.Builder> updateApiCacheRequest) {
        return updateApiCache(UpdateApiCacheRequest.builder().applyMutation(updateApiCacheRequest).build());
    }

    /**
     * <p>
     * Updates an API key. The key can be updated while it is not deleted.
     * </p>
     *
     * @param updateApiKeyRequest
     * @return A Java Future containing the result of the UpdateApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>ApiKeyValidityOutOfBoundsException The API key expiration must be set to a value between 1 and 365
     *         days from creation (for <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UpdateApiKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateApiKeyResponse> updateApiKey(UpdateApiKeyRequest updateApiKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an API key. The key can be updated while it is not deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApiKeyRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateApiKeyRequest#builder()}
     * </p>
     *
     * @param updateApiKeyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApiKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>ApiKeyValidityOutOfBoundsException The API key expiration must be set to a value between 1 and 365
     *         days from creation (for <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UpdateApiKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateApiKeyResponse> updateApiKey(Consumer<UpdateApiKeyRequest.Builder> updateApiKeyRequest) {
        return updateApiKey(UpdateApiKeyRequest.builder().applyMutation(updateApiKeyRequest).build());
    }

    /**
     * <p>
     * Updates a <code>DataSource</code> object.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UpdateDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <code>DataSource</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDataSourceRequest#builder()}
     * </p>
     *
     * @param updateDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDataSourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UpdateDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(
            Consumer<UpdateDataSourceRequest.Builder> updateDataSourceRequest) {
        return updateDataSource(UpdateDataSourceRequest.builder().applyMutation(updateDataSourceRequest).build());
    }

    /**
     * <p>
     * Updates a <code>Function</code> object.
     * </p>
     *
     * @param updateFunctionRequest
     * @return A Java Future containing the result of the UpdateFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UpdateFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFunctionResponse> updateFunction(UpdateFunctionRequest updateFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <code>Function</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFunctionRequest#builder()}
     * </p>
     *
     * @param updateFunctionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UpdateFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFunctionResponse> updateFunction(Consumer<UpdateFunctionRequest.Builder> updateFunctionRequest) {
        return updateFunction(UpdateFunctionRequest.builder().applyMutation(updateFunctionRequest).build());
    }

    /**
     * <p>
     * Updates a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param updateGraphqlApiRequest
     * @return A Java Future containing the result of the UpdateGraphqlApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>AccessDeniedException You do not have access to perform this operation on this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UpdateGraphqlApi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGraphqlApiResponse> updateGraphqlApi(UpdateGraphqlApiRequest updateGraphqlApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <code>GraphqlApi</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGraphqlApiRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateGraphqlApiRequest#builder()}
     * </p>
     *
     * @param updateGraphqlApiRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGraphqlApiRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateGraphqlApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>AccessDeniedException You do not have access to perform this operation on this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UpdateGraphqlApi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGraphqlApiResponse> updateGraphqlApi(
            Consumer<UpdateGraphqlApiRequest.Builder> updateGraphqlApiRequest) {
        return updateGraphqlApi(UpdateGraphqlApiRequest.builder().applyMutation(updateGraphqlApiRequest).build());
    }

    /**
     * <p>
     * Updates a <code>Resolver</code> object.
     * </p>
     *
     * @param updateResolverRequest
     * @return A Java Future containing the result of the UpdateResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UpdateResolver
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateResolverResponse> updateResolver(UpdateResolverRequest updateResolverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <code>Resolver</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResolverRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateResolverRequest#builder()}
     * </p>
     *
     * @param updateResolverRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResolverRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UpdateResolver
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateResolverResponse> updateResolver(Consumer<UpdateResolverRequest.Builder> updateResolverRequest) {
        return updateResolver(UpdateResolverRequest.builder().applyMutation(updateResolverRequest).build());
    }

    /**
     * <p>
     * Updates a <code>Type</code> object.
     * </p>
     *
     * @param updateTypeRequest
     * @return A Java Future containing the result of the UpdateType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UpdateType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTypeResponse> updateType(UpdateTypeRequest updateTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <code>Type</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTypeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTypeRequest#builder()}
     * </p>
     *
     * @param updateTypeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and then try again.</li>
     *         <li>ConcurrentModificationException Another modification is in progress at this time and it must complete
     *         before you can make your change.</li>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource, and then
     *         try again.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An internal AWS AppSync error occurred. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppSyncException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppSyncAsyncClient.UpdateType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTypeResponse> updateType(Consumer<UpdateTypeRequest.Builder> updateTypeRequest) {
        return updateType(UpdateTypeRequest.builder().applyMutation(updateTypeRequest).build());
    }
}
