/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvider;
import software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvidersCopier;
import software.amazon.awssdk.services.appsync.model.AuthenticationType;
import software.amazon.awssdk.services.appsync.model.LogConfig;
import software.amazon.awssdk.services.appsync.model.MapOfStringToStringCopier;
import software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig;
import software.amazon.awssdk.services.appsync.model.TagMapCopier;
import software.amazon.awssdk.services.appsync.model.UserPoolConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GraphqlApi
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GraphqlApi> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GraphqlApi.getter(GraphqlApi::name)).setter(GraphqlApi.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiId").getter(GraphqlApi.getter(GraphqlApi::apiId)).setter(GraphqlApi.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiId").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authenticationType").getter(GraphqlApi.getter(GraphqlApi::authenticationTypeAsString)).setter(GraphqlApi.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build()}).build();
    private static final SdkField<LogConfig> LOG_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logConfig").getter(GraphqlApi.getter(GraphqlApi::logConfig)).setter(GraphqlApi.setter(Builder::logConfig)).constructor(LogConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfig").build()}).build();
    private static final SdkField<UserPoolConfig> USER_POOL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userPoolConfig").getter(GraphqlApi.getter(GraphqlApi::userPoolConfig)).setter(GraphqlApi.setter(Builder::userPoolConfig)).constructor(UserPoolConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolConfig").build()}).build();
    private static final SdkField<OpenIDConnectConfig> OPEN_ID_CONNECT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("openIDConnectConfig").getter(GraphqlApi.getter(GraphqlApi::openIDConnectConfig)).setter(GraphqlApi.setter(Builder::openIDConnectConfig)).constructor(OpenIDConnectConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDConnectConfig").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GraphqlApi.getter(GraphqlApi::arn)).setter(GraphqlApi.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Map<String, String>> URIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("uris").getter(GraphqlApi.getter(GraphqlApi::uris)).setter(GraphqlApi.setter(Builder::uris)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uris").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GraphqlApi.getter(GraphqlApi::tags)).setter(GraphqlApi.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<AdditionalAuthenticationProvider>> ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("additionalAuthenticationProviders").getter(GraphqlApi.getter(GraphqlApi::additionalAuthenticationProviders)).setter(GraphqlApi.setter(Builder::additionalAuthenticationProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAuthenticationProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdditionalAuthenticationProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> XRAY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("xrayEnabled").getter(GraphqlApi.getter(GraphqlApi::xrayEnabled)).setter(GraphqlApi.setter(Builder::xrayEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xrayEnabled").build()}).build();
    private static final SdkField<String> WAF_WEB_ACL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("wafWebAclArn").getter(GraphqlApi.getter(GraphqlApi::wafWebAclArn)).setter(GraphqlApi.setter(Builder::wafWebAclArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wafWebAclArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, API_ID_FIELD, AUTHENTICATION_TYPE_FIELD, LOG_CONFIG_FIELD, USER_POOL_CONFIG_FIELD, OPEN_ID_CONNECT_CONFIG_FIELD, ARN_FIELD, URIS_FIELD, TAGS_FIELD, ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD, XRAY_ENABLED_FIELD, WAF_WEB_ACL_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String apiId;
    private final String authenticationType;
    private final LogConfig logConfig;
    private final UserPoolConfig userPoolConfig;
    private final OpenIDConnectConfig openIDConnectConfig;
    private final String arn;
    private final Map<String, String> uris;
    private final Map<String, String> tags;
    private final List<AdditionalAuthenticationProvider> additionalAuthenticationProviders;
    private final Boolean xrayEnabled;
    private final String wafWebAclArn;

    private GraphqlApi(BuilderImpl builder) {
        this.name = builder.name;
        this.apiId = builder.apiId;
        this.authenticationType = builder.authenticationType;
        this.logConfig = builder.logConfig;
        this.userPoolConfig = builder.userPoolConfig;
        this.openIDConnectConfig = builder.openIDConnectConfig;
        this.arn = builder.arn;
        this.uris = builder.uris;
        this.tags = builder.tags;
        this.additionalAuthenticationProviders = builder.additionalAuthenticationProviders;
        this.xrayEnabled = builder.xrayEnabled;
        this.wafWebAclArn = builder.wafWebAclArn;
    }

    public String name() {
        return this.name;
    }

    public String apiId() {
        return this.apiId;
    }

    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public UserPoolConfig userPoolConfig() {
        return this.userPoolConfig;
    }

    public OpenIDConnectConfig openIDConnectConfig() {
        return this.openIDConnectConfig;
    }

    public String arn() {
        return this.arn;
    }

    public boolean hasUris() {
        return this.uris != null && !(this.uris instanceof SdkAutoConstructMap);
    }

    public Map<String, String> uris() {
        return this.uris;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public boolean hasAdditionalAuthenticationProviders() {
        return this.additionalAuthenticationProviders != null && !(this.additionalAuthenticationProviders instanceof SdkAutoConstructList);
    }

    public List<AdditionalAuthenticationProvider> additionalAuthenticationProviders() {
        return this.additionalAuthenticationProviders;
    }

    public Boolean xrayEnabled() {
        return this.xrayEnabled;
    }

    public String wafWebAclArn() {
        return this.wafWebAclArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.openIDConnectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.uris());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalAuthenticationProviders());
        hashCode = 31 * hashCode + Objects.hashCode(this.xrayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.wafWebAclArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphqlApi)) {
            return false;
        }
        GraphqlApi other = (GraphqlApi)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.logConfig(), other.logConfig()) && Objects.equals(this.userPoolConfig(), other.userPoolConfig()) && Objects.equals(this.openIDConnectConfig(), other.openIDConnectConfig()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.uris(), other.uris()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.additionalAuthenticationProviders(), other.additionalAuthenticationProviders()) && Objects.equals(this.xrayEnabled(), other.xrayEnabled()) && Objects.equals(this.wafWebAclArn(), other.wafWebAclArn());
    }

    public String toString() {
        return ToString.builder((String)"GraphqlApi").add("Name", (Object)this.name()).add("ApiId", (Object)this.apiId()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("LogConfig", (Object)this.logConfig()).add("UserPoolConfig", (Object)this.userPoolConfig()).add("OpenIDConnectConfig", (Object)this.openIDConnectConfig()).add("Arn", (Object)this.arn()).add("Uris", this.uris()).add("Tags", this.tags()).add("AdditionalAuthenticationProviders", this.additionalAuthenticationProviders()).add("XrayEnabled", (Object)this.xrayEnabled()).add("WafWebAclArn", (Object)this.wafWebAclArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "authenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "logConfig": {
                return Optional.ofNullable(clazz.cast(this.logConfig()));
            }
            case "userPoolConfig": {
                return Optional.ofNullable(clazz.cast(this.userPoolConfig()));
            }
            case "openIDConnectConfig": {
                return Optional.ofNullable(clazz.cast(this.openIDConnectConfig()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "uris": {
                return Optional.ofNullable(clazz.cast(this.uris()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "additionalAuthenticationProviders": {
                return Optional.ofNullable(clazz.cast(this.additionalAuthenticationProviders()));
            }
            case "xrayEnabled": {
                return Optional.ofNullable(clazz.cast(this.xrayEnabled()));
            }
            case "wafWebAclArn": {
                return Optional.ofNullable(clazz.cast(this.wafWebAclArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GraphqlApi, T> g) {
        return obj -> g.apply((GraphqlApi)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String apiId;
        private String authenticationType;
        private LogConfig logConfig;
        private UserPoolConfig userPoolConfig;
        private OpenIDConnectConfig openIDConnectConfig;
        private String arn;
        private Map<String, String> uris = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<AdditionalAuthenticationProvider> additionalAuthenticationProviders = DefaultSdkAutoConstructList.getInstance();
        private Boolean xrayEnabled;
        private String wafWebAclArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GraphqlApi model) {
            this.name(model.name);
            this.apiId(model.apiId);
            this.authenticationType(model.authenticationType);
            this.logConfig(model.logConfig);
            this.userPoolConfig(model.userPoolConfig);
            this.openIDConnectConfig(model.openIDConnectConfig);
            this.arn(model.arn);
            this.uris(model.uris);
            this.tags(model.tags);
            this.additionalAuthenticationProviders(model.additionalAuthenticationProviders);
            this.xrayEnabled(model.xrayEnabled);
            this.wafWebAclArn(model.wafWebAclArn);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        public final LogConfig.Builder getLogConfig() {
            return this.logConfig != null ? this.logConfig.toBuilder() : null;
        }

        @Override
        public final Builder logConfig(LogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public final void setLogConfig(LogConfig.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        public final UserPoolConfig.Builder getUserPoolConfig() {
            return this.userPoolConfig != null ? this.userPoolConfig.toBuilder() : null;
        }

        @Override
        public final Builder userPoolConfig(UserPoolConfig userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        public final void setUserPoolConfig(UserPoolConfig.BuilderImpl userPoolConfig) {
            this.userPoolConfig = userPoolConfig != null ? userPoolConfig.build() : null;
        }

        public final OpenIDConnectConfig.Builder getOpenIDConnectConfig() {
            return this.openIDConnectConfig != null ? this.openIDConnectConfig.toBuilder() : null;
        }

        @Override
        public final Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig;
            return this;
        }

        public final void setOpenIDConnectConfig(OpenIDConnectConfig.BuilderImpl openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig != null ? openIDConnectConfig.build() : null;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Map<String, String> getUris() {
            return this.uris;
        }

        @Override
        public final Builder uris(Map<String, String> uris) {
            this.uris = MapOfStringToStringCopier.copy(uris);
            return this;
        }

        public final void setUris(Map<String, String> uris) {
            this.uris = MapOfStringToStringCopier.copy(uris);
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final Collection<AdditionalAuthenticationProvider.Builder> getAdditionalAuthenticationProviders() {
            return this.additionalAuthenticationProviders != null ? (Collection)this.additionalAuthenticationProviders.stream().map(AdditionalAuthenticationProvider::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalAuthenticationProviders(Collection<AdditionalAuthenticationProvider> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AdditionalAuthenticationProvidersCopier.copy(additionalAuthenticationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(AdditionalAuthenticationProvider ... additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders(Arrays.asList(additionalAuthenticationProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(Consumer<AdditionalAuthenticationProvider.Builder> ... additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders(Stream.of(additionalAuthenticationProviders).map(c -> (AdditionalAuthenticationProvider)((AdditionalAuthenticationProvider.Builder)AdditionalAuthenticationProvider.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalAuthenticationProviders(Collection<AdditionalAuthenticationProvider.BuilderImpl> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AdditionalAuthenticationProvidersCopier.copyFromBuilder(additionalAuthenticationProviders);
        }

        public final Boolean getXrayEnabled() {
            return this.xrayEnabled;
        }

        @Override
        public final Builder xrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        public final void setXrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
        }

        public final String getWafWebAclArn() {
            return this.wafWebAclArn;
        }

        @Override
        public final Builder wafWebAclArn(String wafWebAclArn) {
            this.wafWebAclArn = wafWebAclArn;
            return this;
        }

        public final void setWafWebAclArn(String wafWebAclArn) {
            this.wafWebAclArn = wafWebAclArn;
        }

        public GraphqlApi build() {
            return new GraphqlApi(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GraphqlApi> {
        public Builder name(String var1);

        public Builder apiId(String var1);

        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder logConfig(LogConfig var1);

        default public Builder logConfig(Consumer<LogConfig.Builder> logConfig) {
            return this.logConfig((LogConfig)((LogConfig.Builder)LogConfig.builder().applyMutation(logConfig)).build());
        }

        public Builder userPoolConfig(UserPoolConfig var1);

        default public Builder userPoolConfig(Consumer<UserPoolConfig.Builder> userPoolConfig) {
            return this.userPoolConfig((UserPoolConfig)((UserPoolConfig.Builder)UserPoolConfig.builder().applyMutation(userPoolConfig)).build());
        }

        public Builder openIDConnectConfig(OpenIDConnectConfig var1);

        default public Builder openIDConnectConfig(Consumer<OpenIDConnectConfig.Builder> openIDConnectConfig) {
            return this.openIDConnectConfig((OpenIDConnectConfig)((OpenIDConnectConfig.Builder)OpenIDConnectConfig.builder().applyMutation(openIDConnectConfig)).build());
        }

        public Builder arn(String var1);

        public Builder uris(Map<String, String> var1);

        public Builder tags(Map<String, String> var1);

        public Builder additionalAuthenticationProviders(Collection<AdditionalAuthenticationProvider> var1);

        public Builder additionalAuthenticationProviders(AdditionalAuthenticationProvider ... var1);

        public Builder additionalAuthenticationProviders(Consumer<AdditionalAuthenticationProvider.Builder> ... var1);

        public Builder xrayEnabled(Boolean var1);

        public Builder wafWebAclArn(String var1);
    }
}

