/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AuthorizationType;
import software.amazon.awssdk.services.appsync.model.AwsIamConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthorizationConfig> {
    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizationType").getter(AuthorizationConfig.getter(AuthorizationConfig::authorizationTypeAsString)).setter(AuthorizationConfig.setter(Builder::authorizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationType").build()}).build();
    private static final SdkField<AwsIamConfig> AWS_IAM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsIamConfig").getter(AuthorizationConfig.getter(AuthorizationConfig::awsIamConfig)).setter(AuthorizationConfig.setter(Builder::awsIamConfig)).constructor(AwsIamConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIamConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_TYPE_FIELD, AWS_IAM_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String authorizationType;
    private final AwsIamConfig awsIamConfig;

    private AuthorizationConfig(BuilderImpl builder) {
        this.authorizationType = builder.authorizationType;
        this.awsIamConfig = builder.awsIamConfig;
    }

    public AuthorizationType authorizationType() {
        return AuthorizationType.fromValue(this.authorizationType);
    }

    public String authorizationTypeAsString() {
        return this.authorizationType;
    }

    public AwsIamConfig awsIamConfig() {
        return this.awsIamConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIamConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizationConfig)) {
            return false;
        }
        AuthorizationConfig other = (AuthorizationConfig)obj;
        return Objects.equals(this.authorizationTypeAsString(), other.authorizationTypeAsString()) && Objects.equals(this.awsIamConfig(), other.awsIamConfig());
    }

    public String toString() {
        return ToString.builder((String)"AuthorizationConfig").add("AuthorizationType", (Object)this.authorizationTypeAsString()).add("AwsIamConfig", (Object)this.awsIamConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizationType": {
                return Optional.ofNullable(clazz.cast(this.authorizationTypeAsString()));
            }
            case "awsIamConfig": {
                return Optional.ofNullable(clazz.cast(this.awsIamConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizationConfig, T> g) {
        return obj -> g.apply((AuthorizationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authorizationType;
        private AwsIamConfig awsIamConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizationConfig model) {
            this.authorizationType(model.authorizationType);
            this.awsIamConfig(model.awsIamConfig);
        }

        public final String getAuthorizationType() {
            return this.authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        @Override
        public final Builder authorizationType(AuthorizationType authorizationType) {
            this.authorizationType(authorizationType == null ? null : authorizationType.toString());
            return this;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        public final AwsIamConfig.Builder getAwsIamConfig() {
            return this.awsIamConfig != null ? this.awsIamConfig.toBuilder() : null;
        }

        @Override
        public final Builder awsIamConfig(AwsIamConfig awsIamConfig) {
            this.awsIamConfig = awsIamConfig;
            return this;
        }

        public final void setAwsIamConfig(AwsIamConfig.BuilderImpl awsIamConfig) {
            this.awsIamConfig = awsIamConfig != null ? awsIamConfig.build() : null;
        }

        public AuthorizationConfig build() {
            return new AuthorizationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthorizationConfig> {
        public Builder authorizationType(String var1);

        public Builder authorizationType(AuthorizationType var1);

        public Builder awsIamConfig(AwsIamConfig var1);

        default public Builder awsIamConfig(Consumer<AwsIamConfig.Builder> awsIamConfig) {
            return this.awsIamConfig((AwsIamConfig)((AwsIamConfig.Builder)AwsIamConfig.builder().applyMutation(awsIamConfig)).build());
        }
    }
}

