/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CognitoUserPoolConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CognitoUserPoolConfig> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userPoolId").getter(CognitoUserPoolConfig.getter(CognitoUserPoolConfig::userPoolId)).setter(CognitoUserPoolConfig.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolId").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsRegion").getter(CognitoUserPoolConfig.getter(CognitoUserPoolConfig::awsRegion)).setter(CognitoUserPoolConfig.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()}).build();
    private static final SdkField<String> APP_ID_CLIENT_REGEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appIdClientRegex").getter(CognitoUserPoolConfig.getter(CognitoUserPoolConfig::appIdClientRegex)).setter(CognitoUserPoolConfig.setter(Builder::appIdClientRegex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appIdClientRegex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, AWS_REGION_FIELD, APP_ID_CLIENT_REGEX_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userPoolId;
    private final String awsRegion;
    private final String appIdClientRegex;

    private CognitoUserPoolConfig(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.awsRegion = builder.awsRegion;
        this.appIdClientRegex = builder.appIdClientRegex;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public String appIdClientRegex() {
        return this.appIdClientRegex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.appIdClientRegex());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoUserPoolConfig)) {
            return false;
        }
        CognitoUserPoolConfig other = (CognitoUserPoolConfig)obj;
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.appIdClientRegex(), other.appIdClientRegex());
    }

    public String toString() {
        return ToString.builder((String)"CognitoUserPoolConfig").add("UserPoolId", (Object)this.userPoolId()).add("AwsRegion", (Object)this.awsRegion()).add("AppIdClientRegex", (Object)this.appIdClientRegex()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "awsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "appIdClientRegex": {
                return Optional.ofNullable(clazz.cast(this.appIdClientRegex()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CognitoUserPoolConfig, T> g) {
        return obj -> g.apply((CognitoUserPoolConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userPoolId;
        private String awsRegion;
        private String appIdClientRegex;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoUserPoolConfig model) {
            this.userPoolId(model.userPoolId);
            this.awsRegion(model.awsRegion);
            this.appIdClientRegex(model.appIdClientRegex);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getAppIdClientRegex() {
            return this.appIdClientRegex;
        }

        @Override
        public final Builder appIdClientRegex(String appIdClientRegex) {
            this.appIdClientRegex = appIdClientRegex;
            return this;
        }

        public final void setAppIdClientRegex(String appIdClientRegex) {
            this.appIdClientRegex = appIdClientRegex;
        }

        public CognitoUserPoolConfig build() {
            return new CognitoUserPoolConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CognitoUserPoolConfig> {
        public Builder userPoolId(String var1);

        public Builder awsRegion(String var1);

        public Builder appIdClientRegex(String var1);
    }
}

