/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.ApiCacheStatus;
import software.amazon.awssdk.services.appsync.model.ApiCacheType;
import software.amazon.awssdk.services.appsync.model.ApiCachingBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiCache
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiCache> {
    private static final SdkField<Long> TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ApiCache.getter(ApiCache::ttl)).setter(ApiCache.setter(Builder::ttl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()}).build();
    private static final SdkField<String> API_CACHING_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApiCache.getter(ApiCache::apiCachingBehaviorAsString)).setter(ApiCache.setter(Builder::apiCachingBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiCachingBehavior").build()}).build();
    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ApiCache.getter(ApiCache::transitEncryptionEnabled)).setter(ApiCache.setter(Builder::transitEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitEncryptionEnabled").build()}).build();
    private static final SdkField<Boolean> AT_REST_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ApiCache.getter(ApiCache::atRestEncryptionEnabled)).setter(ApiCache.setter(Builder::atRestEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("atRestEncryptionEnabled").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApiCache.getter(ApiCache::typeAsString)).setter(ApiCache.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApiCache.getter(ApiCache::statusAsString)).setter(ApiCache.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TTL_FIELD, API_CACHING_BEHAVIOR_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD, AT_REST_ENCRYPTION_ENABLED_FIELD, TYPE_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long ttl;
    private final String apiCachingBehavior;
    private final Boolean transitEncryptionEnabled;
    private final Boolean atRestEncryptionEnabled;
    private final String type;
    private final String status;

    private ApiCache(BuilderImpl builder) {
        this.ttl = builder.ttl;
        this.apiCachingBehavior = builder.apiCachingBehavior;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
        this.type = builder.type;
        this.status = builder.status;
    }

    public Long ttl() {
        return this.ttl;
    }

    public ApiCachingBehavior apiCachingBehavior() {
        return ApiCachingBehavior.fromValue(this.apiCachingBehavior);
    }

    public String apiCachingBehaviorAsString() {
        return this.apiCachingBehavior;
    }

    public Boolean transitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    public Boolean atRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }

    public ApiCacheType type() {
        return ApiCacheType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public ApiCacheStatus status() {
        return ApiCacheStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiCachingBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.atRestEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiCache)) {
            return false;
        }
        ApiCache other = (ApiCache)obj;
        return Objects.equals(this.ttl(), other.ttl()) && Objects.equals(this.apiCachingBehaviorAsString(), other.apiCachingBehaviorAsString()) && Objects.equals(this.transitEncryptionEnabled(), other.transitEncryptionEnabled()) && Objects.equals(this.atRestEncryptionEnabled(), other.atRestEncryptionEnabled()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ApiCache").add("Ttl", (Object)this.ttl()).add("ApiCachingBehavior", (Object)this.apiCachingBehaviorAsString()).add("TransitEncryptionEnabled", (Object)this.transitEncryptionEnabled()).add("AtRestEncryptionEnabled", (Object)this.atRestEncryptionEnabled()).add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ttl": {
                return Optional.ofNullable(clazz.cast(this.ttl()));
            }
            case "apiCachingBehavior": {
                return Optional.ofNullable(clazz.cast(this.apiCachingBehaviorAsString()));
            }
            case "transitEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.transitEncryptionEnabled()));
            }
            case "atRestEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.atRestEncryptionEnabled()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApiCache, T> g) {
        return obj -> g.apply((ApiCache)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long ttl;
        private String apiCachingBehavior;
        private Boolean transitEncryptionEnabled;
        private Boolean atRestEncryptionEnabled;
        private String type;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiCache model) {
            this.ttl(model.ttl);
            this.apiCachingBehavior(model.apiCachingBehavior);
            this.transitEncryptionEnabled(model.transitEncryptionEnabled);
            this.atRestEncryptionEnabled(model.atRestEncryptionEnabled);
            this.type(model.type);
            this.status(model.status);
        }

        public final Long getTtl() {
            return this.ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        public final String getApiCachingBehavior() {
            return this.apiCachingBehavior;
        }

        @Override
        public final Builder apiCachingBehavior(String apiCachingBehavior) {
            this.apiCachingBehavior = apiCachingBehavior;
            return this;
        }

        @Override
        public final Builder apiCachingBehavior(ApiCachingBehavior apiCachingBehavior) {
            this.apiCachingBehavior(apiCachingBehavior == null ? null : apiCachingBehavior.toString());
            return this;
        }

        public final void setApiCachingBehavior(String apiCachingBehavior) {
            this.apiCachingBehavior = apiCachingBehavior;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return this.transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return this.atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ApiCacheType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApiCacheStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ApiCache build() {
            return new ApiCache(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiCache> {
        public Builder ttl(Long var1);

        public Builder apiCachingBehavior(String var1);

        public Builder apiCachingBehavior(ApiCachingBehavior var1);

        public Builder transitEncryptionEnabled(Boolean var1);

        public Builder atRestEncryptionEnabled(Boolean var1);

        public Builder type(String var1);

        public Builder type(ApiCacheType var1);

        public Builder status(String var1);

        public Builder status(ApiCacheStatus var1);
    }
}

