/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ApiCacheStatus {
    AVAILABLE("AVAILABLE"),
    CREATING("CREATING"),
    DELETING("DELETING"),
    MODIFYING("MODIFYING"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ApiCacheStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApiCacheStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ApiCacheStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApiCacheStatus> knownValues() {
        return Stream.of(ApiCacheStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

