/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.CachingKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CachingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CachingConfig> {
    private static final SdkField<Long> TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(CachingConfig.getter(CachingConfig::ttl)).setter(CachingConfig.setter(Builder::ttl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()}).build();
    private static final SdkField<List<String>> CACHING_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CachingConfig.getter(CachingConfig::cachingKeys)).setter(CachingConfig.setter(Builder::cachingKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cachingKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TTL_FIELD, CACHING_KEYS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long ttl;
    private final List<String> cachingKeys;

    private CachingConfig(BuilderImpl builder) {
        this.ttl = builder.ttl;
        this.cachingKeys = builder.cachingKeys;
    }

    public Long ttl() {
        return this.ttl;
    }

    public boolean hasCachingKeys() {
        return this.cachingKeys != null && !(this.cachingKeys instanceof SdkAutoConstructList);
    }

    public List<String> cachingKeys() {
        return this.cachingKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        hashCode = 31 * hashCode + Objects.hashCode(this.cachingKeys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachingConfig)) {
            return false;
        }
        CachingConfig other = (CachingConfig)obj;
        return Objects.equals(this.ttl(), other.ttl()) && Objects.equals(this.cachingKeys(), other.cachingKeys());
    }

    public String toString() {
        return ToString.builder((String)"CachingConfig").add("Ttl", (Object)this.ttl()).add("CachingKeys", this.cachingKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ttl": {
                return Optional.ofNullable(clazz.cast(this.ttl()));
            }
            case "cachingKeys": {
                return Optional.ofNullable(clazz.cast(this.cachingKeys()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CachingConfig, T> g) {
        return obj -> g.apply((CachingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long ttl;
        private List<String> cachingKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CachingConfig model) {
            this.ttl(model.ttl);
            this.cachingKeys(model.cachingKeys);
        }

        public final Long getTtl() {
            return this.ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        public final Collection<String> getCachingKeys() {
            return this.cachingKeys;
        }

        @Override
        public final Builder cachingKeys(Collection<String> cachingKeys) {
            this.cachingKeys = CachingKeysCopier.copy(cachingKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cachingKeys(String ... cachingKeys) {
            this.cachingKeys(Arrays.asList(cachingKeys));
            return this;
        }

        public final void setCachingKeys(Collection<String> cachingKeys) {
            this.cachingKeys = CachingKeysCopier.copy(cachingKeys);
        }

        public CachingConfig build() {
            return new CachingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CachingConfig> {
        public Builder ttl(Long var1);

        public Builder cachingKeys(Collection<String> var1);

        public Builder cachingKeys(String ... var1);
    }
}

