/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.services.appsync.model.DataSourceType;
import software.amazon.awssdk.services.appsync.model.DynamodbDataSourceConfig;
import software.amazon.awssdk.services.appsync.model.ElasticsearchDataSourceConfig;
import software.amazon.awssdk.services.appsync.model.HttpDataSourceConfig;
import software.amazon.awssdk.services.appsync.model.LambdaDataSourceConfig;
import software.amazon.awssdk.services.appsync.model.RelationalDatabaseDataSourceConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataSourceRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, CreateDataSourceRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::apiId)).setter(CreateDataSourceRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::name)).setter(CreateDataSourceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::description)).setter(CreateDataSourceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::typeAsString)).setter(CreateDataSourceRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::serviceRoleArn)).setter(CreateDataSourceRequest.setter(Builder::serviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRoleArn").build()}).build();
    private static final SdkField<DynamodbDataSourceConfig> DYNAMODB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::dynamodbConfig)).setter(CreateDataSourceRequest.setter(Builder::dynamodbConfig)).constructor(DynamodbDataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamodbConfig").build()}).build();
    private static final SdkField<LambdaDataSourceConfig> LAMBDA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::lambdaConfig)).setter(CreateDataSourceRequest.setter(Builder::lambdaConfig)).constructor(LambdaDataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaConfig").build()}).build();
    private static final SdkField<ElasticsearchDataSourceConfig> ELASTICSEARCH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::elasticsearchConfig)).setter(CreateDataSourceRequest.setter(Builder::elasticsearchConfig)).constructor(ElasticsearchDataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elasticsearchConfig").build()}).build();
    private static final SdkField<HttpDataSourceConfig> HTTP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::httpConfig)).setter(CreateDataSourceRequest.setter(Builder::httpConfig)).constructor(HttpDataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpConfig").build()}).build();
    private static final SdkField<RelationalDatabaseDataSourceConfig> RELATIONAL_DATABASE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::relationalDatabaseConfig)).setter(CreateDataSourceRequest.setter(Builder::relationalDatabaseConfig)).constructor(RelationalDatabaseDataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, SERVICE_ROLE_ARN_FIELD, DYNAMODB_CONFIG_FIELD, LAMBDA_CONFIG_FIELD, ELASTICSEARCH_CONFIG_FIELD, HTTP_CONFIG_FIELD, RELATIONAL_DATABASE_CONFIG_FIELD));
    private final String apiId;
    private final String name;
    private final String description;
    private final String type;
    private final String serviceRoleArn;
    private final DynamodbDataSourceConfig dynamodbConfig;
    private final LambdaDataSourceConfig lambdaConfig;
    private final ElasticsearchDataSourceConfig elasticsearchConfig;
    private final HttpDataSourceConfig httpConfig;
    private final RelationalDatabaseDataSourceConfig relationalDatabaseConfig;

    private CreateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.dynamodbConfig = builder.dynamodbConfig;
        this.lambdaConfig = builder.lambdaConfig;
        this.elasticsearchConfig = builder.elasticsearchConfig;
        this.httpConfig = builder.httpConfig;
        this.relationalDatabaseConfig = builder.relationalDatabaseConfig;
    }

    public String apiId() {
        return this.apiId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public DataSourceType type() {
        return DataSourceType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public DynamodbDataSourceConfig dynamodbConfig() {
        return this.dynamodbConfig;
    }

    public LambdaDataSourceConfig lambdaConfig() {
        return this.lambdaConfig;
    }

    public ElasticsearchDataSourceConfig elasticsearchConfig() {
        return this.elasticsearchConfig;
    }

    public HttpDataSourceConfig httpConfig() {
        return this.httpConfig;
    }

    public RelationalDatabaseDataSourceConfig relationalDatabaseConfig() {
        return this.relationalDatabaseConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamodbConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceRequest)) {
            return false;
        }
        CreateDataSourceRequest other = (CreateDataSourceRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.dynamodbConfig(), other.dynamodbConfig()) && Objects.equals(this.lambdaConfig(), other.lambdaConfig()) && Objects.equals(this.elasticsearchConfig(), other.elasticsearchConfig()) && Objects.equals(this.httpConfig(), other.httpConfig()) && Objects.equals(this.relationalDatabaseConfig(), other.relationalDatabaseConfig());
    }

    public String toString() {
        return ToString.builder((String)"CreateDataSourceRequest").add("ApiId", (Object)this.apiId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Type", (Object)this.typeAsString()).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("DynamodbConfig", (Object)this.dynamodbConfig()).add("LambdaConfig", (Object)this.lambdaConfig()).add("ElasticsearchConfig", (Object)this.elasticsearchConfig()).add("HttpConfig", (Object)this.httpConfig()).add("RelationalDatabaseConfig", (Object)this.relationalDatabaseConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "serviceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleArn()));
            }
            case "dynamodbConfig": {
                return Optional.ofNullable(clazz.cast(this.dynamodbConfig()));
            }
            case "lambdaConfig": {
                return Optional.ofNullable(clazz.cast(this.lambdaConfig()));
            }
            case "elasticsearchConfig": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchConfig()));
            }
            case "httpConfig": {
                return Optional.ofNullable(clazz.cast(this.httpConfig()));
            }
            case "relationalDatabaseConfig": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceRequest, T> g) {
        return obj -> g.apply((CreateDataSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private String name;
        private String description;
        private String type;
        private String serviceRoleArn;
        private DynamodbDataSourceConfig dynamodbConfig;
        private LambdaDataSourceConfig lambdaConfig;
        private ElasticsearchDataSourceConfig elasticsearchConfig;
        private HttpDataSourceConfig httpConfig;
        private RelationalDatabaseDataSourceConfig relationalDatabaseConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.name(model.name);
            this.description(model.description);
            this.type(model.type);
            this.serviceRoleArn(model.serviceRoleArn);
            this.dynamodbConfig(model.dynamodbConfig);
            this.lambdaConfig(model.lambdaConfig);
            this.elasticsearchConfig(model.elasticsearchConfig);
            this.httpConfig(model.httpConfig);
            this.relationalDatabaseConfig(model.relationalDatabaseConfig);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final DynamodbDataSourceConfig.Builder getDynamodbConfig() {
            return this.dynamodbConfig != null ? this.dynamodbConfig.toBuilder() : null;
        }

        @Override
        public final Builder dynamodbConfig(DynamodbDataSourceConfig dynamodbConfig) {
            this.dynamodbConfig = dynamodbConfig;
            return this;
        }

        public final void setDynamodbConfig(DynamodbDataSourceConfig.BuilderImpl dynamodbConfig) {
            this.dynamodbConfig = dynamodbConfig != null ? dynamodbConfig.build() : null;
        }

        public final LambdaDataSourceConfig.Builder getLambdaConfig() {
            return this.lambdaConfig != null ? this.lambdaConfig.toBuilder() : null;
        }

        @Override
        public final Builder lambdaConfig(LambdaDataSourceConfig lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        public final void setLambdaConfig(LambdaDataSourceConfig.BuilderImpl lambdaConfig) {
            this.lambdaConfig = lambdaConfig != null ? lambdaConfig.build() : null;
        }

        public final ElasticsearchDataSourceConfig.Builder getElasticsearchConfig() {
            return this.elasticsearchConfig != null ? this.elasticsearchConfig.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchConfig(ElasticsearchDataSourceConfig elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig;
            return this;
        }

        public final void setElasticsearchConfig(ElasticsearchDataSourceConfig.BuilderImpl elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig != null ? elasticsearchConfig.build() : null;
        }

        public final HttpDataSourceConfig.Builder getHttpConfig() {
            return this.httpConfig != null ? this.httpConfig.toBuilder() : null;
        }

        @Override
        public final Builder httpConfig(HttpDataSourceConfig httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        public final void setHttpConfig(HttpDataSourceConfig.BuilderImpl httpConfig) {
            this.httpConfig = httpConfig != null ? httpConfig.build() : null;
        }

        public final RelationalDatabaseDataSourceConfig.Builder getRelationalDatabaseConfig() {
            return this.relationalDatabaseConfig != null ? this.relationalDatabaseConfig.toBuilder() : null;
        }

        @Override
        public final Builder relationalDatabaseConfig(RelationalDatabaseDataSourceConfig relationalDatabaseConfig) {
            this.relationalDatabaseConfig = relationalDatabaseConfig;
            return this;
        }

        public final void setRelationalDatabaseConfig(RelationalDatabaseDataSourceConfig.BuilderImpl relationalDatabaseConfig) {
            this.relationalDatabaseConfig = relationalDatabaseConfig != null ? relationalDatabaseConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceRequest build() {
            return new CreateDataSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataSourceRequest> {
        public Builder apiId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(DataSourceType var1);

        public Builder serviceRoleArn(String var1);

        public Builder dynamodbConfig(DynamodbDataSourceConfig var1);

        default public Builder dynamodbConfig(Consumer<DynamodbDataSourceConfig.Builder> dynamodbConfig) {
            return this.dynamodbConfig((DynamodbDataSourceConfig)((DynamodbDataSourceConfig.Builder)DynamodbDataSourceConfig.builder().applyMutation(dynamodbConfig)).build());
        }

        public Builder lambdaConfig(LambdaDataSourceConfig var1);

        default public Builder lambdaConfig(Consumer<LambdaDataSourceConfig.Builder> lambdaConfig) {
            return this.lambdaConfig((LambdaDataSourceConfig)((LambdaDataSourceConfig.Builder)LambdaDataSourceConfig.builder().applyMutation(lambdaConfig)).build());
        }

        public Builder elasticsearchConfig(ElasticsearchDataSourceConfig var1);

        default public Builder elasticsearchConfig(Consumer<ElasticsearchDataSourceConfig.Builder> elasticsearchConfig) {
            return this.elasticsearchConfig((ElasticsearchDataSourceConfig)((ElasticsearchDataSourceConfig.Builder)ElasticsearchDataSourceConfig.builder().applyMutation(elasticsearchConfig)).build());
        }

        public Builder httpConfig(HttpDataSourceConfig var1);

        default public Builder httpConfig(Consumer<HttpDataSourceConfig.Builder> httpConfig) {
            return this.httpConfig((HttpDataSourceConfig)((HttpDataSourceConfig.Builder)HttpDataSourceConfig.builder().applyMutation(httpConfig)).build());
        }

        public Builder relationalDatabaseConfig(RelationalDatabaseDataSourceConfig var1);

        default public Builder relationalDatabaseConfig(Consumer<RelationalDatabaseDataSourceConfig.Builder> relationalDatabaseConfig) {
            return this.relationalDatabaseConfig((RelationalDatabaseDataSourceConfig)((RelationalDatabaseDataSourceConfig.Builder)RelationalDatabaseDataSourceConfig.builder().applyMutation(relationalDatabaseConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

