/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a GraphQL API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GraphqlApi implements SdkPojo, Serializable, ToCopyableBuilder<GraphqlApi.Builder, GraphqlApi> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GraphqlApi::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GraphqlApi::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiId").build()).build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GraphqlApi::authenticationTypeAsString)).setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build())
            .build();

    private static final SdkField<LogConfig> LOG_CONFIG_FIELD = SdkField.<LogConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(GraphqlApi::logConfig)).setter(setter(Builder::logConfig)).constructor(LogConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfig").build()).build();

    private static final SdkField<UserPoolConfig> USER_POOL_CONFIG_FIELD = SdkField
            .<UserPoolConfig> builder(MarshallingType.SDK_POJO).getter(getter(GraphqlApi::userPoolConfig))
            .setter(setter(Builder::userPoolConfig)).constructor(UserPoolConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolConfig").build()).build();

    private static final SdkField<OpenIDConnectConfig> OPEN_ID_CONNECT_CONFIG_FIELD = SdkField
            .<OpenIDConnectConfig> builder(MarshallingType.SDK_POJO).getter(getter(GraphqlApi::openIDConnectConfig))
            .setter(setter(Builder::openIDConnectConfig)).constructor(OpenIDConnectConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDConnectConfig").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GraphqlApi::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Map<String, String>> URIS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GraphqlApi::uris))
            .setter(setter(Builder::uris))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uris").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GraphqlApi::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<AdditionalAuthenticationProvider>> ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD = SdkField
            .<List<AdditionalAuthenticationProvider>> builder(MarshallingType.LIST)
            .getter(getter(GraphqlApi::additionalAuthenticationProviders))
            .setter(setter(Builder::additionalAuthenticationProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAuthenticationProviders")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdditionalAuthenticationProvider> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdditionalAuthenticationProvider::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> XRAY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GraphqlApi::xrayEnabled)).setter(setter(Builder::xrayEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xrayEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, API_ID_FIELD,
            AUTHENTICATION_TYPE_FIELD, LOG_CONFIG_FIELD, USER_POOL_CONFIG_FIELD, OPEN_ID_CONNECT_CONFIG_FIELD, ARN_FIELD,
            URIS_FIELD, TAGS_FIELD, ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD, XRAY_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String apiId;

    private final String authenticationType;

    private final LogConfig logConfig;

    private final UserPoolConfig userPoolConfig;

    private final OpenIDConnectConfig openIDConnectConfig;

    private final String arn;

    private final Map<String, String> uris;

    private final Map<String, String> tags;

    private final List<AdditionalAuthenticationProvider> additionalAuthenticationProviders;

    private final Boolean xrayEnabled;

    private GraphqlApi(BuilderImpl builder) {
        this.name = builder.name;
        this.apiId = builder.apiId;
        this.authenticationType = builder.authenticationType;
        this.logConfig = builder.logConfig;
        this.userPoolConfig = builder.userPoolConfig;
        this.openIDConnectConfig = builder.openIDConnectConfig;
        this.arn = builder.arn;
        this.uris = builder.uris;
        this.tags = builder.tags;
        this.additionalAuthenticationProviders = builder.additionalAuthenticationProviders;
        this.xrayEnabled = builder.xrayEnabled;
    }

    /**
     * <p>
     * The API name.
     * </p>
     * 
     * @return The API name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The API ID.
     * </p>
     * 
     * @return The API ID.
     */
    public String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The authentication type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type.
     * @see AuthenticationType
     */
    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type.
     * @see AuthenticationType
     */
    public String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The Amazon CloudWatch Logs configuration.
     * </p>
     * 
     * @return The Amazon CloudWatch Logs configuration.
     */
    public LogConfig logConfig() {
        return logConfig;
    }

    /**
     * <p>
     * The Amazon Cognito user pool configuration.
     * </p>
     * 
     * @return The Amazon Cognito user pool configuration.
     */
    public UserPoolConfig userPoolConfig() {
        return userPoolConfig;
    }

    /**
     * <p>
     * The OpenID Connect configuration.
     * </p>
     * 
     * @return The OpenID Connect configuration.
     */
    public OpenIDConnectConfig openIDConnectConfig() {
        return openIDConnectConfig;
    }

    /**
     * <p>
     * The ARN.
     * </p>
     * 
     * @return The ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * Returns true if the Uris property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUris() {
        return uris != null && !(uris instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The URIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUris()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The URIs.
     */
    public Map<String, String> uris() {
        return uris;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * Returns true if the AdditionalAuthenticationProviders property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasAdditionalAuthenticationProviders() {
        return additionalAuthenticationProviders != null && !(additionalAuthenticationProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of additional authentication providers for the <code>GraphqlApi</code> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalAuthenticationProviders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of additional authentication providers for the <code>GraphqlApi</code> API.
     */
    public List<AdditionalAuthenticationProvider> additionalAuthenticationProviders() {
        return additionalAuthenticationProviders;
    }

    /**
     * <p>
     * A flag representing whether X-Ray tracing is enabled for this <code>GraphqlApi</code>.
     * </p>
     * 
     * @return A flag representing whether X-Ray tracing is enabled for this <code>GraphqlApi</code>.
     */
    public Boolean xrayEnabled() {
        return xrayEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logConfig());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(openIDConnectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(uris());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(additionalAuthenticationProviders());
        hashCode = 31 * hashCode + Objects.hashCode(xrayEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphqlApi)) {
            return false;
        }
        GraphqlApi other = (GraphqlApi) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(apiId(), other.apiId())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(logConfig(), other.logConfig()) && Objects.equals(userPoolConfig(), other.userPoolConfig())
                && Objects.equals(openIDConnectConfig(), other.openIDConnectConfig()) && Objects.equals(arn(), other.arn())
                && Objects.equals(uris(), other.uris()) && Objects.equals(tags(), other.tags())
                && Objects.equals(additionalAuthenticationProviders(), other.additionalAuthenticationProviders())
                && Objects.equals(xrayEnabled(), other.xrayEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GraphqlApi").add("Name", name()).add("ApiId", apiId())
                .add("AuthenticationType", authenticationTypeAsString()).add("LogConfig", logConfig())
                .add("UserPoolConfig", userPoolConfig()).add("OpenIDConnectConfig", openIDConnectConfig()).add("Arn", arn())
                .add("Uris", uris()).add("Tags", tags())
                .add("AdditionalAuthenticationProviders", additionalAuthenticationProviders()).add("XrayEnabled", xrayEnabled())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "authenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "logConfig":
            return Optional.ofNullable(clazz.cast(logConfig()));
        case "userPoolConfig":
            return Optional.ofNullable(clazz.cast(userPoolConfig()));
        case "openIDConnectConfig":
            return Optional.ofNullable(clazz.cast(openIDConnectConfig()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "uris":
            return Optional.ofNullable(clazz.cast(uris()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "additionalAuthenticationProviders":
            return Optional.ofNullable(clazz.cast(additionalAuthenticationProviders()));
        case "xrayEnabled":
            return Optional.ofNullable(clazz.cast(xrayEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GraphqlApi, T> g) {
        return obj -> g.apply((GraphqlApi) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GraphqlApi> {
        /**
         * <p>
         * The API name.
         * </p>
         * 
         * @param name
         *        The API name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The API ID.
         * </p>
         * 
         * @param apiId
         *        The API ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The authentication type.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication type.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * The Amazon CloudWatch Logs configuration.
         * </p>
         * 
         * @param logConfig
         *        The Amazon CloudWatch Logs configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfig(LogConfig logConfig);

        /**
         * <p>
         * The Amazon CloudWatch Logs configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link LogConfig.Builder} avoiding the need to create
         * one manually via {@link LogConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LogConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #logConfig(LogConfig)}.
         * 
         * @param logConfig
         *        a consumer that will call methods on {@link LogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfig(LogConfig)
         */
        default Builder logConfig(Consumer<LogConfig.Builder> logConfig) {
            return logConfig(LogConfig.builder().applyMutation(logConfig).build());
        }

        /**
         * <p>
         * The Amazon Cognito user pool configuration.
         * </p>
         * 
         * @param userPoolConfig
         *        The Amazon Cognito user pool configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolConfig(UserPoolConfig userPoolConfig);

        /**
         * <p>
         * The Amazon Cognito user pool configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link UserPoolConfig.Builder} avoiding the need to
         * create one manually via {@link UserPoolConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPoolConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #userPoolConfig(UserPoolConfig)}.
         * 
         * @param userPoolConfig
         *        a consumer that will call methods on {@link UserPoolConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPoolConfig(UserPoolConfig)
         */
        default Builder userPoolConfig(Consumer<UserPoolConfig.Builder> userPoolConfig) {
            return userPoolConfig(UserPoolConfig.builder().applyMutation(userPoolConfig).build());
        }

        /**
         * <p>
         * The OpenID Connect configuration.
         * </p>
         * 
         * @param openIDConnectConfig
         *        The OpenID Connect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig);

        /**
         * <p>
         * The OpenID Connect configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link OpenIDConnectConfig.Builder} avoiding the need
         * to create one manually via {@link OpenIDConnectConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OpenIDConnectConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #openIDConnectConfig(OpenIDConnectConfig)}.
         * 
         * @param openIDConnectConfig
         *        a consumer that will call methods on {@link OpenIDConnectConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openIDConnectConfig(OpenIDConnectConfig)
         */
        default Builder openIDConnectConfig(Consumer<OpenIDConnectConfig.Builder> openIDConnectConfig) {
            return openIDConnectConfig(OpenIDConnectConfig.builder().applyMutation(openIDConnectConfig).build());
        }

        /**
         * <p>
         * The ARN.
         * </p>
         * 
         * @param arn
         *        The ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The URIs.
         * </p>
         * 
         * @param uris
         *        The URIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uris(Map<String, String> uris);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * </p>
         * 
         * @param additionalAuthenticationProviders
         *        A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAuthenticationProviders(Collection<AdditionalAuthenticationProvider> additionalAuthenticationProviders);

        /**
         * <p>
         * A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * </p>
         * 
         * @param additionalAuthenticationProviders
         *        A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAuthenticationProviders(AdditionalAuthenticationProvider... additionalAuthenticationProviders);

        /**
         * <p>
         * A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AdditionalAuthenticationProvider>.Builder}
         * avoiding the need to create one manually via {@link List<AdditionalAuthenticationProvider>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AdditionalAuthenticationProvider>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #additionalAuthenticationProviders(List<AdditionalAuthenticationProvider>)}.
         * 
         * @param additionalAuthenticationProviders
         *        a consumer that will call methods on {@link List<AdditionalAuthenticationProvider>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalAuthenticationProviders(List<AdditionalAuthenticationProvider>)
         */
        Builder additionalAuthenticationProviders(
                Consumer<AdditionalAuthenticationProvider.Builder>... additionalAuthenticationProviders);

        /**
         * <p>
         * A flag representing whether X-Ray tracing is enabled for this <code>GraphqlApi</code>.
         * </p>
         * 
         * @param xrayEnabled
         *        A flag representing whether X-Ray tracing is enabled for this <code>GraphqlApi</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xrayEnabled(Boolean xrayEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String apiId;

        private String authenticationType;

        private LogConfig logConfig;

        private UserPoolConfig userPoolConfig;

        private OpenIDConnectConfig openIDConnectConfig;

        private String arn;

        private Map<String, String> uris = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<AdditionalAuthenticationProvider> additionalAuthenticationProviders = DefaultSdkAutoConstructList
                .getInstance();

        private Boolean xrayEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GraphqlApi model) {
            name(model.name);
            apiId(model.apiId);
            authenticationType(model.authenticationType);
            logConfig(model.logConfig);
            userPoolConfig(model.userPoolConfig);
            openIDConnectConfig(model.openIDConnectConfig);
            arn(model.arn);
            uris(model.uris);
            tags(model.tags);
            additionalAuthenticationProviders(model.additionalAuthenticationProviders);
            xrayEnabled(model.xrayEnabled);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getApiId() {
            return apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        public final LogConfig.Builder getLogConfig() {
            return logConfig != null ? logConfig.toBuilder() : null;
        }

        @Override
        public final Builder logConfig(LogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public final void setLogConfig(LogConfig.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        public final UserPoolConfig.Builder getUserPoolConfig() {
            return userPoolConfig != null ? userPoolConfig.toBuilder() : null;
        }

        @Override
        public final Builder userPoolConfig(UserPoolConfig userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        public final void setUserPoolConfig(UserPoolConfig.BuilderImpl userPoolConfig) {
            this.userPoolConfig = userPoolConfig != null ? userPoolConfig.build() : null;
        }

        public final OpenIDConnectConfig.Builder getOpenIDConnectConfig() {
            return openIDConnectConfig != null ? openIDConnectConfig.toBuilder() : null;
        }

        @Override
        public final Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig;
            return this;
        }

        public final void setOpenIDConnectConfig(OpenIDConnectConfig.BuilderImpl openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig != null ? openIDConnectConfig.build() : null;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Map<String, String> getUris() {
            return uris;
        }

        @Override
        public final Builder uris(Map<String, String> uris) {
            this.uris = MapOfStringToStringCopier.copy(uris);
            return this;
        }

        public final void setUris(Map<String, String> uris) {
            this.uris = MapOfStringToStringCopier.copy(uris);
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final Collection<AdditionalAuthenticationProvider.Builder> getAdditionalAuthenticationProviders() {
            return additionalAuthenticationProviders != null ? additionalAuthenticationProviders.stream()
                    .map(AdditionalAuthenticationProvider::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalAuthenticationProviders(
                Collection<AdditionalAuthenticationProvider> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AdditionalAuthenticationProvidersCopier
                    .copy(additionalAuthenticationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(
                AdditionalAuthenticationProvider... additionalAuthenticationProviders) {
            additionalAuthenticationProviders(Arrays.asList(additionalAuthenticationProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(
                Consumer<AdditionalAuthenticationProvider.Builder>... additionalAuthenticationProviders) {
            additionalAuthenticationProviders(Stream.of(additionalAuthenticationProviders)
                    .map(c -> AdditionalAuthenticationProvider.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalAuthenticationProviders(
                Collection<AdditionalAuthenticationProvider.BuilderImpl> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AdditionalAuthenticationProvidersCopier
                    .copyFromBuilder(additionalAuthenticationProviders);
        }

        public final Boolean getXrayEnabled() {
            return xrayEnabled;
        }

        @Override
        public final Builder xrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        public final void setXrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
        }

        @Override
        public GraphqlApi build() {
            return new GraphqlApi(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
