/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionConfiguration> {
    private static final SdkField<String> FUNCTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FunctionConfiguration.getter(FunctionConfiguration::functionId)).setter(FunctionConfiguration.setter(Builder::functionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionId").build()}).build();
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FunctionConfiguration.getter(FunctionConfiguration::functionArn)).setter(FunctionConfiguration.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FunctionConfiguration.getter(FunctionConfiguration::name)).setter(FunctionConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FunctionConfiguration.getter(FunctionConfiguration::description)).setter(FunctionConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FunctionConfiguration.getter(FunctionConfiguration::dataSourceName)).setter(FunctionConfiguration.setter(Builder::dataSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceName").build()}).build();
    private static final SdkField<String> REQUEST_MAPPING_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FunctionConfiguration.getter(FunctionConfiguration::requestMappingTemplate)).setter(FunctionConfiguration.setter(Builder::requestMappingTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMappingTemplate").build()}).build();
    private static final SdkField<String> RESPONSE_MAPPING_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FunctionConfiguration.getter(FunctionConfiguration::responseMappingTemplate)).setter(FunctionConfiguration.setter(Builder::responseMappingTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseMappingTemplate").build()}).build();
    private static final SdkField<String> FUNCTION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FunctionConfiguration.getter(FunctionConfiguration::functionVersion)).setter(FunctionConfiguration.setter(Builder::functionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ID_FIELD, FUNCTION_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DATA_SOURCE_NAME_FIELD, REQUEST_MAPPING_TEMPLATE_FIELD, RESPONSE_MAPPING_TEMPLATE_FIELD, FUNCTION_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String functionId;
    private final String functionArn;
    private final String name;
    private final String description;
    private final String dataSourceName;
    private final String requestMappingTemplate;
    private final String responseMappingTemplate;
    private final String functionVersion;

    private FunctionConfiguration(BuilderImpl builder) {
        this.functionId = builder.functionId;
        this.functionArn = builder.functionArn;
        this.name = builder.name;
        this.description = builder.description;
        this.dataSourceName = builder.dataSourceName;
        this.requestMappingTemplate = builder.requestMappingTemplate;
        this.responseMappingTemplate = builder.responseMappingTemplate;
        this.functionVersion = builder.functionVersion;
    }

    public String functionId() {
        return this.functionId;
    }

    public String functionArn() {
        return this.functionArn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String dataSourceName() {
        return this.dataSourceName;
    }

    public String requestMappingTemplate() {
        return this.requestMappingTemplate;
    }

    public String responseMappingTemplate() {
        return this.responseMappingTemplate;
    }

    public String functionVersion() {
        return this.functionVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionConfiguration)) {
            return false;
        }
        FunctionConfiguration other = (FunctionConfiguration)obj;
        return Objects.equals(this.functionId(), other.functionId()) && Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dataSourceName(), other.dataSourceName()) && Objects.equals(this.requestMappingTemplate(), other.requestMappingTemplate()) && Objects.equals(this.responseMappingTemplate(), other.responseMappingTemplate()) && Objects.equals(this.functionVersion(), other.functionVersion());
    }

    public String toString() {
        return ToString.builder((String)"FunctionConfiguration").add("FunctionId", (Object)this.functionId()).add("FunctionArn", (Object)this.functionArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DataSourceName", (Object)this.dataSourceName()).add("RequestMappingTemplate", (Object)this.requestMappingTemplate()).add("ResponseMappingTemplate", (Object)this.responseMappingTemplate()).add("FunctionVersion", (Object)this.functionVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "functionId": {
                return Optional.ofNullable(clazz.cast(this.functionId()));
            }
            case "functionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "dataSourceName": {
                return Optional.ofNullable(clazz.cast(this.dataSourceName()));
            }
            case "requestMappingTemplate": {
                return Optional.ofNullable(clazz.cast(this.requestMappingTemplate()));
            }
            case "responseMappingTemplate": {
                return Optional.ofNullable(clazz.cast(this.responseMappingTemplate()));
            }
            case "functionVersion": {
                return Optional.ofNullable(clazz.cast(this.functionVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionConfiguration, T> g) {
        return obj -> g.apply((FunctionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionId;
        private String functionArn;
        private String name;
        private String description;
        private String dataSourceName;
        private String requestMappingTemplate;
        private String responseMappingTemplate;
        private String functionVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionConfiguration model) {
            this.functionId(model.functionId);
            this.functionArn(model.functionArn);
            this.name(model.name);
            this.description(model.description);
            this.dataSourceName(model.dataSourceName);
            this.requestMappingTemplate(model.requestMappingTemplate);
            this.responseMappingTemplate(model.responseMappingTemplate);
            this.functionVersion(model.functionVersion);
        }

        public final String getFunctionId() {
            return this.functionId;
        }

        @Override
        public final Builder functionId(String functionId) {
            this.functionId = functionId;
            return this;
        }

        public final void setFunctionId(String functionId) {
            this.functionId = functionId;
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final String getRequestMappingTemplate() {
            return this.requestMappingTemplate;
        }

        @Override
        public final Builder requestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        public final void setRequestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
        }

        public final String getResponseMappingTemplate() {
            return this.responseMappingTemplate;
        }

        @Override
        public final Builder responseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        public final void setResponseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
        }

        public final String getFunctionVersion() {
            return this.functionVersion;
        }

        @Override
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        public FunctionConfiguration build() {
            return new FunctionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionConfiguration> {
        public Builder functionId(String var1);

        public Builder functionArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder dataSourceName(String var1);

        public Builder requestMappingTemplate(String var1);

        public Builder responseMappingTemplate(String var1);

        public Builder functionVersion(String var1);
    }
}

