/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Sync configuration for a resolver.
 * </p>
 * <p>
 * Contains information on which Conflict Detection as well as Resolution strategy should be performed when the resolver
 * is invoked.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SyncConfig implements SdkPojo, Serializable, ToCopyableBuilder<SyncConfig.Builder, SyncConfig> {
    private static final SdkField<String> CONFLICT_HANDLER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SyncConfig::conflictHandlerAsString)).setter(setter(Builder::conflictHandler))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictHandler").build()).build();

    private static final SdkField<String> CONFLICT_DETECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SyncConfig::conflictDetectionAsString)).setter(setter(Builder::conflictDetection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictDetection").build()).build();

    private static final SdkField<LambdaConflictHandlerConfig> LAMBDA_CONFLICT_HANDLER_CONFIG_FIELD = SdkField
            .<LambdaConflictHandlerConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(SyncConfig::lambdaConflictHandlerConfig))
            .setter(setter(Builder::lambdaConflictHandlerConfig))
            .constructor(LambdaConflictHandlerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaConflictHandlerConfig")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFLICT_HANDLER_FIELD,
            CONFLICT_DETECTION_FIELD, LAMBDA_CONFLICT_HANDLER_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String conflictHandler;

    private final String conflictDetection;

    private final LambdaConflictHandlerConfig lambdaConflictHandlerConfig;

    private SyncConfig(BuilderImpl builder) {
        this.conflictHandler = builder.conflictHandler;
        this.conflictDetection = builder.conflictDetection;
        this.lambdaConflictHandlerConfig = builder.lambdaConflictHandlerConfig;
    }

    /**
     * <p>
     * The Conflict Resolution strategy to perform in the event of a conflict.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>OPTIMISTIC_CONCURRENCY</b>: Resolve conflicts by rejecting mutations when versions do not match the latest
     * version at the server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AUTOMERGE</b>: Resolve conflicts with the Automerge conflict resolution strategy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>LAMBDA</b>: Resolve conflicts with a Lambda function supplied in the LambdaConflictHandlerConfig.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conflictHandler}
     * will return {@link ConflictHandlerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #conflictHandlerAsString}.
     * </p>
     * 
     * @return The Conflict Resolution strategy to perform in the event of a conflict.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>OPTIMISTIC_CONCURRENCY</b>: Resolve conflicts by rejecting mutations when versions do not match the
     *         latest version at the server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AUTOMERGE</b>: Resolve conflicts with the Automerge conflict resolution strategy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>LAMBDA</b>: Resolve conflicts with a Lambda function supplied in the LambdaConflictHandlerConfig.
     *         </p>
     *         </li>
     * @see ConflictHandlerType
     */
    public ConflictHandlerType conflictHandler() {
        return ConflictHandlerType.fromValue(conflictHandler);
    }

    /**
     * <p>
     * The Conflict Resolution strategy to perform in the event of a conflict.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>OPTIMISTIC_CONCURRENCY</b>: Resolve conflicts by rejecting mutations when versions do not match the latest
     * version at the server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AUTOMERGE</b>: Resolve conflicts with the Automerge conflict resolution strategy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>LAMBDA</b>: Resolve conflicts with a Lambda function supplied in the LambdaConflictHandlerConfig.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conflictHandler}
     * will return {@link ConflictHandlerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #conflictHandlerAsString}.
     * </p>
     * 
     * @return The Conflict Resolution strategy to perform in the event of a conflict.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>OPTIMISTIC_CONCURRENCY</b>: Resolve conflicts by rejecting mutations when versions do not match the
     *         latest version at the server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AUTOMERGE</b>: Resolve conflicts with the Automerge conflict resolution strategy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>LAMBDA</b>: Resolve conflicts with a Lambda function supplied in the LambdaConflictHandlerConfig.
     *         </p>
     *         </li>
     * @see ConflictHandlerType
     */
    public String conflictHandlerAsString() {
        return conflictHandler;
    }

    /**
     * <p>
     * The Conflict Detection strategy to use.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>VERSION</b>: Detect conflicts based on object versions for this resolver.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>NONE</b>: Do not detect conflicts when executing this resolver.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conflictDetection}
     * will return {@link ConflictDetectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #conflictDetectionAsString}.
     * </p>
     * 
     * @return The Conflict Detection strategy to use.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>VERSION</b>: Detect conflicts based on object versions for this resolver.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>NONE</b>: Do not detect conflicts when executing this resolver.
     *         </p>
     *         </li>
     * @see ConflictDetectionType
     */
    public ConflictDetectionType conflictDetection() {
        return ConflictDetectionType.fromValue(conflictDetection);
    }

    /**
     * <p>
     * The Conflict Detection strategy to use.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>VERSION</b>: Detect conflicts based on object versions for this resolver.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>NONE</b>: Do not detect conflicts when executing this resolver.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conflictDetection}
     * will return {@link ConflictDetectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #conflictDetectionAsString}.
     * </p>
     * 
     * @return The Conflict Detection strategy to use.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>VERSION</b>: Detect conflicts based on object versions for this resolver.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>NONE</b>: Do not detect conflicts when executing this resolver.
     *         </p>
     *         </li>
     * @see ConflictDetectionType
     */
    public String conflictDetectionAsString() {
        return conflictDetection;
    }

    /**
     * <p>
     * The <code>LambdaConflictHandlerConfig</code> when configuring LAMBDA as the Conflict Handler.
     * </p>
     * 
     * @return The <code>LambdaConflictHandlerConfig</code> when configuring LAMBDA as the Conflict Handler.
     */
    public LambdaConflictHandlerConfig lambdaConflictHandlerConfig() {
        return lambdaConflictHandlerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conflictHandlerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conflictDetectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaConflictHandlerConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncConfig)) {
            return false;
        }
        SyncConfig other = (SyncConfig) obj;
        return Objects.equals(conflictHandlerAsString(), other.conflictHandlerAsString())
                && Objects.equals(conflictDetectionAsString(), other.conflictDetectionAsString())
                && Objects.equals(lambdaConflictHandlerConfig(), other.lambdaConflictHandlerConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SyncConfig").add("ConflictHandler", conflictHandlerAsString())
                .add("ConflictDetection", conflictDetectionAsString())
                .add("LambdaConflictHandlerConfig", lambdaConflictHandlerConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conflictHandler":
            return Optional.ofNullable(clazz.cast(conflictHandlerAsString()));
        case "conflictDetection":
            return Optional.ofNullable(clazz.cast(conflictDetectionAsString()));
        case "lambdaConflictHandlerConfig":
            return Optional.ofNullable(clazz.cast(lambdaConflictHandlerConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SyncConfig, T> g) {
        return obj -> g.apply((SyncConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SyncConfig> {
        /**
         * <p>
         * The Conflict Resolution strategy to perform in the event of a conflict.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>OPTIMISTIC_CONCURRENCY</b>: Resolve conflicts by rejecting mutations when versions do not match the latest
         * version at the server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AUTOMERGE</b>: Resolve conflicts with the Automerge conflict resolution strategy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>LAMBDA</b>: Resolve conflicts with a Lambda function supplied in the LambdaConflictHandlerConfig.
         * </p>
         * </li>
         * </ul>
         * 
         * @param conflictHandler
         *        The Conflict Resolution strategy to perform in the event of a conflict.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>OPTIMISTIC_CONCURRENCY</b>: Resolve conflicts by rejecting mutations when versions do not match the
         *        latest version at the server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AUTOMERGE</b>: Resolve conflicts with the Automerge conflict resolution strategy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>LAMBDA</b>: Resolve conflicts with a Lambda function supplied in the LambdaConflictHandlerConfig.
         *        </p>
         *        </li>
         * @see ConflictHandlerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictHandlerType
         */
        Builder conflictHandler(String conflictHandler);

        /**
         * <p>
         * The Conflict Resolution strategy to perform in the event of a conflict.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>OPTIMISTIC_CONCURRENCY</b>: Resolve conflicts by rejecting mutations when versions do not match the latest
         * version at the server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AUTOMERGE</b>: Resolve conflicts with the Automerge conflict resolution strategy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>LAMBDA</b>: Resolve conflicts with a Lambda function supplied in the LambdaConflictHandlerConfig.
         * </p>
         * </li>
         * </ul>
         * 
         * @param conflictHandler
         *        The Conflict Resolution strategy to perform in the event of a conflict.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>OPTIMISTIC_CONCURRENCY</b>: Resolve conflicts by rejecting mutations when versions do not match the
         *        latest version at the server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AUTOMERGE</b>: Resolve conflicts with the Automerge conflict resolution strategy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>LAMBDA</b>: Resolve conflicts with a Lambda function supplied in the LambdaConflictHandlerConfig.
         *        </p>
         *        </li>
         * @see ConflictHandlerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictHandlerType
         */
        Builder conflictHandler(ConflictHandlerType conflictHandler);

        /**
         * <p>
         * The Conflict Detection strategy to use.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>VERSION</b>: Detect conflicts based on object versions for this resolver.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NONE</b>: Do not detect conflicts when executing this resolver.
         * </p>
         * </li>
         * </ul>
         * 
         * @param conflictDetection
         *        The Conflict Detection strategy to use.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>VERSION</b>: Detect conflicts based on object versions for this resolver.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NONE</b>: Do not detect conflicts when executing this resolver.
         *        </p>
         *        </li>
         * @see ConflictDetectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictDetectionType
         */
        Builder conflictDetection(String conflictDetection);

        /**
         * <p>
         * The Conflict Detection strategy to use.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>VERSION</b>: Detect conflicts based on object versions for this resolver.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NONE</b>: Do not detect conflicts when executing this resolver.
         * </p>
         * </li>
         * </ul>
         * 
         * @param conflictDetection
         *        The Conflict Detection strategy to use.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>VERSION</b>: Detect conflicts based on object versions for this resolver.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NONE</b>: Do not detect conflicts when executing this resolver.
         *        </p>
         *        </li>
         * @see ConflictDetectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictDetectionType
         */
        Builder conflictDetection(ConflictDetectionType conflictDetection);

        /**
         * <p>
         * The <code>LambdaConflictHandlerConfig</code> when configuring LAMBDA as the Conflict Handler.
         * </p>
         * 
         * @param lambdaConflictHandlerConfig
         *        The <code>LambdaConflictHandlerConfig</code> when configuring LAMBDA as the Conflict Handler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaConflictHandlerConfig(LambdaConflictHandlerConfig lambdaConflictHandlerConfig);

        /**
         * <p>
         * The <code>LambdaConflictHandlerConfig</code> when configuring LAMBDA as the Conflict Handler.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaConflictHandlerConfig.Builder} avoiding
         * the need to create one manually via {@link LambdaConflictHandlerConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaConflictHandlerConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #lambdaConflictHandlerConfig(LambdaConflictHandlerConfig)}.
         * 
         * @param lambdaConflictHandlerConfig
         *        a consumer that will call methods on {@link LambdaConflictHandlerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaConflictHandlerConfig(LambdaConflictHandlerConfig)
         */
        default Builder lambdaConflictHandlerConfig(Consumer<LambdaConflictHandlerConfig.Builder> lambdaConflictHandlerConfig) {
            return lambdaConflictHandlerConfig(LambdaConflictHandlerConfig.builder().applyMutation(lambdaConflictHandlerConfig)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String conflictHandler;

        private String conflictDetection;

        private LambdaConflictHandlerConfig lambdaConflictHandlerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SyncConfig model) {
            conflictHandler(model.conflictHandler);
            conflictDetection(model.conflictDetection);
            lambdaConflictHandlerConfig(model.lambdaConflictHandlerConfig);
        }

        public final String getConflictHandlerAsString() {
            return conflictHandler;
        }

        @Override
        public final Builder conflictHandler(String conflictHandler) {
            this.conflictHandler = conflictHandler;
            return this;
        }

        @Override
        public final Builder conflictHandler(ConflictHandlerType conflictHandler) {
            this.conflictHandler(conflictHandler == null ? null : conflictHandler.toString());
            return this;
        }

        public final void setConflictHandler(String conflictHandler) {
            this.conflictHandler = conflictHandler;
        }

        public final String getConflictDetectionAsString() {
            return conflictDetection;
        }

        @Override
        public final Builder conflictDetection(String conflictDetection) {
            this.conflictDetection = conflictDetection;
            return this;
        }

        @Override
        public final Builder conflictDetection(ConflictDetectionType conflictDetection) {
            this.conflictDetection(conflictDetection == null ? null : conflictDetection.toString());
            return this;
        }

        public final void setConflictDetection(String conflictDetection) {
            this.conflictDetection = conflictDetection;
        }

        public final LambdaConflictHandlerConfig.Builder getLambdaConflictHandlerConfig() {
            return lambdaConflictHandlerConfig != null ? lambdaConflictHandlerConfig.toBuilder() : null;
        }

        @Override
        public final Builder lambdaConflictHandlerConfig(LambdaConflictHandlerConfig lambdaConflictHandlerConfig) {
            this.lambdaConflictHandlerConfig = lambdaConflictHandlerConfig;
            return this;
        }

        public final void setLambdaConflictHandlerConfig(LambdaConflictHandlerConfig.BuilderImpl lambdaConflictHandlerConfig) {
            this.lambdaConflictHandlerConfig = lambdaConflictHandlerConfig != null ? lambdaConflictHandlerConfig.build() : null;
        }

        @Override
        public SyncConfig build() {
            return new SyncConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
