/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an additional authentication provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdditionalAuthenticationProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<AdditionalAuthenticationProvider.Builder, AdditionalAuthenticationProvider> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdditionalAuthenticationProvider::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build())
            .build();

    private static final SdkField<OpenIDConnectConfig> OPEN_ID_CONNECT_CONFIG_FIELD = SdkField
            .<OpenIDConnectConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(AdditionalAuthenticationProvider::openIDConnectConfig)).setter(setter(Builder::openIDConnectConfig))
            .constructor(OpenIDConnectConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDConnectConfig").build())
            .build();

    private static final SdkField<CognitoUserPoolConfig> USER_POOL_CONFIG_FIELD = SdkField
            .<CognitoUserPoolConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(AdditionalAuthenticationProvider::userPoolConfig)).setter(setter(Builder::userPoolConfig))
            .constructor(CognitoUserPoolConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD,
            OPEN_ID_CONNECT_CONFIG_FIELD, USER_POOL_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String authenticationType;

    private final OpenIDConnectConfig openIDConnectConfig;

    private final CognitoUserPoolConfig userPoolConfig;

    private AdditionalAuthenticationProvider(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.openIDConnectConfig = builder.openIDConnectConfig;
        this.userPoolConfig = builder.userPoolConfig;
    }

    /**
     * <p>
     * The authentication type: API key, AWS IAM, OIDC, or Amazon Cognito user pools.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type: API key, AWS IAM, OIDC, or Amazon Cognito user pools.
     * @see AuthenticationType
     */
    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication type: API key, AWS IAM, OIDC, or Amazon Cognito user pools.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type: API key, AWS IAM, OIDC, or Amazon Cognito user pools.
     * @see AuthenticationType
     */
    public String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The OpenID Connect configuration.
     * </p>
     * 
     * @return The OpenID Connect configuration.
     */
    public OpenIDConnectConfig openIDConnectConfig() {
        return openIDConnectConfig;
    }

    /**
     * <p>
     * The Amazon Cognito user pool configuration.
     * </p>
     * 
     * @return The Amazon Cognito user pool configuration.
     */
    public CognitoUserPoolConfig userPoolConfig() {
        return userPoolConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(openIDConnectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalAuthenticationProvider)) {
            return false;
        }
        AdditionalAuthenticationProvider other = (AdditionalAuthenticationProvider) obj;
        return Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(openIDConnectConfig(), other.openIDConnectConfig())
                && Objects.equals(userPoolConfig(), other.userPoolConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AdditionalAuthenticationProvider").add("AuthenticationType", authenticationTypeAsString())
                .add("OpenIDConnectConfig", openIDConnectConfig()).add("UserPoolConfig", userPoolConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "openIDConnectConfig":
            return Optional.ofNullable(clazz.cast(openIDConnectConfig()));
        case "userPoolConfig":
            return Optional.ofNullable(clazz.cast(userPoolConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalAuthenticationProvider, T> g) {
        return obj -> g.apply((AdditionalAuthenticationProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdditionalAuthenticationProvider> {
        /**
         * <p>
         * The authentication type: API key, AWS IAM, OIDC, or Amazon Cognito user pools.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type: API key, AWS IAM, OIDC, or Amazon Cognito user pools.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication type: API key, AWS IAM, OIDC, or Amazon Cognito user pools.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type: API key, AWS IAM, OIDC, or Amazon Cognito user pools.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * The OpenID Connect configuration.
         * </p>
         * 
         * @param openIDConnectConfig
         *        The OpenID Connect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig);

        /**
         * <p>
         * The OpenID Connect configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link OpenIDConnectConfig.Builder} avoiding the need
         * to create one manually via {@link OpenIDConnectConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OpenIDConnectConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #openIDConnectConfig(OpenIDConnectConfig)}.
         * 
         * @param openIDConnectConfig
         *        a consumer that will call methods on {@link OpenIDConnectConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openIDConnectConfig(OpenIDConnectConfig)
         */
        default Builder openIDConnectConfig(Consumer<OpenIDConnectConfig.Builder> openIDConnectConfig) {
            return openIDConnectConfig(OpenIDConnectConfig.builder().applyMutation(openIDConnectConfig).build());
        }

        /**
         * <p>
         * The Amazon Cognito user pool configuration.
         * </p>
         * 
         * @param userPoolConfig
         *        The Amazon Cognito user pool configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolConfig(CognitoUserPoolConfig userPoolConfig);

        /**
         * <p>
         * The Amazon Cognito user pool configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link CognitoUserPoolConfig.Builder} avoiding the need
         * to create one manually via {@link CognitoUserPoolConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CognitoUserPoolConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #userPoolConfig(CognitoUserPoolConfig)}.
         * 
         * @param userPoolConfig
         *        a consumer that will call methods on {@link CognitoUserPoolConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPoolConfig(CognitoUserPoolConfig)
         */
        default Builder userPoolConfig(Consumer<CognitoUserPoolConfig.Builder> userPoolConfig) {
            return userPoolConfig(CognitoUserPoolConfig.builder().applyMutation(userPoolConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String authenticationType;

        private OpenIDConnectConfig openIDConnectConfig;

        private CognitoUserPoolConfig userPoolConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalAuthenticationProvider model) {
            authenticationType(model.authenticationType);
            openIDConnectConfig(model.openIDConnectConfig);
            userPoolConfig(model.userPoolConfig);
        }

        public final String getAuthenticationTypeAsString() {
            return authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        public final OpenIDConnectConfig.Builder getOpenIDConnectConfig() {
            return openIDConnectConfig != null ? openIDConnectConfig.toBuilder() : null;
        }

        @Override
        public final Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig;
            return this;
        }

        public final void setOpenIDConnectConfig(OpenIDConnectConfig.BuilderImpl openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig != null ? openIDConnectConfig.build() : null;
        }

        public final CognitoUserPoolConfig.Builder getUserPoolConfig() {
            return userPoolConfig != null ? userPoolConfig.toBuilder() : null;
        }

        @Override
        public final Builder userPoolConfig(CognitoUserPoolConfig userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        public final void setUserPoolConfig(CognitoUserPoolConfig.BuilderImpl userPoolConfig) {
            this.userPoolConfig = userPoolConfig != null ? userPoolConfig.build() : null;
        }

        @Override
        public AdditionalAuthenticationProvider build() {
            return new AdditionalAuthenticationProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
