/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AppSyncResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIntrospectionSchemaResponse
extends AppSyncResponse
implements ToCopyableBuilder<Builder, GetIntrospectionSchemaResponse> {
    private static final SdkField<SdkBytes> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(GetIntrospectionSchemaResponse.getter(GetIntrospectionSchemaResponse::schema)).setter(GetIntrospectionSchemaResponse.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_FIELD));
    private final SdkBytes schema;

    private GetIntrospectionSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.schema = builder.schema;
    }

    public SdkBytes schema() {
        return this.schema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntrospectionSchemaResponse)) {
            return false;
        }
        GetIntrospectionSchemaResponse other = (GetIntrospectionSchemaResponse)((Object)obj);
        return Objects.equals(this.schema(), other.schema());
    }

    public String toString() {
        return ToString.builder((String)"GetIntrospectionSchemaResponse").add("Schema", (Object)this.schema()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIntrospectionSchemaResponse, T> g) {
        return obj -> g.apply((GetIntrospectionSchemaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncResponse.BuilderImpl
    implements Builder {
        private SdkBytes schema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntrospectionSchemaResponse model) {
            super(model);
            this.schema(model.schema);
        }

        public final ByteBuffer getSchema() {
            return this.schema == null ? null : this.schema.asByteBuffer();
        }

        @Override
        public final Builder schema(SdkBytes schema) {
            this.schema = StandardMemberCopier.copy((SdkBytes)schema);
            return this;
        }

        public final void setSchema(ByteBuffer schema) {
            this.schema(schema == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)schema));
        }

        @Override
        public GetIntrospectionSchemaResponse build() {
            return new GetIntrospectionSchemaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIntrospectionSchemaResponse> {
        public Builder schema(SdkBytes var1);
    }
}

