/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appsync.model.DefaultAction;
import software.amazon.awssdk.services.appsync.transform.UserPoolConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UserPoolConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, UserPoolConfig> {
    private final String userPoolId;
    private final String awsRegion;
    private final String defaultAction;
    private final String appIdClientRegex;

    private UserPoolConfig(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.awsRegion = builder.awsRegion;
        this.defaultAction = builder.defaultAction;
        this.appIdClientRegex = builder.appIdClientRegex;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public DefaultAction defaultAction() {
        return DefaultAction.fromValue(this.defaultAction);
    }

    public String defaultActionString() {
        return this.defaultAction;
    }

    public String appIdClientRegex() {
        return this.appIdClientRegex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultActionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.appIdClientRegex());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolConfig)) {
            return false;
        }
        UserPoolConfig other = (UserPoolConfig)obj;
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.defaultActionString(), other.defaultActionString()) && Objects.equals(this.appIdClientRegex(), other.appIdClientRegex());
    }

    public String toString() {
        return ToString.builder((String)"UserPoolConfig").add("UserPoolId", (Object)this.userPoolId()).add("AwsRegion", (Object)this.awsRegion()).add("DefaultAction", (Object)this.defaultActionString()).add("AppIdClientRegex", (Object)this.appIdClientRegex()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userPoolId": {
                return Optional.of(clazz.cast(this.userPoolId()));
            }
            case "awsRegion": {
                return Optional.of(clazz.cast(this.awsRegion()));
            }
            case "defaultAction": {
                return Optional.of(clazz.cast(this.defaultActionString()));
            }
            case "appIdClientRegex": {
                return Optional.of(clazz.cast(this.appIdClientRegex()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserPoolConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String userPoolId;
        private String awsRegion;
        private String defaultAction;
        private String appIdClientRegex;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPoolConfig model) {
            this.userPoolId(model.userPoolId);
            this.awsRegion(model.awsRegion);
            this.defaultAction(model.defaultAction);
            this.appIdClientRegex(model.appIdClientRegex);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getDefaultAction() {
            return this.defaultAction;
        }

        @Override
        public final Builder defaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        @Override
        public final Builder defaultAction(DefaultAction defaultAction) {
            this.defaultAction(defaultAction.toString());
            return this;
        }

        public final void setDefaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
        }

        public final String getAppIdClientRegex() {
            return this.appIdClientRegex;
        }

        @Override
        public final Builder appIdClientRegex(String appIdClientRegex) {
            this.appIdClientRegex = appIdClientRegex;
            return this;
        }

        public final void setAppIdClientRegex(String appIdClientRegex) {
            this.appIdClientRegex = appIdClientRegex;
        }

        public UserPoolConfig build() {
            return new UserPoolConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UserPoolConfig> {
        public Builder userPoolId(String var1);

        public Builder awsRegion(String var1);

        public Builder defaultAction(String var1);

        public Builder defaultAction(DefaultAction var1);

        public Builder appIdClientRegex(String var1);
    }
}

