/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat;
import software.amazon.awssdk.services.appsync.transform.TypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Type
implements StructuredPojo,
ToCopyableBuilder<Builder, Type> {
    private final String name;
    private final String description;
    private final String arn;
    private final String definition;
    private final String format;

    private Type(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.arn = builder.arn;
        this.definition = builder.definition;
        this.format = builder.format;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String arn() {
        return this.arn;
    }

    public String definition() {
        return this.definition;
    }

    public TypeDefinitionFormat format() {
        return TypeDefinitionFormat.fromValue(this.format);
    }

    public String formatString() {
        return this.format;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Type)) {
            return false;
        }
        Type other = (Type)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.formatString(), other.formatString());
    }

    public String toString() {
        return ToString.builder((String)"Type").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Arn", (Object)this.arn()).add("Definition", (Object)this.definition()).add("Format", (Object)this.formatString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "definition": {
                return Optional.of(clazz.cast(this.definition()));
            }
            case "format": {
                return Optional.of(clazz.cast(this.formatString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String arn;
        private String definition;
        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(Type model) {
            this.name(model.name);
            this.description(model.description);
            this.arn(model.arn);
            this.definition(model.definition);
            this.format(model.format);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDefinition() {
            return this.definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(TypeDefinitionFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public Type build() {
            return new Type(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Type> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder arn(String var1);

        public Builder definition(String var1);

        public Builder format(String var1);

        public Builder format(TypeDefinitionFormat var1);
    }
}

