/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appsync.model.DynamodbDataSourceConfig;

@SdkInternalApi
public class DynamodbDataSourceConfigMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tableName").build();
    private static final MarshallingInfo<String> AWSREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsRegion").build();
    private static final MarshallingInfo<Boolean> USECALLERCREDENTIALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("useCallerCredentials").build();
    private static final DynamodbDataSourceConfigMarshaller INSTANCE = new DynamodbDataSourceConfigMarshaller();

    public static DynamodbDataSourceConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DynamodbDataSourceConfig dynamodbDataSourceConfig, ProtocolMarshaller protocolMarshaller) {
        if (dynamodbDataSourceConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dynamodbDataSourceConfig.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)dynamodbDataSourceConfig.awsRegion(), AWSREGION_BINDING);
            protocolMarshaller.marshall((Object)dynamodbDataSourceConfig.useCallerCredentials(), USECALLERCREDENTIALS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

