/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.appsync.model.ApiKey;
import software.amazon.awssdk.services.appsync.model.ApiKeysCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListApiKeysResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListApiKeysResponse> {
    private final List<ApiKey> apiKeys;
    private final String nextToken;

    private ListApiKeysResponse(BuilderImpl builder) {
        this.apiKeys = builder.apiKeys;
        this.nextToken = builder.nextToken;
    }

    public List<ApiKey> apiKeys() {
        return this.apiKeys;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApiKeysResponse)) {
            return false;
        }
        ListApiKeysResponse other = (ListApiKeysResponse)((Object)obj);
        return Objects.equals(this.apiKeys(), other.apiKeys()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.apiKeys() != null) {
            sb.append("ApiKeys: ").append(this.apiKeys()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiKeys": {
                return Optional.of(clazz.cast(this.apiKeys()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ApiKey> apiKeys;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApiKeysResponse model) {
            this.apiKeys(model.apiKeys);
            this.nextToken(model.nextToken);
        }

        public final Collection<ApiKey.Builder> getApiKeys() {
            return this.apiKeys != null ? (Collection)this.apiKeys.stream().map(ApiKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder apiKeys(Collection<ApiKey> apiKeys) {
            this.apiKeys = ApiKeysCopier.copy(apiKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiKeys(ApiKey ... apiKeys) {
            this.apiKeys(Arrays.asList(apiKeys));
            return this;
        }

        public final void setApiKeys(Collection<ApiKey.BuilderImpl> apiKeys) {
            this.apiKeys = ApiKeysCopier.copyFromBuilder(apiKeys);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListApiKeysResponse build() {
            return new ListApiKeysResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListApiKeysResponse> {
        public Builder apiKeys(Collection<ApiKey> var1);

        public Builder apiKeys(ApiKey ... var1);

        public Builder nextToken(String var1);
    }
}

