/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appsync.model.ElasticsearchDataSourceConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ElasticsearchDataSourceConfigMarshaller {
    private static final MarshallingInfo<String> ENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endpoint").isBinary(false).build();
    private static final MarshallingInfo<String> AWSREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsRegion").isBinary(false).build();
    private static final ElasticsearchDataSourceConfigMarshaller INSTANCE = new ElasticsearchDataSourceConfigMarshaller();

    private ElasticsearchDataSourceConfigMarshaller() {
    }

    public static ElasticsearchDataSourceConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticsearchDataSourceConfig elasticsearchDataSourceConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)elasticsearchDataSourceConfig, (String)"elasticsearchDataSourceConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)elasticsearchDataSourceConfig.endpoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDataSourceConfig.awsRegion(), AWSREGION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

