/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.services.appsync.model.AuthenticationType;
import software.amazon.awssdk.services.appsync.model.LogConfig;
import software.amazon.awssdk.services.appsync.model.OpenIDConnectConfig;
import software.amazon.awssdk.services.appsync.model.UserPoolConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGraphqlApiRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, UpdateGraphqlApiRequest> {
    private final String apiId;
    private final String name;
    private final LogConfig logConfig;
    private final String authenticationType;
    private final UserPoolConfig userPoolConfig;
    private final OpenIDConnectConfig openIDConnectConfig;

    private UpdateGraphqlApiRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.name = builder.name;
        this.logConfig = builder.logConfig;
        this.authenticationType = builder.authenticationType;
        this.userPoolConfig = builder.userPoolConfig;
        this.openIDConnectConfig = builder.openIDConnectConfig;
    }

    public String apiId() {
        return this.apiId;
    }

    public String name() {
        return this.name;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public UserPoolConfig userPoolConfig() {
        return this.userPoolConfig;
    }

    public OpenIDConnectConfig openIDConnectConfig() {
        return this.openIDConnectConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.openIDConnectConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGraphqlApiRequest)) {
            return false;
        }
        UpdateGraphqlApiRequest other = (UpdateGraphqlApiRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.logConfig(), other.logConfig()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.userPoolConfig(), other.userPoolConfig()) && Objects.equals(this.openIDConnectConfig(), other.openIDConnectConfig());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGraphqlApiRequest").add("ApiId", (Object)this.apiId()).add("Name", (Object)this.name()).add("LogConfig", (Object)this.logConfig()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("UserPoolConfig", (Object)this.userPoolConfig()).add("OpenIDConnectConfig", (Object)this.openIDConnectConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "logConfig": {
                return Optional.ofNullable(clazz.cast(this.logConfig()));
            }
            case "authenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "userPoolConfig": {
                return Optional.ofNullable(clazz.cast(this.userPoolConfig()));
            }
            case "openIDConnectConfig": {
                return Optional.ofNullable(clazz.cast(this.openIDConnectConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private String name;
        private LogConfig logConfig;
        private String authenticationType;
        private UserPoolConfig userPoolConfig;
        private OpenIDConnectConfig openIDConnectConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGraphqlApiRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.name(model.name);
            this.logConfig(model.logConfig);
            this.authenticationType(model.authenticationType);
            this.userPoolConfig(model.userPoolConfig);
            this.openIDConnectConfig(model.openIDConnectConfig);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final LogConfig.Builder getLogConfig() {
            return this.logConfig != null ? this.logConfig.toBuilder() : null;
        }

        @Override
        public final Builder logConfig(LogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public final void setLogConfig(LogConfig.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        public final UserPoolConfig.Builder getUserPoolConfig() {
            return this.userPoolConfig != null ? this.userPoolConfig.toBuilder() : null;
        }

        @Override
        public final Builder userPoolConfig(UserPoolConfig userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        public final void setUserPoolConfig(UserPoolConfig.BuilderImpl userPoolConfig) {
            this.userPoolConfig = userPoolConfig != null ? userPoolConfig.build() : null;
        }

        public final OpenIDConnectConfig.Builder getOpenIDConnectConfig() {
            return this.openIDConnectConfig != null ? this.openIDConnectConfig.toBuilder() : null;
        }

        @Override
        public final Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig;
            return this;
        }

        public final void setOpenIDConnectConfig(OpenIDConnectConfig.BuilderImpl openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig != null ? openIDConnectConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGraphqlApiRequest build() {
            return new UpdateGraphqlApiRequest(this);
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    CopyableBuilder<Builder, UpdateGraphqlApiRequest> {
        public Builder apiId(String var1);

        public Builder name(String var1);

        public Builder logConfig(LogConfig var1);

        default public Builder logConfig(Consumer<LogConfig.Builder> logConfig) {
            return this.logConfig((LogConfig)((LogConfig.Builder)LogConfig.builder().applyMutation(logConfig)).build());
        }

        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder userPoolConfig(UserPoolConfig var1);

        default public Builder userPoolConfig(Consumer<UserPoolConfig.Builder> userPoolConfig) {
            return this.userPoolConfig((UserPoolConfig)((UserPoolConfig.Builder)UserPoolConfig.builder().applyMutation(userPoolConfig)).build());
        }

        public Builder openIDConnectConfig(OpenIDConnectConfig var1);

        default public Builder openIDConnectConfig(Consumer<OpenIDConnectConfig.Builder> openIDConnectConfig) {
            return this.openIDConnectConfig((OpenIDConnectConfig)((OpenIDConnectConfig.Builder)OpenIDConnectConfig.builder().applyMutation(openIDConnectConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

