/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appsync.model.GraphqlApi;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GraphqlApiMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> APIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiId").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHENTICATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authenticationType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> USERPOOLCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userPoolConfig").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<Map> URIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uris").isBinary(false).build();
    private static final GraphqlApiMarshaller INSTANCE = new GraphqlApiMarshaller();

    private GraphqlApiMarshaller() {
    }

    public static GraphqlApiMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GraphqlApi graphqlApi, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)graphqlApi, (String)"graphqlApi");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)graphqlApi.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)graphqlApi.apiId(), APIID_BINDING);
            protocolMarshaller.marshall((Object)graphqlApi.authenticationTypeAsString(), AUTHENTICATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)graphqlApi.userPoolConfig(), USERPOOLCONFIG_BINDING);
            protocolMarshaller.marshall((Object)graphqlApi.arn(), ARN_BINDING);
            protocolMarshaller.marshall(graphqlApi.uris(), URIS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

