/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appsync.model.GetTypeRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetTypeRequestModelMarshaller {
    private static final MarshallingInfo<String> APIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("apiId").isBinary(false).build();
    private static final MarshallingInfo<String> TYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("typeName").isBinary(false).build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("format").isBinary(false).build();
    private static final GetTypeRequestModelMarshaller INSTANCE = new GetTypeRequestModelMarshaller();

    private GetTypeRequestModelMarshaller() {
    }

    public static GetTypeRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetTypeRequest getTypeRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getTypeRequest), (String)"getTypeRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getTypeRequest.apiId(), APIID_BINDING);
            protocolMarshaller.marshall((Object)getTypeRequest.typeName(), TYPENAME_BINDING);
            protocolMarshaller.marshall((Object)getTypeRequest.formatAsString(), FORMAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

