/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateResolverRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, UpdateResolverRequest> {
    private final String apiId;
    private final String typeName;
    private final String fieldName;
    private final String dataSourceName;
    private final String requestMappingTemplate;
    private final String responseMappingTemplate;

    private UpdateResolverRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.typeName = builder.typeName;
        this.fieldName = builder.fieldName;
        this.dataSourceName = builder.dataSourceName;
        this.requestMappingTemplate = builder.requestMappingTemplate;
        this.responseMappingTemplate = builder.responseMappingTemplate;
    }

    public String apiId() {
        return this.apiId;
    }

    public String typeName() {
        return this.typeName;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String dataSourceName() {
        return this.dataSourceName;
    }

    public String requestMappingTemplate() {
        return this.requestMappingTemplate;
    }

    public String responseMappingTemplate() {
        return this.responseMappingTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseMappingTemplate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResolverRequest)) {
            return false;
        }
        UpdateResolverRequest other = (UpdateResolverRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.fieldName(), other.fieldName()) && Objects.equals(this.dataSourceName(), other.dataSourceName()) && Objects.equals(this.requestMappingTemplate(), other.requestMappingTemplate()) && Objects.equals(this.responseMappingTemplate(), other.responseMappingTemplate());
    }

    public String toString() {
        return ToString.builder((String)"UpdateResolverRequest").add("ApiId", (Object)this.apiId()).add("TypeName", (Object)this.typeName()).add("FieldName", (Object)this.fieldName()).add("DataSourceName", (Object)this.dataSourceName()).add("RequestMappingTemplate", (Object)this.requestMappingTemplate()).add("ResponseMappingTemplate", (Object)this.responseMappingTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.of(clazz.cast(this.apiId()));
            }
            case "typeName": {
                return Optional.of(clazz.cast(this.typeName()));
            }
            case "fieldName": {
                return Optional.of(clazz.cast(this.fieldName()));
            }
            case "dataSourceName": {
                return Optional.of(clazz.cast(this.dataSourceName()));
            }
            case "requestMappingTemplate": {
                return Optional.of(clazz.cast(this.requestMappingTemplate()));
            }
            case "responseMappingTemplate": {
                return Optional.of(clazz.cast(this.responseMappingTemplate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private String typeName;
        private String fieldName;
        private String dataSourceName;
        private String requestMappingTemplate;
        private String responseMappingTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResolverRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.typeName(model.typeName);
            this.fieldName(model.fieldName);
            this.dataSourceName(model.dataSourceName);
            this.requestMappingTemplate(model.requestMappingTemplate);
            this.responseMappingTemplate(model.responseMappingTemplate);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final String getRequestMappingTemplate() {
            return this.requestMappingTemplate;
        }

        @Override
        public final Builder requestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        public final void setRequestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
        }

        public final String getResponseMappingTemplate() {
            return this.responseMappingTemplate;
        }

        @Override
        public final Builder responseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        public final void setResponseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateResolverRequest build() {
            return new UpdateResolverRequest(this);
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    CopyableBuilder<Builder, UpdateResolverRequest> {
        public Builder apiId(String var1);

        public Builder typeName(String var1);

        public Builder fieldName(String var1);

        public Builder dataSourceName(String var1);

        public Builder requestMappingTemplate(String var1);

        public Builder responseMappingTemplate(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

