/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteDataSourceRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, DeleteDataSourceRequest> {
    private final String apiId;
    private final String name;

    private DeleteDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.name = builder.name;
    }

    public String apiId() {
        return this.apiId;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDataSourceRequest)) {
            return false;
        }
        DeleteDataSourceRequest other = (DeleteDataSourceRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"DeleteDataSourceRequest").add("ApiId", (Object)this.apiId()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.of(clazz.cast(this.apiId()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDataSourceRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.name(model.name);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteDataSourceRequest build() {
            return new DeleteDataSourceRequest(this);
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    CopyableBuilder<Builder, DeleteDataSourceRequest> {
        public Builder apiId(String var1);

        public Builder name(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

