/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.services.appstream.model.Session;
import software.amazon.awssdk.services.appstream.model.SessionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSessionsResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeSessionsResponse> {
    private static final SdkField<List<Session>> SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSessionsResponse.getter(DescribeSessionsResponse::sessions)).setter(DescribeSessionsResponse.setter(Builder::sessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Session::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSessionsResponse.getter(DescribeSessionsResponse::nextToken)).setter(DescribeSessionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Session> sessions;
    private final String nextToken;

    private DescribeSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.sessions = builder.sessions;
        this.nextToken = builder.nextToken;
    }

    public List<Session> sessions() {
        return this.sessions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSessionsResponse)) {
            return false;
        }
        DescribeSessionsResponse other = (DescribeSessionsResponse)((Object)obj);
        return Objects.equals(this.sessions(), other.sessions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSessionsResponse").add("Sessions", this.sessions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sessions": {
                return Optional.ofNullable(clazz.cast(this.sessions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSessionsResponse, T> g) {
        return obj -> g.apply((DescribeSessionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private List<Session> sessions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSessionsResponse model) {
            super(model);
            this.sessions(model.sessions);
            this.nextToken(model.nextToken);
        }

        public final Collection<Session.Builder> getSessions() {
            return this.sessions != null ? (Collection)this.sessions.stream().map(Session::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sessions(Collection<Session> sessions) {
            this.sessions = SessionListCopier.copy(sessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Session ... sessions) {
            this.sessions(Arrays.asList(sessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Consumer<Session.Builder> ... sessions) {
            this.sessions(Stream.of(sessions).map(c -> (Session)((Session.Builder)Session.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSessions(Collection<Session.BuilderImpl> sessions) {
            this.sessions = SessionListCopier.copyFromBuilder(sessions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSessionsResponse build() {
            return new DescribeSessionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSessionsResponse> {
        public Builder sessions(Collection<Session> var1);

        public Builder sessions(Session ... var1);

        public Builder sessions(Consumer<Session.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

