/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.AuthenticationType;
import software.amazon.awssdk.services.appstream.model.NetworkAccessConfiguration;
import software.amazon.awssdk.services.appstream.model.SessionConnectionState;
import software.amazon.awssdk.services.appstream.model.SessionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Session
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Session> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Session.getter(Session::id)).setter(Session.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Session.getter(Session::userId)).setter(Session.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Session.getter(Session::stackName)).setter(Session.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Session.getter(Session::fleetName)).setter(Session.setter(Builder::fleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Session.getter(Session::stateAsString)).setter(Session.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Session.getter(Session::connectionStateAsString)).setter(Session.setter(Builder::connectionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionState").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Session.getter(Session::startTime)).setter(Session.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> MAX_EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Session.getter(Session::maxExpirationTime)).setter(Session.setter(Builder::maxExpirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxExpirationTime").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Session.getter(Session::authenticationTypeAsString)).setter(Session.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build()}).build();
    private static final SdkField<NetworkAccessConfiguration> NETWORK_ACCESS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Session.getter(Session::networkAccessConfiguration)).setter(Session.setter(Builder::networkAccessConfiguration)).constructor(NetworkAccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAccessConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, USER_ID_FIELD, STACK_NAME_FIELD, FLEET_NAME_FIELD, STATE_FIELD, CONNECTION_STATE_FIELD, START_TIME_FIELD, MAX_EXPIRATION_TIME_FIELD, AUTHENTICATION_TYPE_FIELD, NETWORK_ACCESS_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String userId;
    private final String stackName;
    private final String fleetName;
    private final String state;
    private final String connectionState;
    private final Instant startTime;
    private final Instant maxExpirationTime;
    private final String authenticationType;
    private final NetworkAccessConfiguration networkAccessConfiguration;

    private Session(BuilderImpl builder) {
        this.id = builder.id;
        this.userId = builder.userId;
        this.stackName = builder.stackName;
        this.fleetName = builder.fleetName;
        this.state = builder.state;
        this.connectionState = builder.connectionState;
        this.startTime = builder.startTime;
        this.maxExpirationTime = builder.maxExpirationTime;
        this.authenticationType = builder.authenticationType;
        this.networkAccessConfiguration = builder.networkAccessConfiguration;
    }

    public String id() {
        return this.id;
    }

    public String userId() {
        return this.userId;
    }

    public String stackName() {
        return this.stackName;
    }

    public String fleetName() {
        return this.fleetName;
    }

    public SessionState state() {
        return SessionState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public SessionConnectionState connectionState() {
        return SessionConnectionState.fromValue(this.connectionState);
    }

    public String connectionStateAsString() {
        return this.connectionState;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant maxExpirationTime() {
        return this.maxExpirationTime;
    }

    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public NetworkAccessConfiguration networkAccessConfiguration() {
        return this.networkAccessConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxExpirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAccessConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.fleetName(), other.fleetName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.connectionStateAsString(), other.connectionStateAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.maxExpirationTime(), other.maxExpirationTime()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.networkAccessConfiguration(), other.networkAccessConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"Session").add("Id", (Object)this.id()).add("UserId", (Object)this.userId()).add("StackName", (Object)this.stackName()).add("FleetName", (Object)this.fleetName()).add("State", (Object)this.stateAsString()).add("ConnectionState", (Object)this.connectionStateAsString()).add("StartTime", (Object)this.startTime()).add("MaxExpirationTime", (Object)this.maxExpirationTime()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("NetworkAccessConfiguration", (Object)this.networkAccessConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "FleetName": {
                return Optional.ofNullable(clazz.cast(this.fleetName()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ConnectionState": {
                return Optional.ofNullable(clazz.cast(this.connectionStateAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "MaxExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.maxExpirationTime()));
            }
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "NetworkAccessConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkAccessConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Session, T> g) {
        return obj -> g.apply((Session)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String userId;
        private String stackName;
        private String fleetName;
        private String state;
        private String connectionState;
        private Instant startTime;
        private Instant maxExpirationTime;
        private String authenticationType;
        private NetworkAccessConfiguration networkAccessConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            this.id(model.id);
            this.userId(model.userId);
            this.stackName(model.stackName);
            this.fleetName(model.fleetName);
            this.state(model.state);
            this.connectionState(model.connectionState);
            this.startTime(model.startTime);
            this.maxExpirationTime(model.maxExpirationTime);
            this.authenticationType(model.authenticationType);
            this.networkAccessConfiguration(model.networkAccessConfiguration);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getFleetName() {
            return this.fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SessionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getConnectionStateAsString() {
            return this.connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(SessionConnectionState connectionState) {
            this.connectionState(connectionState.toString());
            return this;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getMaxExpirationTime() {
            return this.maxExpirationTime;
        }

        @Override
        public final Builder maxExpirationTime(Instant maxExpirationTime) {
            this.maxExpirationTime = maxExpirationTime;
            return this;
        }

        public final void setMaxExpirationTime(Instant maxExpirationTime) {
            this.maxExpirationTime = maxExpirationTime;
        }

        public final String getAuthenticationTypeAsString() {
            return this.authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        public final NetworkAccessConfiguration.Builder getNetworkAccessConfiguration() {
            return this.networkAccessConfiguration != null ? this.networkAccessConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkAccessConfiguration(NetworkAccessConfiguration networkAccessConfiguration) {
            this.networkAccessConfiguration = networkAccessConfiguration;
            return this;
        }

        public final void setNetworkAccessConfiguration(NetworkAccessConfiguration.BuilderImpl networkAccessConfiguration) {
            this.networkAccessConfiguration = networkAccessConfiguration != null ? networkAccessConfiguration.build() : null;
        }

        public Session build() {
            return new Session(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Session> {
        public Builder id(String var1);

        public Builder userId(String var1);

        public Builder stackName(String var1);

        public Builder fleetName(String var1);

        public Builder state(String var1);

        public Builder state(SessionState var1);

        public Builder connectionState(String var1);

        public Builder connectionState(SessionConnectionState var1);

        public Builder startTime(Instant var1);

        public Builder maxExpirationTime(Instant var1);

        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder networkAccessConfiguration(NetworkAccessConfiguration var1);

        default public Builder networkAccessConfiguration(Consumer<NetworkAccessConfiguration.Builder> networkAccessConfiguration) {
            return this.networkAccessConfiguration((NetworkAccessConfiguration)((NetworkAccessConfiguration.Builder)NetworkAccessConfiguration.builder().applyMutation(networkAccessConfiguration)).build());
        }
    }
}

