/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.services.appstream.model.SoftwareAssociations;
import software.amazon.awssdk.services.appstream.model.SoftwareAssociationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSoftwareAssociationsResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeSoftwareAssociationsResponse> {
    private static final SdkField<String> ASSOCIATED_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedResource").getter(DescribeSoftwareAssociationsResponse.getter(DescribeSoftwareAssociationsResponse::associatedResource)).setter(DescribeSoftwareAssociationsResponse.setter(Builder::associatedResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResource").build()}).build();
    private static final SdkField<List<SoftwareAssociations>> SOFTWARE_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SoftwareAssociations").getter(DescribeSoftwareAssociationsResponse.getter(DescribeSoftwareAssociationsResponse::softwareAssociations)).setter(DescribeSoftwareAssociationsResponse.setter(Builder::softwareAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SoftwareAssociations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSoftwareAssociationsResponse.getter(DescribeSoftwareAssociationsResponse::nextToken)).setter(DescribeSoftwareAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_RESOURCE_FIELD, SOFTWARE_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSoftwareAssociationsResponse.memberNameToFieldInitializer();
    private final String associatedResource;
    private final List<SoftwareAssociations> softwareAssociations;
    private final String nextToken;

    private DescribeSoftwareAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associatedResource = builder.associatedResource;
        this.softwareAssociations = builder.softwareAssociations;
        this.nextToken = builder.nextToken;
    }

    public final String associatedResource() {
        return this.associatedResource;
    }

    public final boolean hasSoftwareAssociations() {
        return this.softwareAssociations != null && !(this.softwareAssociations instanceof SdkAutoConstructList);
    }

    public final List<SoftwareAssociations> softwareAssociations() {
        return this.softwareAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSoftwareAssociations() ? this.softwareAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSoftwareAssociationsResponse)) {
            return false;
        }
        DescribeSoftwareAssociationsResponse other = (DescribeSoftwareAssociationsResponse)((Object)obj);
        return Objects.equals(this.associatedResource(), other.associatedResource()) && this.hasSoftwareAssociations() == other.hasSoftwareAssociations() && Objects.equals(this.softwareAssociations(), other.softwareAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSoftwareAssociationsResponse").add("AssociatedResource", (Object)this.associatedResource()).add("SoftwareAssociations", this.hasSoftwareAssociations() ? this.softwareAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociatedResource": {
                return Optional.ofNullable(clazz.cast(this.associatedResource()));
            }
            case "SoftwareAssociations": {
                return Optional.ofNullable(clazz.cast(this.softwareAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssociatedResource", ASSOCIATED_RESOURCE_FIELD);
        map.put("SoftwareAssociations", SOFTWARE_ASSOCIATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSoftwareAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeSoftwareAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private String associatedResource;
        private List<SoftwareAssociations> softwareAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSoftwareAssociationsResponse model) {
            super(model);
            this.associatedResource(model.associatedResource);
            this.softwareAssociations(model.softwareAssociations);
            this.nextToken(model.nextToken);
        }

        public final String getAssociatedResource() {
            return this.associatedResource;
        }

        public final void setAssociatedResource(String associatedResource) {
            this.associatedResource = associatedResource;
        }

        @Override
        public final Builder associatedResource(String associatedResource) {
            this.associatedResource = associatedResource;
            return this;
        }

        public final List<SoftwareAssociations.Builder> getSoftwareAssociations() {
            List<SoftwareAssociations.Builder> result = SoftwareAssociationsListCopier.copyToBuilder(this.softwareAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSoftwareAssociations(Collection<SoftwareAssociations.BuilderImpl> softwareAssociations) {
            this.softwareAssociations = SoftwareAssociationsListCopier.copyFromBuilder(softwareAssociations);
        }

        @Override
        public final Builder softwareAssociations(Collection<SoftwareAssociations> softwareAssociations) {
            this.softwareAssociations = SoftwareAssociationsListCopier.copy(softwareAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder softwareAssociations(SoftwareAssociations ... softwareAssociations) {
            this.softwareAssociations(Arrays.asList(softwareAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder softwareAssociations(Consumer<SoftwareAssociations.Builder> ... softwareAssociations) {
            this.softwareAssociations(Stream.of(softwareAssociations).map(c -> (SoftwareAssociations)((SoftwareAssociations.Builder)SoftwareAssociations.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSoftwareAssociationsResponse build() {
            return new DescribeSoftwareAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSoftwareAssociationsResponse> {
        public Builder associatedResource(String var1);

        public Builder softwareAssociations(Collection<SoftwareAssociations> var1);

        public Builder softwareAssociations(SoftwareAssociations ... var1);

        public Builder softwareAssociations(Consumer<SoftwareAssociations.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

