/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ApplicationConfig.getter(ApplicationConfig::name)).setter(ApplicationConfig.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(ApplicationConfig.getter(ApplicationConfig::displayName)).setter(ApplicationConfig.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> ABSOLUTE_APP_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AbsoluteAppPath").getter(ApplicationConfig.getter(ApplicationConfig::absoluteAppPath)).setter(ApplicationConfig.setter(Builder::absoluteAppPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbsoluteAppPath").build()}).build();
    private static final SdkField<String> ABSOLUTE_ICON_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AbsoluteIconPath").getter(ApplicationConfig.getter(ApplicationConfig::absoluteIconPath)).setter(ApplicationConfig.setter(Builder::absoluteIconPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbsoluteIconPath").build()}).build();
    private static final SdkField<String> ABSOLUTE_MANIFEST_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AbsoluteManifestPath").getter(ApplicationConfig.getter(ApplicationConfig::absoluteManifestPath)).setter(ApplicationConfig.setter(Builder::absoluteManifestPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbsoluteManifestPath").build()}).build();
    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkingDirectory").getter(ApplicationConfig.getter(ApplicationConfig::workingDirectory)).setter(ApplicationConfig.setter(Builder::workingDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingDirectory").build()}).build();
    private static final SdkField<String> LAUNCH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchParameters").getter(ApplicationConfig.getter(ApplicationConfig::launchParameters)).setter(ApplicationConfig.setter(Builder::launchParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DISPLAY_NAME_FIELD, ABSOLUTE_APP_PATH_FIELD, ABSOLUTE_ICON_PATH_FIELD, ABSOLUTE_MANIFEST_PATH_FIELD, WORKING_DIRECTORY_FIELD, LAUNCH_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String displayName;
    private final String absoluteAppPath;
    private final String absoluteIconPath;
    private final String absoluteManifestPath;
    private final String workingDirectory;
    private final String launchParameters;

    private ApplicationConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.absoluteAppPath = builder.absoluteAppPath;
        this.absoluteIconPath = builder.absoluteIconPath;
        this.absoluteManifestPath = builder.absoluteManifestPath;
        this.workingDirectory = builder.workingDirectory;
        this.launchParameters = builder.launchParameters;
    }

    public final String name() {
        return this.name;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String absoluteAppPath() {
        return this.absoluteAppPath;
    }

    public final String absoluteIconPath() {
        return this.absoluteIconPath;
    }

    public final String absoluteManifestPath() {
        return this.absoluteManifestPath;
    }

    public final String workingDirectory() {
        return this.workingDirectory;
    }

    public final String launchParameters() {
        return this.launchParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.absoluteAppPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.absoluteIconPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.absoluteManifestPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationConfig)) {
            return false;
        }
        ApplicationConfig other = (ApplicationConfig)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.absoluteAppPath(), other.absoluteAppPath()) && Objects.equals(this.absoluteIconPath(), other.absoluteIconPath()) && Objects.equals(this.absoluteManifestPath(), other.absoluteManifestPath()) && Objects.equals(this.workingDirectory(), other.workingDirectory()) && Objects.equals(this.launchParameters(), other.launchParameters());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationConfig").add("Name", (Object)this.name()).add("DisplayName", (Object)this.displayName()).add("AbsoluteAppPath", (Object)(this.absoluteAppPath() == null ? null : "*** Sensitive Data Redacted ***")).add("AbsoluteIconPath", (Object)(this.absoluteIconPath() == null ? null : "*** Sensitive Data Redacted ***")).add("AbsoluteManifestPath", (Object)(this.absoluteManifestPath() == null ? null : "*** Sensitive Data Redacted ***")).add("WorkingDirectory", (Object)(this.workingDirectory() == null ? null : "*** Sensitive Data Redacted ***")).add("LaunchParameters", (Object)(this.launchParameters() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "AbsoluteAppPath": {
                return Optional.ofNullable(clazz.cast(this.absoluteAppPath()));
            }
            case "AbsoluteIconPath": {
                return Optional.ofNullable(clazz.cast(this.absoluteIconPath()));
            }
            case "AbsoluteManifestPath": {
                return Optional.ofNullable(clazz.cast(this.absoluteManifestPath()));
            }
            case "WorkingDirectory": {
                return Optional.ofNullable(clazz.cast(this.workingDirectory()));
            }
            case "LaunchParameters": {
                return Optional.ofNullable(clazz.cast(this.launchParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Name", NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("AbsoluteAppPath", ABSOLUTE_APP_PATH_FIELD);
        map.put("AbsoluteIconPath", ABSOLUTE_ICON_PATH_FIELD);
        map.put("AbsoluteManifestPath", ABSOLUTE_MANIFEST_PATH_FIELD);
        map.put("WorkingDirectory", WORKING_DIRECTORY_FIELD);
        map.put("LaunchParameters", LAUNCH_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationConfig, T> g) {
        return obj -> g.apply((ApplicationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String displayName;
        private String absoluteAppPath;
        private String absoluteIconPath;
        private String absoluteManifestPath;
        private String workingDirectory;
        private String launchParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationConfig model) {
            this.name(model.name);
            this.displayName(model.displayName);
            this.absoluteAppPath(model.absoluteAppPath);
            this.absoluteIconPath(model.absoluteIconPath);
            this.absoluteManifestPath(model.absoluteManifestPath);
            this.workingDirectory(model.workingDirectory);
            this.launchParameters(model.launchParameters);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getAbsoluteAppPath() {
            return this.absoluteAppPath;
        }

        public final void setAbsoluteAppPath(String absoluteAppPath) {
            this.absoluteAppPath = absoluteAppPath;
        }

        @Override
        public final Builder absoluteAppPath(String absoluteAppPath) {
            this.absoluteAppPath = absoluteAppPath;
            return this;
        }

        public final String getAbsoluteIconPath() {
            return this.absoluteIconPath;
        }

        public final void setAbsoluteIconPath(String absoluteIconPath) {
            this.absoluteIconPath = absoluteIconPath;
        }

        @Override
        public final Builder absoluteIconPath(String absoluteIconPath) {
            this.absoluteIconPath = absoluteIconPath;
            return this;
        }

        public final String getAbsoluteManifestPath() {
            return this.absoluteManifestPath;
        }

        public final void setAbsoluteManifestPath(String absoluteManifestPath) {
            this.absoluteManifestPath = absoluteManifestPath;
        }

        @Override
        public final Builder absoluteManifestPath(String absoluteManifestPath) {
            this.absoluteManifestPath = absoluteManifestPath;
            return this;
        }

        public final String getWorkingDirectory() {
            return this.workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final String getLaunchParameters() {
            return this.launchParameters;
        }

        public final void setLaunchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
        }

        @Override
        public final Builder launchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
            return this;
        }

        public ApplicationConfig build() {
            return new ApplicationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationConfig> {
        public Builder name(String var1);

        public Builder displayName(String var1);

        public Builder absoluteAppPath(String var1);

        public Builder absoluteIconPath(String var1);

        public Builder absoluteManifestPath(String var1);

        public Builder workingDirectory(String var1);

        public Builder launchParameters(String var1);
    }
}

